/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.security.Principal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import javax.ejb.EJBException;
import javax.ejb.EJBLocalObject;
import javax.ejb.EJBObject;
import javax.ejb.Handle;
import javax.ejb.RemoveException;
import javax.management.ObjectName;
import org.jboss.ejb.AllowedOperationsAssociation;
import org.jboss.ejb.BeanLock;
import org.jboss.ejb.Container;
import org.jboss.ejb.EJBProxyFactory;
import org.jboss.ejb.EJBProxyFactoryContainer;
import org.jboss.ejb.EnterpriseContext;
import org.jboss.ejb.InstanceCache;
import org.jboss.ejb.InstancePoolContainer;
import org.jboss.ejb.Interceptor;
import org.jboss.ejb.SessionContainer;
import org.jboss.ejb.StatefulSessionContainerMBean;
import org.jboss.ejb.StatefulSessionEnterpriseContext;
import org.jboss.ejb.StatefulSessionPersistenceManager;
import org.jboss.ejb.plugins.StatefulSessionInstanceCache;
import org.jboss.invocation.Invocation;
import org.jboss.invocation.InvocationType;
import org.jboss.security.SimplePrincipal;
import org.jboss.util.UnexpectedThrowable;
import org.jboss.util.UnreachableStatementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatefulSessionContainer
extends SessionContainer
implements EJBProxyFactoryContainer,
InstancePoolContainer,
StatefulSessionContainerMBean {
    protected StatefulSessionPersistenceManager persistenceManager;
    protected InstanceCache instanceCache;
    protected Method getEJBObject;
    protected Method ejbObjectRemove;
    protected Method ejbLocalObjectRemove;

    public void setInstanceCache(InstanceCache ic) {
        this.instanceCache = ic;
    }

    public InstanceCache getInstanceCache() {
        return this.instanceCache;
    }

    @Override
    public long getPassivatedCount() {
        if (!(this.instanceCache instanceof StatefulSessionInstanceCache)) {
            throw new UnsupportedOperationException();
        }
        return ((StatefulSessionInstanceCache)this.instanceCache).getPassivatedCount();
    }

    public StatefulSessionPersistenceManager getPersistenceManager() {
        return this.persistenceManager;
    }

    public void setPersistenceManager(StatefulSessionPersistenceManager pm) {
        this.persistenceManager = pm;
    }

    @Override
    public Set<Principal> getMethodPermissions(Method m, InvocationType iface) {
        if (!m.equals(this.getEJBObject)) {
            return super.getMethodPermissions(m, iface);
        }
        Class[] sig = new Class[]{};
        Set permissions = this.getBeanMetaData().getMethodPermissions("create", sig, iface);
        HashSet<Principal> principalSet = new HashSet<Principal>();
        for (String perm : permissions) {
            principalSet.add((Principal)new SimplePrincipal(perm));
        }
        return principalSet;
    }

    @Override
    protected void createService() throws Exception {
        super.createService();
        try {
            this.getEJBObject = Handle.class.getMethod("getEJBObject", new Class[0]);
        }
        catch (Exception e) {
            this.log.warn((Object)"Failed to grant access to the Handle.getEJBObject method");
        }
        this.ejbObjectRemove = EJBObject.class.getMethod("remove", null);
        this.ejbLocalObjectRemove = EJBLocalObject.class.getMethod("remove", null);
    }

    @Override
    protected void createInstanceCache() throws Exception {
        try {
            ObjectName containerName = super.getJmxName();
            Hashtable<String, String> props = containerName.getKeyPropertyList();
            props.put("plugin", "cache");
            ObjectName cacheName = new ObjectName(containerName.getDomain(), props);
            this.server.registerMBean(this.instanceCache, cacheName);
        }
        catch (Throwable t) {
            this.log.debug((Object)"Failed to register cache as mbean", t);
        }
        this.instanceCache.setContainer(this);
        this.instanceCache.create();
    }

    @Override
    protected void createPersistenceManager() throws Exception {
        this.persistenceManager.setContainer(this);
        this.persistenceManager.create();
    }

    @Override
    protected void startPersistenceManager() throws Exception {
        this.persistenceManager.start();
    }

    @Override
    protected void startInstanceCache() throws Exception {
        this.instanceCache.start();
    }

    @Override
    protected void stopPersistenceManager() {
        this.persistenceManager.stop();
    }

    @Override
    protected void stopInstanceCache() {
        this.instanceCache.stop();
    }

    @Override
    protected void destroyPersistenceManager() {
        this.persistenceManager.destroy();
        this.persistenceManager.setContainer(null);
    }

    @Override
    protected void destroyInstanceCache() {
        this.instanceCache.destroy();
        this.instanceCache.setContainer(null);
        try {
            ObjectName containerName = super.getJmxName();
            Hashtable<String, String> props = containerName.getKeyPropertyList();
            props.put("plugin", "cache");
            ObjectName cacheName = new ObjectName(containerName.getDomain(), props);
            this.server.unregisterMBean(cacheName);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Invocation mi) throws RemoteException, RemoveException {
        StatefulSessionEnterpriseContext ctx = (StatefulSessionEnterpriseContext)mi.getEnterpriseContext();
        if (ctx.getId() == null) {
            throw new RemoveException("SFSB has been removed already");
        }
        try {
            AllowedOperationsAssociation.pushInMethodFlag(IN_EJB_REMOVE);
            this.getPersistenceManager().removeSession(ctx);
        }
        finally {
            AllowedOperationsAssociation.popInMethodFlag();
        }
        ctx.setId(null);
        ++this.removeCount;
    }

    private void createSession(Method m, Object[] args, StatefulSessionEnterpriseContext ctx) throws Exception {
        Object id = this.getPersistenceManager().createId(ctx);
        this.log.debug((Object)("Created new session ID: " + id));
        ctx.setId(id);
        try {
            AllowedOperationsAssociation.pushInMethodFlag(IN_EJB_CREATE);
            String createName = m.getName();
            Object instance = ctx.getInstance();
            String ejbCreateName = "ejbC" + createName.substring(1);
            Method createMethod = instance.getClass().getMethod(ejbCreateName, m.getParameterTypes());
            this.log.debug((Object)("Using create method for session: " + createMethod));
            createMethod.invoke(instance, args);
            ++this.createCount;
        }
        catch (IllegalAccessException e) {
            ctx.setId(null);
            throw new EJBException((Exception)e);
        }
        catch (InvocationTargetException e) {
            ctx.setId(null);
            Throwable t = e.getTargetException();
            if (t instanceof RuntimeException) {
                if (t instanceof EJBException) {
                    throw (EJBException)t;
                }
                throw new EJBException((Exception)t);
            }
            if (t instanceof Exception) {
                throw (Exception)t;
            }
            if (t instanceof Error) {
                throw (Error)t;
            }
            throw new UnexpectedThrowable(t);
        }
        finally {
            AllowedOperationsAssociation.popInMethodFlag();
        }
        this.getPersistenceManager().createdSession(ctx);
        this.getInstanceCache().insert(ctx);
        if (this.getProxyFactory() != null) {
            ctx.setEJBObject((EJBObject)this.getProxyFactory().getStatefulSessionEJBObject(id));
        }
        if (this.getLocalHomeClass() != null) {
            ctx.setEJBLocalObject(this.getLocalProxyFactory().getStatefulSessionEJBLocalObject(id));
        }
    }

    public EJBObject createHome(Invocation mi) throws Exception {
        StatefulSessionEnterpriseContext ctx = (StatefulSessionEnterpriseContext)mi.getEnterpriseContext();
        this.createSession(mi.getMethod(), mi.getArguments(), ctx);
        return ctx.getEJBObject();
    }

    public void removeLocalHome(Invocation mi) throws RemoteException, RemoveException {
        throw new UnreachableStatementException();
    }

    public EJBLocalObject createLocalHome(Invocation mi) throws Exception {
        StatefulSessionEnterpriseContext ctx = (StatefulSessionEnterpriseContext)mi.getEnterpriseContext();
        this.createSession(mi.getMethod(), mi.getArguments(), ctx);
        return ctx.getEJBLocalObject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EJBObject getEJBObject(Invocation mi) throws RemoteException {
        EJBProxyFactory ci = this.getProxyFactory();
        if (ci == null) {
            String msg = "No ProxyFactory, check for ProxyFactoryFinderInterceptor";
            throw new IllegalStateException(msg);
        }
        Object id = mi.getArguments()[0];
        if (id == null) {
            throw new IllegalStateException("Cannot get a session interface with a null id");
        }
        InstanceCache cache = this.getInstanceCache();
        BeanLock lock = this.getLockManager().getLock(id);
        lock.sync();
        try {
            if (cache.get(id) == null) {
                throw new RemoteException("Session no longer exists: " + id);
            }
        }
        finally {
            lock.releaseSync();
            this.getLockManager().removeLockRef(id);
        }
        return (EJBObject)ci.getStatefulSessionEJBObject(id);
    }

    public void removeHome(Invocation mi) throws RemoteException, RemoveException {
        throw new Error("Not Yet Implemented");
    }

    @Override
    public String getBeanTypeName() {
        return "StatefulSession";
    }

    @Override
    protected void setupHomeMapping() throws Exception {
        int i;
        Method[] m;
        boolean isEJB1x = this.metaData.getApplicationMetaData().isEJB1x();
        HashMap<Method, Method> map = new HashMap<Method, Method>();
        if (this.homeInterface != null) {
            m = this.homeInterface.getMethods();
            for (i = 0; i < m.length; ++i) {
                try {
                    if (!isEJB1x && m[i].getName().startsWith("create")) {
                        map.put(m[i], this.getClass().getMethod("createHome", Invocation.class));
                        continue;
                    }
                    map.put(m[i], this.getClass().getMethod(m[i].getName() + "Home", Invocation.class));
                    continue;
                }
                catch (NoSuchMethodException e) {
                    this.log.info((Object)(m[i].getName() + " in bean has not been mapped"));
                }
            }
        }
        if (this.localHomeInterface != null) {
            m = this.localHomeInterface.getMethods();
            for (i = 0; i < m.length; ++i) {
                try {
                    if (!isEJB1x && m[i].getName().startsWith("create")) {
                        map.put(m[i], this.getClass().getMethod("createLocalHome", Invocation.class));
                        continue;
                    }
                    map.put(m[i], this.getClass().getMethod(m[i].getName() + "LocalHome", Invocation.class));
                    continue;
                }
                catch (NoSuchMethodException e) {
                    this.log.info((Object)(m[i].getName() + " in bean has not been mapped"));
                }
            }
        }
        try {
            Class<?> handleClass = Class.forName("javax.ejb.Handle");
            Method getEJBObjectMethod = handleClass.getMethod("getEJBObject", new Class[0]);
            map.put(getEJBObjectMethod, this.getClass().getMethod("getEJBObject", Invocation.class));
        }
        catch (NoSuchMethodException e) {
            this.log.debug((Object)"Couldn't find getEJBObject method on container");
        }
        this.homeMapping = map;
    }

    @Override
    protected Interceptor createContainerInterceptor() {
        return new ContainerInterceptor();
    }

    class ContainerInterceptor
    extends Container.AbstractContainerInterceptor {
        ContainerInterceptor() {
            super(StatefulSessionContainer.this);
        }

        public Object invokeHome(Invocation mi) throws Exception {
            boolean trace = this.log.isTraceEnabled();
            if (trace) {
                this.log.trace((Object)"HOMEMETHOD coming in ");
                this.log.trace((Object)("" + mi.getMethod()));
                this.log.trace((Object)("HOMEMETHOD coming in hashcode" + mi.getMethod().hashCode()));
                this.log.trace((Object)("HOMEMETHOD coming in classloader" + mi.getMethod().getDeclaringClass().getClassLoader().hashCode()));
                this.log.trace((Object)("CONTAINS " + StatefulSessionContainer.this.getHomeMapping().containsKey(mi.getMethod())));
            }
            Method miMethod = mi.getMethod();
            Method m = (Method)StatefulSessionContainer.this.getHomeMapping().get(miMethod);
            if (m == null) {
                String msg = "Invalid invocation, check your deployment packaging, method=" + miMethod;
                throw new EJBException(msg);
            }
            if (trace) {
                this.log.trace((Object)("HOMEMETHOD m " + m));
                for (Method me : StatefulSessionContainer.this.getHomeMapping().keySet()) {
                    if (!me.getName().endsWith("create")) continue;
                    this.log.trace((Object)me.toString());
                    this.log.trace((Object)("" + me.hashCode()));
                    this.log.trace((Object)("" + me.getDeclaringClass().getClassLoader().hashCode()));
                    this.log.trace((Object)("equals " + me.equals(mi.getMethod()) + " " + mi.getMethod().equals(me)));
                }
            }
            try {
                return mi.performCall(StatefulSessionContainer.this, m, new Object[]{mi});
            }
            catch (Exception e) {
                this.rethrow(e);
                throw new UnreachableStatementException();
            }
        }

        public Object invoke(Invocation mi) throws Exception {
            Method miMethod = mi.getMethod();
            Method m = (Method)StatefulSessionContainer.this.getBeanMapping().get(miMethod);
            if (m == null) {
                String msg = "Invalid invocation, check your deployment packaging, method=" + miMethod;
                throw new EJBException(msg);
            }
            EnterpriseContext ctx = (EnterpriseContext)mi.getEnterpriseContext();
            if (ctx.getTransaction() == null) {
                ctx.setTransaction(mi.getTransaction());
            } else if (StatefulSessionContainer.this.ejbObjectRemove.equals(miMethod) || StatefulSessionContainer.this.ejbLocalObjectRemove.equals(miMethod)) {
                throw new RemoveException("An attempt to remove a session object while the object is in a transaction (EJB2.1, 7.6.4 Restrictions for Transactions): ejb-name=" + StatefulSessionContainer.this.metaData.getEjbName() + ", method=" + mi.getMethod() + ", tx=" + ctx.getTransaction());
            }
            if (m.getDeclaringClass().equals(StatefulSessionContainer.class) || m.getDeclaringClass().equals(SessionContainer.class)) {
                try {
                    return mi.performCall(StatefulSessionContainer.this, m, new Object[]{mi});
                }
                catch (Exception e) {
                    this.rethrow(e);
                }
            } else {
                try {
                    Object bean = ctx.getInstance();
                    return mi.performCall(bean, m, mi.getArguments());
                }
                catch (Exception e) {
                    this.rethrow(e);
                }
            }
            throw new UnreachableStatementException();
        }
    }
}

