/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.varia.scheduler;

import java.security.InvalidParameterException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.StringTokenizer;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.naming.InitialContext;
import javax.sql.DataSource;
import org.jboss.varia.scheduler.AbstractScheduleProvider;
import org.jboss.varia.scheduler.DBScheduleProviderMBean;

public class DBScheduleProvider
extends AbstractScheduleProvider
implements DBScheduleProviderMBean {
    private String mDataSourceName;
    private String mSQLStatement;
    private ArrayList mIDList = new ArrayList();

    public String getDataSourceName() {
        return this.mDataSourceName;
    }

    public void setDataSourceName(String pDataSourceName) {
        this.mDataSourceName = pDataSourceName;
    }

    public String getSQLStatement() {
        return this.mSQLStatement;
    }

    public void setSQLStatement(String pSQLStatement) {
        this.mSQLStatement = pSQLStatement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startProviding() throws Exception {
        Connection lConnection = null;
        Statement lStatement = null;
        try {
            Object lTemp = new InitialContext().lookup(this.mDataSourceName);
            DataSource lDB = (DataSource)lTemp;
            lConnection = lDB.getConnection();
            lStatement = lConnection.prepareStatement(this.mSQLStatement);
            ResultSet lResult = lStatement.executeQuery();
            while (lResult.next()) {
                int lID = this.addSchedule(new ObjectName(lResult.getString(1)), lResult.getString(2), this.getSignature(lResult.getString(3)), this.getStartDate(lResult.getString(4), lResult.getString(7)), lResult.getLong(5), lResult.getInt(6));
                this.mIDList.add(new Integer(lID));
            }
        }
        finally {
            if (lStatement != null) {
                try {
                    lStatement.close();
                }
                catch (Exception e) {}
            }
            if (lConnection != null) {
                try {
                    lConnection.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public void stopProviding() {
        for (Integer lID : this.mIDList) {
            try {
                this.removeSchedule(lID);
            }
            catch (JMException jme) {
                this.log.error((Object)"Could not remove Schedule in stop providing", (Throwable)jme);
            }
        }
    }

    protected String[] getSignature(String pMethodSignature) {
        if (pMethodSignature == null || "".equals(pMethodSignature.trim())) {
            return new String[0];
        }
        StringTokenizer lTokenizer = new StringTokenizer(pMethodSignature, ",");
        String[] lReturn = new String[lTokenizer.countTokens()];
        int i = 0;
        while (lTokenizer.hasMoreTokens()) {
            lReturn[i++] = lTokenizer.nextToken().trim();
        }
        return lReturn;
    }

    protected Date getStartDate(String pStartDate, String dateFormat) {
        pStartDate = pStartDate == null ? "" : pStartDate.trim();
        Date lReturn = null;
        if (pStartDate.equals("")) {
            lReturn = new Date(0L);
        } else if (pStartDate.equals("NOW")) {
            lReturn = new Date(new Date().getTime() + 1000L);
        } else {
            try {
                long lDate = new Long(pStartDate);
                lReturn = new Date(lDate);
            }
            catch (Exception e) {
                try {
                    SimpleDateFormat dateFormatter = null;
                    dateFormatter = dateFormat == null || dateFormat.trim().length() == 0 ? new SimpleDateFormat() : new SimpleDateFormat(dateFormat);
                    lReturn = dateFormatter.parse(pStartDate);
                }
                catch (Exception e2) {
                    this.log.error((Object)("Could not parse given date string: " + pStartDate), (Throwable)e2);
                    throw new InvalidParameterException("Schedulable Date is not of correct format");
                }
            }
        }
        this.log.debug((Object)("Initial Start Date is set to: " + lReturn));
        return lReturn;
    }

    public ObjectName getObjectName(MBeanServer pServer, ObjectName pName) throws MalformedObjectNameException {
        return pName == null ? DBScheduleProviderMBean.OBJECT_NAME : pName;
    }
}

