/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.reflect.plugins.javassist;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashSet;
import java.util.Set;
import org.jboss.reflect.plugins.javassist.JavassistConstructor;
import org.jboss.reflect.plugins.javassist.JavassistConstructorInfo;
import org.jboss.reflect.plugins.javassist.JavassistField;
import org.jboss.reflect.plugins.javassist.JavassistFieldInfo;
import org.jboss.reflect.plugins.javassist.JavassistMethod;
import org.jboss.reflect.plugins.javassist.JavassistMethodInfo;
import org.jboss.reflect.plugins.javassist.JavassistUtil;
import org.jboss.reflect.plugins.javassist.SecurityActions;
import org.jboss.reflect.plugins.javassist.bytecode.JavassistMemberFactory;
import org.jboss.reflect.plugins.javassist.defaultmember.DefaultMemberFactory;
import org.jboss.reflect.plugins.javassist.metrics.MetricsJavassistConstructor;
import org.jboss.reflect.plugins.javassist.metrics.MetricsJavassistField;
import org.jboss.reflect.plugins.javassist.metrics.MetricsJavassistMethod;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavassistReflectionFactory {
    public static final JavassistReflectionFactory INSTANCE;
    private static final boolean debug;
    private static final boolean enableMetrics;
    private static final Set<String> forceGenerate;
    protected static final Class<?> MAGIC_ACCESSOR_IMPL;

    private static boolean initBooleanProperty(final String name) {
        return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return Boolean.getBoolean(name);
            }
        });
    }

    public void addForceGenerate(String s) {
        forceGenerate.add(s);
    }

    public void removeForceGenerate(String s) {
        forceGenerate.remove(s);
    }

    private static Set<String> initForceGenerate(String name) {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<Set<String>>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Set<String> run() throws Exception {
                    String generateFile = System.getProperty(JavassistReflectionFactory.class.getName() + ".file", null);
                    HashSet<String> forceGenerate = new HashSet<String>();
                    if (generateFile != null) {
                        File file = new File(generateFile);
                        if (!file.exists()) {
                            throw new IllegalArgumentException("No file called '" + generateFile + "' specified via -D" + JavassistReflectionFactory.class.getName() + ".file");
                        }
                        BufferedReader in = null;
                        try {
                            in = new BufferedReader(new FileReader(file));
                            String s = in.readLine();
                            while (s != null) {
                                if ((s = s.trim()).length() > 0) {
                                    forceGenerate.add(s);
                                }
                                s = in.readLine();
                            }
                        }
                        finally {
                            try {
                                in.close();
                            }
                            catch (Exception ignore) {}
                        }
                    }
                    return forceGenerate;
                }
            });
        }
        catch (PrivilegedActionException e) {
            if (e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            throw new RuntimeException(e.getCause());
        }
    }

    private JavassistReflectionFactory() {
    }

    public JavassistMethod createMethod(JavassistMethodInfo info) throws Throwable {
        JavassistMethod method;
        String sig = JavassistUtil.getSignature(info.getCtMethod());
        JavassistMethod javassistMethod = method = this.generateAccessor(sig) ? JavassistMemberFactory.createJavassistMethod(MAGIC_ACCESSOR_IMPL, info, debug) : DefaultMemberFactory.createJavassistMethod(info);
        if (enableMetrics) {
            method = new MetricsJavassistMethod(method, sig);
        }
        return method;
    }

    public JavassistConstructor createConstructor(JavassistConstructorInfo info) throws Throwable {
        JavassistConstructor ctor;
        String sig = JavassistUtil.getSignature(info.getCtConstructor());
        JavassistConstructor javassistConstructor = ctor = this.generateAccessor(sig) ? JavassistMemberFactory.createJavassistConstructor(MAGIC_ACCESSOR_IMPL, info, debug) : DefaultMemberFactory.createJavassistConstructor(info);
        if (enableMetrics) {
            ctor = new MetricsJavassistConstructor(ctor, sig);
        }
        return ctor;
    }

    public JavassistField createField(JavassistFieldInfo info) throws Throwable {
        JavassistField field;
        String sig = JavassistUtil.getSignature(info.getCtField());
        JavassistField javassistField = field = this.generateAccessor(sig) ? JavassistMemberFactory.createJavassistField(MAGIC_ACCESSOR_IMPL, info, debug) : DefaultMemberFactory.createJavassistField(info);
        if (enableMetrics) {
            field = new MetricsJavassistField(field, sig);
        }
        return field;
    }

    private boolean generateAccessor(String signature) {
        if (forceGenerate.isEmpty()) {
            return true;
        }
        return forceGenerate.contains(signature);
    }

    static {
        debug = JavassistReflectionFactory.initBooleanProperty(JavassistReflectionFactory.class.getName() + ".debug");
        enableMetrics = JavassistReflectionFactory.initBooleanProperty(JavassistReflectionFactory.class.getName() + ".enableMetrics");
        forceGenerate = JavassistReflectionFactory.initForceGenerate(JavassistReflectionFactory.class.getName() + ".file");
        INSTANCE = new JavassistReflectionFactory();
        try {
            MAGIC_ACCESSOR_IMPL = SecurityActions.classForName("sun.reflect.MagicAccessorImpl");
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }
}

