/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.reflect.plugins.introspection;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ReflectPermission;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import org.jboss.reflect.plugins.MethodInfoImpl;
import org.jboss.reflect.plugins.introspection.ReflectionUtils;
import org.jboss.reflect.spi.AnnotationValue;
import org.jboss.reflect.spi.ClassInfo;
import org.jboss.reflect.spi.ParameterInfo;
import org.jboss.reflect.spi.TypeInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReflectMethodInfoImpl
extends MethodInfoImpl {
    private static final long serialVersionUID = 2L;
    private static Permission accessCheck = new ReflectPermission("suppressAccessChecks");
    protected volatile transient Method method;

    public ReflectMethodInfoImpl() {
    }

    public ReflectMethodInfoImpl(AnnotationValue[] annotations, String name, TypeInfo returnType, TypeInfo[] parameterTypes, AnnotationValue[][] parameterAnnotations, ClassInfo[] exceptionTypes, int modifiers, ClassInfo declaring) {
        super(annotations, name, returnType, parameterTypes, parameterAnnotations, exceptionTypes, modifiers, declaring);
    }

    public ReflectMethodInfoImpl(AnnotationValue[] annotations, String name, TypeInfo returnType, ParameterInfo[] parameters, ClassInfo[] exceptionTypes, int modifiers, ClassInfo declaring) {
        super(annotations, name, returnType, parameters, exceptionTypes, modifiers, declaring);
    }

    public void setMethod(Method method) {
        boolean isDeclaringClassPublic = true;
        if (method != null) {
            this.accessCheck(Modifier.isPublic(method.getModifiers()));
            isDeclaringClassPublic = ReflectMethodInfoImpl.isDeclaringClassPublic(method);
            this.accessCheck(isDeclaringClassPublic);
        }
    }

    public Method getMethod() {
        this.accessCheck();
        if (this.method == null) {
            this.initMethod();
        }
        return this.method;
    }

    protected static boolean isDeclaringClassPublic(Method method) {
        Class<?> owner = method.getDeclaringClass();
        return Modifier.isPublic(owner.getModifiers());
    }

    protected final void accessCheck() {
        this.accessCheck(this.isPublic() && (this.method == null || ReflectMethodInfoImpl.isDeclaringClassPublic(this.method)));
    }

    protected final void accessCheck(boolean isPublic) {
        SecurityManager sm;
        if (!isPublic && (sm = System.getSecurityManager()) != null) {
            sm.checkPermission(accessCheck);
        }
    }

    @Override
    public Object invoke(Object target, Object[] args) throws Throwable {
        if (this.method == null) {
            this.initMethod();
        }
        this.accessCheck();
        return ReflectionUtils.invoke(this.method, target, args);
    }

    private void setAccessible() {
        SecurityManager sm = System.getSecurityManager();
        if (sm == null) {
            this.method.setAccessible(true);
        } else {
            AccessController.doPrivileged(new SetAccessible());
        }
    }

    protected synchronized void initMethod() {
        int length = this.parameterTypes != null ? this.parameterTypes.length : 0;
        Class[] classes = new Class[length];
        for (int i = 0; i < length; ++i) {
            classes[i] = this.parameterTypes[i].getType();
        }
        try {
            this.method = this.findMethod(classes);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        if (!(this.method == null || this.isPublic() && ReflectMethodInfoImpl.isDeclaringClassPublic(this.method))) {
            this.setAccessible();
        }
    }

    private Method findMethod(final Class<?>[] classes) throws NoSuchMethodException {
        if (System.getSecurityManager() == null) {
            return ReflectionUtils.findExactMethod(this.getDeclaringClass().getType(), this.name, classes);
        }
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<Method>(){

                @Override
                public Method run() throws Exception {
                    return ReflectionUtils.findExactMethod(ReflectMethodInfoImpl.this.getDeclaringClass().getType(), ReflectMethodInfoImpl.this.name, classes);
                }
            });
        }
        catch (PrivilegedActionException e) {
            if (e.getCause() instanceof NoSuchMethodException) {
                throw (NoSuchMethodException)e.getCause();
            }
            if (e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            throw new RuntimeException(e.getCause());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SetAccessible
    implements PrivilegedAction<Object> {
        private SetAccessible() {
        }

        @Override
        public Object run() {
            ReflectMethodInfoImpl.this.method.setAccessible(true);
            return null;
        }
    }
}

