/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.reflect.plugins.bytecode.bytes.asm;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.jboss.reflect.plugins.bytecode.bytes.ClassBytes;
import org.jboss.reflect.plugins.bytecode.bytes.ConstructorBytes;
import org.jboss.reflect.plugins.bytecode.bytes.FieldBytes;
import org.jboss.reflect.plugins.bytecode.bytes.MethodBytes;
import org.jboss.reflect.plugins.bytecode.bytes.PrimitiveBytes;
import org.jboss.reflect.plugins.bytecode.bytes.asm.AsmConstructorBytes;
import org.jboss.reflect.plugins.bytecode.bytes.asm.AsmFieldBytes;
import org.jboss.reflect.plugins.bytecode.bytes.asm.AsmMethodBytes;
import org.jboss.reflect.plugins.bytecode.bytes.asm.ClassReaderCache;
import org.jboss.reflect.plugins.bytecode.bytes.asm.ClassReaderCacheFactory;
import org.jboss.reflect.plugins.bytecode.bytes.asm.Util;
import org.jboss.reflect.util.objectweb.asm.AnnotationVisitor;
import org.jboss.reflect.util.objectweb.asm.ClassReader;
import org.jboss.reflect.util.objectweb.asm.FieldVisitor;
import org.jboss.reflect.util.objectweb.asm.MethodVisitor;
import org.jboss.reflect.util.objectweb.asm.commons.EmptyVisitor;
import org.jboss.util.JBossObject;
import org.jboss.util.JBossStringBuilder;

class AsmClassBytes
extends JBossObject
implements ClassBytes {
    static final int STANDARD_FLAGS = 167;
    static final int READ_FIELD_FLAGS = 1191;
    static final ClassReaderCacheFactory CACHE_FACTORY = ClassReaderCacheFactory.createFromProperties();
    static final FieldBytes[] NO_FIELDS = new FieldBytes[0];
    static final MethodBytes[] NO_METHODS = new MethodBytes[0];
    static final ConstructorBytes[] NO_CONSTRUCTORS = new ConstructorBytes[0];
    static final Annotation[] NO_ANNOTATIONS = new Annotation[0];
    private final ClassReaderHolder readerHolder;
    private WeakReference<ClassLoader> loader;
    private final URL url;
    private final String jvmName;
    private volatile int modifiers = Integer.MIN_VALUE;
    private volatile ConstructorBytes[] constructorBytes;
    private volatile MethodBytes[] methodBytes;
    private volatile FieldBytes[] fieldBytes;

    public AsmClassBytes(ClassLoader loader, URL url, String name) {
        this.loader = new WeakReference<ClassLoader>(loader);
        this.jvmName = name;
        this.url = url;
        this.readerHolder = CACHE_FACTORY == null ? new HardReferenceClassReaderHolder() : new CachingClassReaderHolder();
    }

    ClassReader getReader() {
        return this.readerHolder.getClassReader();
    }

    public ConstructorBytes[] getDeclaredConstructorBytes() {
        if (this.constructorBytes == null) {
            this.initMethodsAndConstructors();
        }
        return this.constructorBytes;
    }

    public FieldBytes[] getDeclaredFieldBytes() {
        if (this.fieldBytes == null) {
            FieldsVisitor visitor = new FieldsVisitor();
            this.getReader().accept(visitor, 1191);
            this.fieldBytes = visitor.getFieldBytes();
        }
        return this.fieldBytes;
    }

    public MethodBytes[] getDeclaredMethodBytes() {
        if (this.methodBytes == null) {
            this.initMethodsAndConstructors();
        }
        return this.methodBytes;
    }

    public String[] getInterfaceJvmNames() {
        return this.getReader().getInterfaces();
    }

    public String[] getInterfaceTypeInfoNames() {
        String[] jvmNames = this.getInterfaceJvmNames();
        if (jvmNames == null || jvmNames.length == 0) {
            return jvmNames;
        }
        String[] typeInfoNames = new String[jvmNames.length];
        for (int i = 0; i < typeInfoNames.length; ++i) {
            typeInfoNames[i] = Util.jvmNameToTypeInfoName(jvmNames[i]);
        }
        return typeInfoNames;
    }

    public String getSuperClassJvmName() {
        return this.getReader().getSuperName();
    }

    public String getSuperClassTypeInfoName() {
        String superName = this.getSuperClassJvmName();
        if (superName == null) {
            return null;
        }
        return Util.jvmNameToTypeInfoName(superName);
    }

    public boolean isAnnotation() {
        return (this.getModifiers() & 0x2000) != 0;
    }

    public boolean isArray() {
        return false;
    }

    public boolean isEnum() {
        return (this.getModifiers() & 0x4000) != 0;
    }

    public boolean isInterface() {
        return (this.getModifiers() & 0x200) != 0;
    }

    public int getModifiers() {
        if (this.modifiers != Integer.MIN_VALUE) {
            return this.modifiers;
        }
        int mods = this.getReader().getAccess();
        if ((mods & 0x20) == 32) {
            mods ^= 0x20;
        }
        this.modifiers = mods;
        return this.modifiers;
    }

    public String getJvmName() {
        return this.jvmName;
    }

    public String getTypeInfoName() {
        return Util.jvmNameToTypeInfoName(this.jvmName);
    }

    public ClassLoader getClassLoader() {
        return (ClassLoader)this.loader.get();
    }

    public String getGenericSignature() {
        ClassSignatureVisitor visitor = new ClassSignatureVisitor();
        this.getReader().accept(visitor, 423);
        return visitor.getSignature();
    }

    public Annotation[] getAnnotations() {
        AnnotationsVisitor visitor = new AnnotationsVisitor();
        this.getReader().accept(visitor, 679);
        return visitor.getAnnotations();
    }

    private void initMethodsAndConstructors() {
        ConstructorAndMethodsVisitor visitor = new ConstructorAndMethodsVisitor();
        this.getReader().accept(visitor, 8359);
        this.methodBytes = visitor.getMethodBytes();
        this.constructorBytes = visitor.getConstructorBytes();
    }

    public ClassBytes getComponentType() {
        return null;
    }

    public PrimitiveBytes getPrimitive() {
        return null;
    }

    public void toShortString(JBossStringBuilder buffer) {
        buffer.append(this.getJvmName());
    }

    protected void toString(JBossStringBuilder buffer) {
        this.toShortString(buffer);
    }

    private class CachingClassReaderHolder
    extends AbstractClassReaderHolder {
        final ClassReaderCache cache;

        public CachingClassReaderHolder() {
            this.cache = CACHE_FACTORY.createCache();
        }

        public ClassReader getClassReader() {
            ClassReader reader = this.cache.get(AsmClassBytes.this.jvmName);
            if (reader == null) {
                reader = this.loadClassReader();
                this.cache.put(AsmClassBytes.this.jvmName, reader);
            }
            return reader;
        }
    }

    private class HardReferenceClassReaderHolder
    extends AbstractClassReaderHolder {
        volatile ClassReader reader;

        private HardReferenceClassReaderHolder() {
        }

        public ClassReader getClassReader() {
            if (this.reader == null) {
                this.reader = this.loadClassReader();
            }
            return this.reader;
        }
    }

    private abstract class AbstractClassReaderHolder
    implements ClassReaderHolder {
        private AbstractClassReaderHolder() {
        }

        protected ClassReader loadClassReader() {
            InputStream in = null;
            try {
                in = new BufferedInputStream(AsmClassBytes.this.url.openStream());
                ClassReader classReader = new ClassReader(in);
                return classReader;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            finally {
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (IOException ignoree) {}
            }
        }
    }

    private static interface ClassReaderHolder {
        public ClassReader getClassReader();
    }

    private class FieldsVisitor
    extends EmptyVisitor {
        List<FieldBytes> fieldBytes;

        private FieldsVisitor() {
        }

        public FieldVisitor visitField(int access, String name, String desc, String signature, Object value, int index) {
            if (this.fieldBytes == null) {
                this.fieldBytes = new ArrayList<FieldBytes>();
            }
            this.fieldBytes.add(new AsmFieldBytes(AsmClassBytes.this, access, name, desc, signature, index));
            return null;
        }

        FieldBytes[] getFieldBytes() {
            if (this.fieldBytes == null) {
                return NO_FIELDS;
            }
            return this.fieldBytes.toArray(new FieldBytes[this.fieldBytes.size()]);
        }
    }

    private class ConstructorAndMethodsVisitor
    extends EmptyVisitor {
        List<ConstructorBytes> constructorBytes;
        List<MethodBytes> methodBytes;

        private ConstructorAndMethodsVisitor() {
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions, int byteCodeIndex) {
            if (name.startsWith("<c")) {
                return null;
            }
            if (name.startsWith("<i")) {
                if (this.constructorBytes == null) {
                    this.constructorBytes = new ArrayList<ConstructorBytes>();
                }
                this.constructorBytes.add(new AsmConstructorBytes(AsmClassBytes.this, access, name, desc, signature, exceptions, byteCodeIndex));
            } else {
                if (this.methodBytes == null) {
                    this.methodBytes = new ArrayList<MethodBytes>();
                }
                this.methodBytes.add(new AsmMethodBytes(AsmClassBytes.this, access, name, desc, signature, exceptions, byteCodeIndex));
            }
            return null;
        }

        ConstructorBytes[] getConstructorBytes() {
            if (this.constructorBytes == null) {
                return NO_CONSTRUCTORS;
            }
            return this.constructorBytes.toArray(new ConstructorBytes[this.constructorBytes.size()]);
        }

        MethodBytes[] getMethodBytes() {
            if (this.methodBytes == null) {
                return NO_METHODS;
            }
            return this.methodBytes.toArray(new MethodBytes[this.methodBytes.size()]);
        }
    }

    private class AnnotationsVisitor
    extends Util.EmptyClassVisitor
    implements Util.ParentReader {
        List<Annotation> annotations;

        private AnnotationsVisitor() {
        }

        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            return Util.createAnnotationVisitor(this, AsmClassBytes.this.getClassLoader(), desc);
        }

        public Annotation[] getAnnotations() {
            if (this.annotations == null) {
                return NO_ANNOTATIONS;
            }
            return this.annotations.toArray(new Annotation[0]);
        }

        public void setValueInParent(String name, Object value) {
            if (this.annotations == null) {
                this.annotations = new ArrayList<Annotation>();
            }
            this.annotations.add((Annotation)value);
        }
    }

    private static class ClassSignatureVisitor
    extends EmptyVisitor {
        String signature;

        private ClassSignatureVisitor() {
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            this.signature = signature;
        }

        public String getSignature() {
            return this.signature;
        }
    }
}

