/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.reflect.plugins.bytecode;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import javassist.NotFoundException;
import javassist.bytecode.BadBytecode;
import javassist.bytecode.SignatureAttribute;
import org.jboss.reflect.plugins.AnnotationHelper;
import org.jboss.reflect.plugins.ClassInfoImpl;
import org.jboss.reflect.plugins.PackageInfoImpl;
import org.jboss.reflect.plugins.TypeInfoAttachments;
import org.jboss.reflect.plugins.ValueConvertor;
import org.jboss.reflect.plugins.bytecode.BytecodeClassInfo;
import org.jboss.reflect.plugins.bytecode.BytecodeConstructorInfo;
import org.jboss.reflect.plugins.bytecode.BytecodeFieldInfo;
import org.jboss.reflect.plugins.bytecode.BytecodeGenericsHelper;
import org.jboss.reflect.plugins.bytecode.BytecodeInheritableAnnotationHolder;
import org.jboss.reflect.plugins.bytecode.BytecodeMethodInfo;
import org.jboss.reflect.plugins.bytecode.BytecodeTypeInfoFactory;
import org.jboss.reflect.plugins.bytecode.BytecodeTypeInfoFactoryImpl;
import org.jboss.reflect.plugins.bytecode.BytecodeTypeVariableSpy;
import org.jboss.reflect.plugins.bytecode.SecurityActions;
import org.jboss.reflect.plugins.bytecode.SignatureKey;
import org.jboss.reflect.plugins.bytecode.bytes.ClassBytes;
import org.jboss.reflect.plugins.bytecode.bytes.ConstructorBytes;
import org.jboss.reflect.plugins.bytecode.bytes.FieldBytes;
import org.jboss.reflect.plugins.bytecode.bytes.MethodBytes;
import org.jboss.reflect.spi.AnnotationValue;
import org.jboss.reflect.spi.ClassInfo;
import org.jboss.reflect.spi.ConstructorInfo;
import org.jboss.reflect.spi.FieldInfo;
import org.jboss.reflect.spi.InterfaceInfo;
import org.jboss.reflect.spi.MethodInfo;
import org.jboss.reflect.spi.PackageInfo;
import org.jboss.reflect.spi.TypeInfo;
import org.jboss.reflect.spi.TypeInfoFactory;
import org.jboss.util.JBossStringBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BytecodeTypeInfo
extends BytecodeInheritableAnnotationHolder
implements ClassInfo,
InterfaceInfo,
BytecodeClassInfo {
    private static final long serialVersionUID = -5072033691434335775L;
    protected static final RuntimePermission GET_CLASSLOADER_PERMISSION = new RuntimePermission("getClassLoader");
    static final BytecodeTypeInfo COLLECTION;
    static final BytecodeTypeInfo MAP;
    private static final Map<String, BytecodeFieldInfo> EMPTY_FIELDS;
    private static final Map<SignatureKey, MethodInfo> EMPTY_METHODS;
    private final Map<SignatureKey, List<MethodInfo>> EMPTY_VOLATILE_METHODS = Collections.emptyMap();
    private BytecodeTypeInfoFactoryImpl factory;
    private final String name;
    protected volatile Class<? extends Object> clazz;
    private static final Map<SignatureKey, BytecodeConstructorInfo> EMPTY_CONSTRUCTORS;
    private volatile Map<SignatureKey, BytecodeConstructorInfo> constructors = EMPTY_CONSTRUCTORS;
    private volatile ConstructorInfo[] constructorArray;
    private volatile Map<String, BytecodeFieldInfo> fields = EMPTY_FIELDS;
    private volatile FieldInfo[] fieldArray;
    private volatile Map<SignatureKey, MethodInfo> methods = EMPTY_METHODS;
    private volatile Map<SignatureKey, List<MethodInfo>> volatileMethods = this.EMPTY_VOLATILE_METHODS;
    private volatile MethodInfo[] methodArray;
    private volatile PackageInfo packageInfo;
    private volatile transient TypeInfoAttachments attachments;
    private volatile ClassInfo genericSuperClass = ClassInfoImpl.UNKNOWN_CLASS;
    private volatile InterfaceInfo[] genericInterfaces = ClassInfoImpl.UNKNOWN_INTERFACES;
    private volatile TypeInfo componentType = ClassInfoImpl.UNKNOWN_TYPE;
    private volatile TypeInfo keyType = ClassInfoImpl.UNKNOWN_TYPE;
    private volatile TypeInfo valueType = ClassInfoImpl.UNKNOWN_TYPE;
    private volatile Boolean isMap;
    private volatile Boolean isCollection;
    private volatile transient ClassInfo superClass = ClassInfoImpl.UNKNOWN_CLASS;
    private volatile transient InterfaceInfo[] interfaces = ClassInfoImpl.UNKNOWN_INTERFACES;
    private volatile transient boolean initializedClassSignature;
    private volatile transient SignatureAttribute.ClassSignature classSignature;

    BytecodeTypeInfo(BytecodeTypeInfoFactoryImpl factory, String name, ClassBytes classBytes, Class<? extends Object> clazz) {
        super(classBytes, factory);
        if (factory == null) {
            throw new IllegalArgumentException("Null factory");
        }
        if (name == null) {
            throw new IllegalArgumentException("Null name");
        }
        this.factory = factory;
        this.clazz = clazz;
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isInterface() {
        return this.classBytes.isInterface();
    }

    @Override
    public String getSimpleName() {
        String name = this.getName();
        int index = name.lastIndexOf(46);
        if (index < 0) {
            return name;
        }
        return name.substring(index + 1);
    }

    @Override
    public int getModifiers() {
        return this.classBytes.getModifiers();
    }

    @Override
    public boolean isPublic() {
        return Modifier.isPublic(this.getModifiers());
    }

    @Override
    public boolean isStatic() {
        return Modifier.isStatic(this.getModifiers());
    }

    @Override
    public boolean isVolatile() {
        return Modifier.isVolatile(this.getModifiers());
    }

    @Deprecated
    public Class<? extends Object> getType() {
        try {
            if (this.clazz == null) {
                this.clazz = SecurityActions.loadClass(this.classBytes.getClassLoader(), this.getName());
            }
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        return this.clazz;
    }

    @Override
    public ClassLoader getClassLoader() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(GET_CLASSLOADER_PERMISSION);
        }
        return this.getClassLoaderInternal();
    }

    @Override
    public ClassLoader getClassLoaderInternal() {
        return this.classBytes.getClassLoader();
    }

    @Override
    public ClassInfo getSuperclass() {
        if (this.superClass == ClassInfoImpl.UNKNOWN_CLASS) {
            if (this.isInterface()) {
                this.superClass = null;
            } else {
                String superClass = this.classBytes.getSuperClassTypeInfoName();
                if (superClass == null) {
                    this.superClass = null;
                } else {
                    try {
                        this.superClass = (ClassInfo)this.factory.getTypeInfo(superClass, this.getClassLoaderInternal());
                    }
                    catch (ClassNotFoundException e) {
                        throw new RuntimeException("Error loading super class '" + superClass + "' for " + this.getName() + " in " + this.getClassLoaderInternal());
                    }
                }
            }
        }
        return this.superClass;
    }

    @Override
    public ClassInfo getGenericSuperclass() {
        if (this.genericSuperClass == ClassInfoImpl.UNKNOWN_CLASS) {
            SignatureAttribute.ClassSignature classSig = this.getClassSignature();
            if (this.getClassSignature() != null) {
                SignatureAttribute.ClassType type = classSig.getSuperClass();
                this.genericSuperClass = (ClassInfo)this.factory.getTypeInfo(this.getClassLoaderInternal(), type, BytecodeTypeVariableSpy.createForClass(classSig));
            } else {
                this.genericSuperClass = this.getSuperclass();
            }
        }
        return this.genericSuperClass;
    }

    @Override
    public InterfaceInfo[] getInterfaces() {
        if (this.interfaces == ClassInfoImpl.UNKNOWN_INTERFACES) {
            String[] ifaces = this.classBytes.getInterfaceTypeInfoNames();
            if (ifaces != null && ifaces.length > 0) {
                InterfaceInfo[] result = new InterfaceInfo[ifaces.length];
                for (int i = 0; i < result.length; ++i) {
                    try {
                        result[i] = (InterfaceInfo)this.factory.getTypeInfo(ifaces[i], this.getClassLoaderInternal());
                        continue;
                    }
                    catch (ClassNotFoundException e) {
                        throw new RuntimeException("Error loading interface '" + this.superClass + "' for " + this.getName() + " in " + this.getClassLoaderInternal());
                    }
                }
                this.interfaces = result;
            } else {
                this.interfaces = null;
            }
        }
        return this.interfaces;
    }

    @Override
    public InterfaceInfo[] getGenericInterfaces() {
        InterfaceInfo[] interfaces = this.getInterfaces();
        if (interfaces == null || interfaces.length == 0) {
            this.genericInterfaces = null;
        }
        if (this.genericInterfaces == ClassInfoImpl.UNKNOWN_INTERFACES) {
            InterfaceInfo[] infos = new InterfaceInfo[this.getInterfaces().length];
            SignatureAttribute.ClassSignature classSig = this.getClassSignature();
            if (classSig != null) {
                SignatureAttribute.ClassType[] types = classSig.getInterfaces();
                for (int i = 0; i < types.length; ++i) {
                    ClassInfo info = (ClassInfo)this.factory.getTypeInfo(this.getClassLoaderInternal(), types[i], BytecodeTypeVariableSpy.createForClass(classSig));
                    if (!(info instanceof InterfaceInfo)) {
                        throw new IllegalStateException(info + " is not an InterfaceInfo");
                    }
                    infos[i] = (InterfaceInfo)info;
                }
                this.genericInterfaces = infos;
            } else {
                this.genericInterfaces = this.getInterfaces();
            }
        }
        return this.genericInterfaces;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConstructorInfo[] getDeclaredConstructors() {
        if (this.constructorArray == null) {
            ConstructorBytes[] declaredConstructors = this.classBytes.getDeclaredConstructorBytes();
            if (declaredConstructors.length == 0) {
                this.constructorArray = ClassInfoImpl.UNKNOWN_CONSTRUCTORS;
            } else {
                for (int i = 0; i < declaredConstructors.length; ++i) {
                    this.generateConstructorInfo(declaredConstructors[i]);
                }
                Map<SignatureKey, BytecodeConstructorInfo> map = this.constructors;
                synchronized (map) {
                    Collection<BytecodeConstructorInfo> constructorCollection = this.constructors.values();
                    this.constructorArray = constructorCollection.toArray(new ConstructorInfo[constructorCollection.size()]);
                }
            }
        }
        return this.constructorArray;
    }

    public ConstructorInfo getDeclaredConstructor() {
        return this.getDeclaredConstructor(new SignatureKey(null));
    }

    public ConstructorInfo getDeclaredConstructor(String ... parameters) throws ClassNotFoundException {
        TypeInfo[] typeParams = new TypeInfo[parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            typeParams[i] = this.factory.getTypeInfo(parameters[i], this.getClassLoaderInternal());
        }
        return this.getDeclaredConstructor(typeParams);
    }

    @Override
    public ConstructorInfo getDeclaredConstructor(TypeInfo ... parameters) {
        return this.getDeclaredConstructor(new SignatureKey(null, parameters));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConstructorInfo getDeclaredConstructor(SignatureKey key) {
        Map<SignatureKey, BytecodeConstructorInfo> map = this.constructors;
        synchronized (map) {
            ConstructorInfo constructor = this.constructors.get(key);
            if (constructor != null) {
                return constructor;
            }
        }
        if (this.constructorArray != null) {
            return null;
        }
        return this.generateConstructorInfo(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FieldInfo getDeclaredField(String fieldName) {
        Map<String, BytecodeFieldInfo> map = this.fields;
        synchronized (map) {
            FieldInfo field = this.fields.get(fieldName);
            if (field != null) {
                return field;
            }
        }
        if (this.fieldArray != null) {
            return null;
        }
        FieldBytes[] fields = this.classBytes.getDeclaredFieldBytes();
        for (int i = 0; i < fields.length; ++i) {
            if (!fields[i].getName().equals(fieldName)) continue;
            return this.generateFieldInfo(fields[i]);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FieldInfo[] getDeclaredFields() {
        if (this.fieldArray == null) {
            FieldBytes[] declaredFields = this.classBytes.getDeclaredFieldBytes();
            if (declaredFields == null || declaredFields.length == 0) {
                this.fieldArray = ClassInfoImpl.UNKNOWN_FIELDS;
            } else {
                Map<String, BytecodeFieldInfo> map = this.fields;
                synchronized (map) {
                    for (int i = 0; i < declaredFields.length; ++i) {
                        this.generateFieldInfo(declaredFields[i]);
                    }
                    Collection<BytecodeFieldInfo> fieldCollection = this.fields.values();
                    this.fieldArray = fieldCollection.toArray(new FieldInfo[fieldCollection.size()]);
                }
            }
        }
        return this.fieldArray;
    }

    public MethodInfo getDeclaredMethod(String methodName) {
        return this.getDeclaredMethod(new SignatureKey(methodName));
    }

    @Override
    public MethodInfo getDeclaredMethod(String methodName, TypeInfo ... parameters) {
        return this.getDeclaredMethod(new SignatureKey(methodName, parameters));
    }

    public MethodInfo getDeclaredMethod(String methodName, String ... parameters) throws ClassNotFoundException {
        TypeInfo[] typeParams = new TypeInfo[parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            typeParams[i] = this.factory.getTypeInfo(parameters[i], this.classBytes.getClassLoader());
        }
        return this.getDeclaredMethod(methodName, typeParams);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MethodInfo getDeclaredMethod(SignatureKey key) {
        Map<SignatureKey, MethodInfo> map = this.methods;
        synchronized (map) {
            MethodInfo method = this.methods.get(key);
            if (method != null) {
                return method;
            }
        }
        if (this.methodArray != null) {
            return null;
        }
        return this.generateMethodInfo(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MethodInfo[] getDeclaredMethods() {
        if (this.methodArray == null) {
            MethodBytes[] declaredMethods = this.classBytes.getDeclaredMethodBytes();
            if (declaredMethods.length == 0) {
                this.methodArray = ClassInfoImpl.UNKNOWN_METHODS;
            } else {
                Map<SignatureKey, MethodInfo> map = this.methods;
                synchronized (map) {
                    for (int i = 0; i < declaredMethods.length; ++i) {
                        this.generateMethodInfo(declaredMethods[i]);
                    }
                    Collection<MethodInfo> methodCollection = this.methods.values();
                    if (this.volatileMethods.size() > 0) {
                        ArrayList<MethodInfo> allMethods = new ArrayList<MethodInfo>();
                        allMethods.addAll(methodCollection);
                        methodCollection = allMethods;
                        for (List<MethodInfo> infos : this.volatileMethods.values()) {
                            if (infos.size() <= 0) continue;
                            methodCollection.addAll(infos);
                        }
                    }
                    this.methodArray = methodCollection.toArray(new MethodInfo[methodCollection.size()]);
                }
            }
        }
        return this.methodArray;
    }

    @Override
    public boolean isArray() {
        return false;
    }

    @Override
    public boolean isCollection() {
        if (this.isCollection == null) {
            try {
                this.isCollection = BytecodeGenericsHelper.determineHierarchy(null, this, COLLECTION);
            }
            catch (NotFoundException e) {
                throw new IllegalStateException(e);
            }
        }
        return this.isCollection;
    }

    @Override
    public boolean isMap() {
        if (this.isMap == null) {
            try {
                this.isMap = BytecodeGenericsHelper.determineHierarchy(null, this, MAP);
            }
            catch (NotFoundException e) {
                throw new IllegalStateException(e);
            }
        }
        return this.isMap;
    }

    @Override
    public boolean isAnnotation() {
        return this.classBytes.isAnnotation();
    }

    @Override
    public boolean isEnum() {
        return this.classBytes.isEnum();
    }

    @Override
    public boolean isPrimitive() {
        return false;
    }

    public static Class<?> getArrayClass(Class<?> clazz) {
        return Array.newInstance(clazz, 0).getClass();
    }

    @Override
    public TypeInfo getArrayType() {
        Class<?> arrayClass = BytecodeTypeInfo.getArrayClass(this.getType());
        return this.factory.getTypeInfo(arrayClass);
    }

    @Override
    public Object newArrayInstance(int size) throws Throwable {
        if (!this.isArray()) {
            throw new ClassCastException(this + " is not an array.");
        }
        return Array.newInstance(this.getComponentType().getType(), size);
    }

    @Override
    public boolean isAssignableFrom(TypeInfo info) {
        if (info == null) {
            throw new NullPointerException("Parameter info cannot be null!");
        }
        return this.getType().isAssignableFrom(info.getType());
    }

    @Override
    public boolean isInstance(Object object) {
        return this.getType().isInstance(object);
    }

    @Override
    public TypeInfoFactory getTypeInfoFactory() {
        return this.factory;
    }

    @Override
    public Object convertValue(Object value) throws Throwable {
        return ValueConvertor.convertValue(this.getType(), value);
    }

    @Override
    public Object convertValue(Object value, boolean replaceProperties) throws Throwable {
        return ValueConvertor.convertValue(this.getType(), value, replaceProperties);
    }

    @Override
    public Object convertValue(Object value, boolean replaceProperties, boolean trim) throws Throwable {
        return ValueConvertor.convertValue(this.getType(), value, replaceProperties, trim);
    }

    protected int getHashCode() {
        return this.getName().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof TypeInfo)) {
            return false;
        }
        TypeInfo other = (TypeInfo)obj;
        return this.getName().equals(other.getName());
    }

    public void toShortString(JBossStringBuilder buffer) {
        buffer.append(this.getName());
    }

    protected void toString(JBossStringBuilder buffer) {
        buffer.append("name=").append(this.getName());
        super.toString(buffer);
    }

    @Override
    public BytecodeTypeInfoFactoryImpl getFactory() {
        return this.factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ConstructorInfo generateConstructorInfo(ConstructorBytes constructor) {
        BytecodeConstructorInfo info = new BytecodeConstructorInfo((AnnotationHelper)this.factory, this, constructor);
        Map<SignatureKey, BytecodeConstructorInfo> map = this.constructors;
        synchronized (map) {
            if (this.constructors == EMPTY_CONSTRUCTORS) {
                this.constructors = new HashMap<SignatureKey, BytecodeConstructorInfo>(1);
            }
            this.constructors.put(constructor.getSignatureKey(), info);
        }
        return info;
    }

    protected ConstructorInfo generateConstructorInfo(SignatureKey key) {
        ConstructorBytes[] constructors = this.classBytes.getDeclaredConstructorBytes();
        for (int i = 0; i < constructors.length; ++i) {
            if (!constructors[i].getSignatureKey().equals(key)) continue;
            return this.generateConstructorInfo(constructors[i]);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected FieldInfo generateFieldInfo(FieldBytes field) {
        BytecodeFieldInfo info = new BytecodeFieldInfo(this.factory, this, field);
        Map<String, BytecodeFieldInfo> map = this.fields;
        synchronized (map) {
            if (this.fields == EMPTY_FIELDS) {
                this.fields = new HashMap<String, BytecodeFieldInfo>(1);
            }
            this.fields.put(field.getName(), info);
        }
        return info;
    }

    protected MethodInfo generateMethodInfo(SignatureKey key) {
        MethodBytes[] methods = this.classBytes.getDeclaredMethodBytes();
        for (int i = 0; i < methods.length; ++i) {
            if (!methods[i].getName().equals(key.getName()) || !methods[i].getSignatureKey().equals(key)) continue;
            return this.generateMethodInfo(methods[i]);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MethodInfo generateMethodInfo(MethodBytes method) {
        BytecodeMethodInfo info = new BytecodeMethodInfo((AnnotationHelper)this.factory, this, method);
        Map<SignatureKey, MethodInfo> map = this.methods;
        synchronized (map) {
            if (Modifier.isVolatile(method.getModifiers())) {
                List<MethodInfo> infos = this.volatileMethods.get(method.getSignatureKey());
                if (infos == null) {
                    infos = new CopyOnWriteArrayList<MethodInfo>();
                    if (this.volatileMethods == this.EMPTY_VOLATILE_METHODS) {
                        this.volatileMethods = new HashMap<SignatureKey, List<MethodInfo>>(1);
                    }
                    this.volatileMethods.put(method.getSignatureKey(), infos);
                }
                infos.add(info);
            } else {
                if (this.methods == EMPTY_METHODS) {
                    this.methods = new HashMap<SignatureKey, MethodInfo>(1);
                }
                this.methods.put(method.getSignatureKey(), info);
            }
        }
        return info;
    }

    @Override
    public AnnotationValue[] getAnnotations() {
        return this.getAnnotations(this.classBytes);
    }

    @Override
    public ClassInfo getSuperHolder() {
        return this.getSuperclass();
    }

    @Override
    public TypeInfo[] getActualTypeArguments() {
        return ClassInfoImpl.UNKNOWN_TYPES;
    }

    @Override
    public TypeInfo getOwnerType() {
        return null;
    }

    @Override
    public ClassInfo getRawType() {
        return this;
    }

    @Override
    public TypeInfo getComponentType() {
        if (!this.isCollection()) {
            return null;
        }
        if (this.componentType == ClassInfoImpl.UNKNOWN_TYPE) {
            this.componentType = this.findTypeInfo(COLLECTION, 0);
        }
        return this.componentType;
    }

    @Override
    public TypeInfo getKeyType() {
        if (!this.isMap()) {
            return null;
        }
        if (this.keyType == ClassInfoImpl.UNKNOWN_TYPE) {
            this.keyType = this.findTypeInfo(MAP, 0);
        }
        return this.keyType;
    }

    @Override
    public TypeInfo getValueType() {
        if (!this.isMap()) {
            return null;
        }
        if (this.valueType == ClassInfoImpl.UNKNOWN_TYPE) {
            this.valueType = this.findTypeInfo(MAP, 1);
        }
        return this.valueType;
    }

    private TypeInfo findTypeInfo(ClassInfo iface, int parameter) {
        try {
            SignatureAttribute.ClassType type = BytecodeGenericsHelper.determineType(this, iface, parameter);
            return this.factory.getTypeInfo(this.getClassLoaderInternal(), type, BytecodeTypeVariableSpy.createForClass(this.getClassSignature()));
        }
        catch (Exception e1) {
            throw new RuntimeException(e1);
        }
    }

    @Override
    public PackageInfo getPackage() {
        String packageName;
        if (this.packageInfo == null && (packageName = this.getPackageName()) != null) {
            AnnotationValue[] annotations = null;
            ClassLoader cl = this.getClassLoaderInternal();
            String name = packageName + ".package-info";
            ClassBytes clazz = this.factory.loadClassBytes(cl, name);
            try {
                ClassInfo info = (ClassInfo)this.factory.get(clazz, null, name, cl, false);
                annotations = info.getAnnotations();
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
            this.packageInfo = new PackageInfoImpl(packageName, annotations);
        }
        return this.packageInfo;
    }

    protected String getPackageName() {
        return this.getPackageName(this.getName());
    }

    protected String getPackageName(String classname) {
        int index = classname.lastIndexOf(46);
        return index < 0 ? null : classname.substring(0, index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAttachment(String name, Object attachment) {
        if (name == null) {
            throw new IllegalArgumentException("Null name");
        }
        BytecodeTypeInfo bytecodeTypeInfo = this;
        synchronized (bytecodeTypeInfo) {
            if (this.attachments == null) {
                if (attachment == null) {
                    return;
                }
                this.attachments = new TypeInfoAttachments();
            }
        }
        if (attachment == null) {
            this.attachments.removeAttachment(name);
        } else {
            this.attachments.addAttachment(name, attachment);
        }
    }

    @Override
    public <T> T getAttachment(Class<T> expectedType) {
        if (expectedType == null) {
            throw new IllegalArgumentException("Null expectedType");
        }
        Object result = this.getAttachment(expectedType.getName());
        if (result == null) {
            return null;
        }
        return expectedType.cast(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getAttachment(String attachmentName) {
        if (attachmentName == null) {
            throw new IllegalArgumentException("Null name");
        }
        BytecodeTypeInfo bytecodeTypeInfo = this;
        synchronized (bytecodeTypeInfo) {
            if (this.attachments == null) {
                return null;
            }
        }
        return this.attachments.getAttachment(attachmentName);
    }

    protected Object writeReplace() {
        return new MarshalledClassInfo(this.getType());
    }

    @Override
    public String getTypeVariable() {
        return null;
    }

    @Override
    public SignatureAttribute.ClassSignature getClassSignature() {
        if (!this.initializedClassSignature) {
            try {
                String sig = this.classBytes.getGenericSignature();
                if (sig != null) {
                    this.classSignature = SignatureAttribute.toClassSignature((String)sig);
                }
            }
            catch (BadBytecode e) {
                throw new RuntimeException(e);
            }
            this.initializedClassSignature = true;
        }
        return this.classSignature;
    }

    public ClassBytes getClassBytes() {
        return this.classBytes;
    }

    static {
        BytecodeTypeInfoFactory factory = new BytecodeTypeInfoFactory();
        try {
            COLLECTION = (BytecodeTypeInfo)factory.getTypeInfo(Collection.class);
            MAP = (BytecodeTypeInfo)factory.getTypeInfo(Map.class);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        EMPTY_FIELDS = Collections.emptyMap();
        EMPTY_METHODS = Collections.emptyMap();
        EMPTY_CONSTRUCTORS = Collections.emptyMap();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MarshalledClassInfo
    implements Serializable {
        private static final long serialVersionUID = 1L;
        Class<?> type;

        public MarshalledClassInfo(Class<?> type) {
            this.type = type;
        }

        protected Object readResolve() {
            BytecodeTypeInfoFactory tif = new BytecodeTypeInfoFactory();
            return tif.getTypeInfo(this.type);
        }
    }
}

