/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.ir.gui.remoteobject;

import org.jacorb.ir.gui.remoteobject.ObjectRepresentant;
import org.jacorb.ir.gui.remoteobject.RemoteObject;
import org.jacorb.ir.gui.remoteobject.Struct;
import org.jacorb.ir.gui.typesystem.ModelBuilder;
import org.jacorb.ir.gui.typesystem.TypeAssociator;
import org.jacorb.ir.gui.typesystem.TypeSystemNode;
import org.jacorb.ir.gui.typesystem.remote.IRInterface;
import org.jacorb.ir.gui.typesystem.remote.IRStruct;
import org.jacorb.ir.gui.typesystem.remote.RemoteTypeSystem;
import org.omg.CORBA.Any;
import org.omg.CORBA.InterfaceDef;
import org.omg.CORBA.InterfaceDefHelper;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.PrimitiveDef;
import org.omg.CORBA.PrimitiveKind;
import org.omg.CORBA.Repository;
import org.omg.CORBA.RepositoryHelper;
import org.omg.CORBA.TCKind;

public class ObjectRepresentantFactory {
    private static ORB orb = ORB.init();

    public static ObjectRepresentant create(java.lang.Object object, TypeSystemNode typeSystemNode, TypeAssociator typeAssociator) {
        String string = null;
        if (typeAssociator != null) {
            string = ((TypeSystemNode)((java.lang.Object)typeAssociator)).getName();
        }
        if (typeSystemNode instanceof IRInterface) {
            return new RemoteObject((Object)object, typeSystemNode, string);
        }
        if (typeSystemNode instanceof IRStruct) {
            return new Struct(object, (IRStruct)typeSystemNode, string);
        }
        return new ObjectRepresentant(object, typeSystemNode, string);
    }

    public static ObjectRepresentant create(Object object) {
        IRInterface iRInterface = (IRInterface)RemoteTypeSystem.createTypeSystemNode(InterfaceDefHelper.narrow(object._get_interface_def()));
        return ObjectRepresentantFactory.create(object, iRInterface, null);
    }

    public static ObjectRepresentant createFromIOR(String string) {
        Object object = orb.string_to_object(string);
        return ObjectRepresentantFactory.create(object);
    }

    protected static void insertFromString(Any any, String string, TCKind tCKind) {
        switch (tCKind.value()) {
            case 0: 
            case 1: 
            case 2: {
                any.insert_short(Short.parseShort(string));
                break;
            }
            case 3: {
                any.insert_long(Integer.parseInt(string));
                break;
            }
            case 4: {
                any.insert_ushort(Short.parseShort(string));
                break;
            }
            case 5: {
                any.insert_ulong(Integer.parseInt(string));
                break;
            }
            case 6: {
                any.insert_float(new Float(string).floatValue());
                break;
            }
            case 7: {
                any.insert_double(new Double(string));
                break;
            }
            case 8: {
                any.insert_boolean(new Boolean(string));
                break;
            }
            case 9: {
                any.insert_char(string.charAt(0));
                break;
            }
            case 10: {
                any.insert_octet(new Byte(string));
                break;
            }
            case 14: {
                any.insert_Object(orb.string_to_object(string));
                break;
            }
            case 17: {
                any.insert_long(Integer.parseInt(string));
                break;
            }
            case 18: {
                any.insert_string(string);
                break;
            }
            case 23: {
                any.insert_longlong(Long.parseLong(string));
                break;
            }
            case 24: {
                any.insert_ulonglong(Long.parseLong(string));
                break;
            }
            case 26: {
                any.insert_wchar(string.charAt(0));
                break;
            }
            case 27: {
                any.insert_wstring(string);
                break;
            }
        }
    }

    public static void main(String[] stringArray) {
        try {
            Repository repository = RepositoryHelper.narrow(orb.resolve_initial_references("InterfaceRepository"));
            PrimitiveDef primitiveDef = repository.get_primitive(PrimitiveKind.pk_short);
            InterfaceDef interfaceDef = InterfaceDefHelper.narrow(primitiveDef._get_interface_def());
            ObjectRepresentant objectRepresentant = ObjectRepresentantFactory.create(primitiveDef, RemoteTypeSystem.createTypeSystemNode(interfaceDef), null);
            ModelBuilder.getSingleton().buildTreeModelAsync(objectRepresentant);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static java.lang.Object objectFromAny(Any any) {
        switch (any.type().kind().value()) {
            case 0: {
                return null;
            }
            case 1: {
                System.out.println("DII returned an Any of kind void?");
                return null;
            }
            case 2: {
                return new Short(any.extract_short());
            }
            case 3: {
                return new Integer(any.extract_long());
            }
            case 4: {
                return new Short(any.extract_ushort());
            }
            case 5: {
                return new Integer(any.extract_ulong());
            }
            case 6: {
                return new Float(any.extract_float());
            }
            case 7: {
                return new Double(any.extract_double());
            }
            case 8: {
                return new Boolean(any.extract_boolean());
            }
            case 9: {
                return new Character(any.extract_char());
            }
            case 10: {
                return new Byte(any.extract_octet());
            }
            case 11: {
                return any.extract_any();
            }
            case 12: {
                return any.extract_TypeCode();
            }
            case 13: {
                return any.extract_Principal();
            }
            case 14: {
                return any.extract_Object();
            }
            case 18: {
                return any.extract_string();
            }
            case 23: {
                return new Long(any.extract_longlong());
            }
            case 24: {
                return new Long(any.extract_ulonglong());
            }
            case 26: {
                return new Character(any.extract_wchar());
            }
            case 27: {
                return new String(any.extract_wstring());
            }
        }
        return null;
    }
}

