/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.impl.base.serialization;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipInputStream;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.exporter.ZipExporter;
import org.jboss.shrinkwrap.api.importer.ZipImporter;
import org.jboss.shrinkwrap.api.serialization.ZipSerializableView;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.impl.base.AssignableBase;
import org.jboss.shrinkwrap.impl.base.Validate;
import org.jboss.shrinkwrap.impl.base.io.IOUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZipSerializableViewImpl
extends AssignableBase
implements ZipSerializableView {
    private static final long serialVersionUID = 1L;
    private static final Logger log = Logger.getLogger(ZipSerializableViewImpl.class.getName());
    private final String name;
    private transient Archive<?> archive;

    public ZipSerializableViewImpl(Archive<?> archive) {
        Validate.notNull(archive, "Archive must be specified");
        String name = archive.getName();
        Validate.notNullOrEmpty(name, "Name of archive must be specified");
        this.archive = archive;
        this.name = name;
    }

    @Override
    protected Archive<?> getArchive() {
        assert (this.archive != null) : "Underlying archive may never be null; illegal state";
        return this.archive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        InputStream in = ((ZipExporter)this.archive.as(ZipExporter.class)).exportZip();
        try {
            IOUtil.copy(in, out);
        }
        finally {
            in.close();
        }
        if (log.isLoggable(Level.FINER)) {
            log.finer("Wrote archive: " + this.archive.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        String name = this.name;
        ZipImporter archive = (ZipImporter)ShrinkWrap.create(ZipImporter.class, (String)name);
        ZipInputStream remains = new ZipInputStream(new DoNotDelegateCloseInputStream(in));
        try {
            archive.importZip(remains);
            this.archive = (Archive)archive.as(JavaArchive.class);
        }
        finally {
            remains.close();
        }
        if (log.isLoggable(Level.FINER)) {
            log.finer("Read in archive: " + archive.toString());
        }
        while (in.read() != -1) {
        }
    }

    private static class DoNotDelegateCloseInputStream
    extends FilterInputStream {
        protected DoNotDelegateCloseInputStream(InputStream in) {
            super(in);
        }

        public void close() throws IOException {
        }
    }
}

