/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.impl.base.exporter;

import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ArchivePath;
import org.jboss.shrinkwrap.api.ArchivePaths;
import org.jboss.shrinkwrap.api.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractExporterDelegate<T> {
    private static final Logger log = Logger.getLogger(AbstractExporterDelegate.class.getName());
    private final Archive<?> archive;

    protected AbstractExporterDelegate(Archive<?> archive) {
        this.archive = archive;
    }

    protected void export() {
        Archive<?> archive = this.getArchive();
        if (log.isLoggable(Level.FINE)) {
            log.fine("Exporting archive - " + archive.getName());
        }
        Node rootNode = archive.get(ArchivePaths.create((String)"/"));
        for (Node child : rootNode.getChildren()) {
            this.processNode(child);
        }
    }

    protected void processNode(Node node) {
        this.processNode(node.getPath(), node);
        Set children = node.getChildren();
        for (Node child : children) {
            this.processNode(child);
        }
    }

    protected abstract void processNode(ArchivePath var1, Node var2);

    protected abstract T getResult();

    protected Archive<?> getArchive() {
        return this.archive;
    }
}

