/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.pluginapi.util;

import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.StringTokenizer;
import org.rhq.core.system.ProcessExecution;

public class ProcessExecutionUtility {
    private ProcessExecutionUtility() {
    }

    public static ProcessExecution createProcessExecution(File file) {
        return ProcessExecutionUtility.createProcessExecution(null, file);
    }

    public static ProcessExecution createProcessExecution(String prefix, File file) {
        ProcessExecution processExecution;
        if (ProcessExecutionUtility.isWindows() && ProcessExecutionUtility.isBatchFile(file)) {
            String comSpec = System.getenv("COMSPEC");
            if (comSpec == null) {
                throw new RuntimeException("COMSPEC environment variable is not defined.");
            }
            if (!new File(comSpec).exists()) {
                throw new RuntimeException("COMSPEC environment variable specifies a non-existent path: " + comSpec);
            }
            processExecution = new ProcessExecution(comSpec);
            if (null == prefix) {
                processExecution.setArguments(new String[]{"/C", file.getPath()});
            } else {
                processExecution.setArguments(new String[]{"/C", prefix, file.getPath()});
            }
        } else if (null == prefix) {
            processExecution = new ProcessExecution(file.getPath());
            processExecution.setArguments(new ArrayList());
        } else {
            ArrayList<String> arguments = new ArrayList<String>();
            StringTokenizer prefixTokenizer = new StringTokenizer(prefix);
            String processName = prefixTokenizer.nextToken();
            while (prefixTokenizer.hasMoreTokens()) {
                String prefixArgument = prefixTokenizer.nextToken();
                arguments.add(prefixArgument);
            }
            arguments.add(file.getPath());
            processExecution = new ProcessExecution(processName);
            processExecution.setArguments(arguments);
        }
        LinkedHashMap<String, String> envVars = new LinkedHashMap<String, String>(System.getenv());
        processExecution.setEnvironmentVariables(envVars);
        processExecution.setWorkingDirectory(file.getParent());
        return processExecution;
    }

    private static boolean isBatchFile(File file) {
        return file.getName().matches(".*\\.((bat)|(cmd))$(?i)");
    }

    private static boolean isWindows() {
        return File.separatorChar == '\\';
    }
}

