/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.pluginapi.inventory;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executor;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.resource.ProcessScan;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.pluginapi.availability.AvailabilityCollectorRunnable;
import org.rhq.core.pluginapi.availability.AvailabilityFacet;
import org.rhq.core.pluginapi.content.ContentContext;
import org.rhq.core.pluginapi.event.EventContext;
import org.rhq.core.pluginapi.inventory.DiscoveredResourceDetails;
import org.rhq.core.pluginapi.inventory.PluginContainerDeployment;
import org.rhq.core.pluginapi.inventory.ProcessScanResult;
import org.rhq.core.pluginapi.inventory.ResourceComponent;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryComponent;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryContext;
import org.rhq.core.pluginapi.operation.OperationContext;
import org.rhq.core.system.ProcessInfo;
import org.rhq.core.system.SystemInfo;
import org.rhq.core.system.SystemInfoFactory;
import org.rhq.core.system.pquery.ProcessInfoQuery;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceContext<T extends ResourceComponent> {
    private final String resourceKey;
    private final ResourceType resourceType;
    private final String version;
    private final T parentResourceComponent;
    private final Configuration pluginConfiguration;
    private final SystemInfo systemInformation;
    private final ResourceDiscoveryComponent resourceDiscoveryComponent;
    private final File temporaryDirectory;
    private final File dataDirectory;
    private final String pluginContainerName;
    private final EventContext eventContext;
    private final OperationContext operationContext;
    private final ContentContext contentContext;
    private final Executor availCollectionThreadPool;
    private final PluginContainerDeployment pluginContainerDeployment;
    private ProcessInfo processInfo;

    public ResourceContext(Resource resource, T parentResourceComponent, ResourceDiscoveryComponent resourceDiscoveryComponent, SystemInfo systemInfo, File temporaryDirectory, File dataDirectory, String pluginContainerName, EventContext eventContext, OperationContext operationContext, ContentContext contentContext, Executor availCollectorThreadPool, PluginContainerDeployment pluginContainerDeployment) {
        this.resourceKey = resource.getResourceKey();
        this.resourceType = resource.getResourceType();
        this.version = resource.getVersion();
        this.parentResourceComponent = parentResourceComponent;
        this.resourceDiscoveryComponent = resourceDiscoveryComponent;
        this.systemInformation = systemInfo;
        this.pluginConfiguration = resource.getPluginConfiguration();
        this.dataDirectory = dataDirectory;
        this.pluginContainerName = pluginContainerName;
        this.pluginContainerDeployment = pluginContainerDeployment;
        if (temporaryDirectory == null) {
            this.temporaryDirectory = new File(System.getProperty("java.io.tmpdir"), "AGENT_TMP");
            this.temporaryDirectory.mkdirs();
        } else {
            this.temporaryDirectory = temporaryDirectory;
        }
        this.eventContext = eventContext;
        this.operationContext = operationContext;
        this.contentContext = contentContext;
        this.availCollectionThreadPool = availCollectorThreadPool;
    }

    public String getResourceKey() {
        return this.resourceKey;
    }

    public ResourceType getResourceType() {
        return this.resourceType;
    }

    public String getVersion() {
        return this.version;
    }

    public T getParentResourceComponent() {
        return this.parentResourceComponent;
    }

    public SystemInfo getSystemInformation() {
        return this.systemInformation;
    }

    public Configuration getPluginConfiguration() {
        return this.pluginConfiguration.deepCopy();
    }

    public ProcessInfo getNativeProcess() {
        if (!(this.processInfo != null && this.processInfo.isRunning() || this.resourceDiscoveryComponent == null)) {
            try {
                ResourceDiscoveryContext<T> context = new ResourceDiscoveryContext<T>(this.resourceType, this.parentResourceComponent, this, this.systemInformation, this.getNativeProcessesForType(), Collections.EMPTY_LIST, this.getPluginContainerName(), this.getPluginContainerDeployment());
                Set<DiscoveredResourceDetails> details = this.resourceDiscoveryComponent.discoverResources(context);
                for (DiscoveredResourceDetails detail : details) {
                    if (!detail.getResourceKey().equals(this.resourceKey)) continue;
                    this.processInfo = detail.getProcessInfo();
                }
            }
            catch (Exception e) {
                LogFactory.getLog(this.getClass()).warn((Object)("Cannot get native process for resource [" + this.resourceKey + "] - discovery failed"), (Throwable)e);
            }
        }
        return this.processInfo;
    }

    public List<ProcessScanResult> getNativeProcessesForType() {
        ArrayList<ProcessScanResult> scanResults = new ArrayList<ProcessScanResult>();
        SystemInfo systemInfo = SystemInfoFactory.createSystemInfo();
        try {
            Set processScans = this.resourceType.getProcessScans();
            if (processScans != null && !processScans.isEmpty()) {
                ProcessInfoQuery piq = new ProcessInfoQuery(systemInfo.getAllProcesses());
                for (ProcessScan processScan : processScans) {
                    List queryResults = piq.query(processScan.getQuery());
                    if (queryResults == null || queryResults.size() <= 0) continue;
                    for (ProcessInfo autoDiscoveredProcess : queryResults) {
                        scanResults.add(new ProcessScanResult(processScan, autoDiscoveredProcess));
                    }
                }
            }
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        return scanResults;
    }

    public File getTemporaryDirectory() {
        return this.temporaryDirectory;
    }

    public File getDataDirectory() {
        return this.dataDirectory;
    }

    public String getPluginContainerName() {
        return this.pluginContainerName;
    }

    public PluginContainerDeployment getPluginContainerDeployment() {
        return this.pluginContainerDeployment;
    }

    public EventContext getEventContext() {
        return this.eventContext;
    }

    public OperationContext getOperationContext() {
        return this.operationContext;
    }

    public ContentContext getContentContext() {
        return this.contentContext;
    }

    public AvailabilityCollectorRunnable createAvailabilityCollectorRunnable(AvailabilityFacet availChecker, long interval) {
        return new AvailabilityCollectorRunnable(availChecker, interval, Thread.currentThread().getContextClassLoader(), this.availCollectionThreadPool);
    }
}

