/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.managed.bean.proxy.impl;

import java.util.Hashtable;
import javassist.util.proxy.ProxyFactory;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.naming.spi.ObjectFactory;
import org.jboss.managed.bean.proxy.impl.ManagedBeanClassRefAddr;
import org.jboss.managed.bean.proxy.impl.ManagedBeanManagerRegistryRefAddr;
import org.jboss.managed.bean.proxy.impl.ManagedBeanProxyMethodHandler;
import org.jboss.managed.bean.spi.ManagedBeanManager;
import org.jboss.managed.bean.spi.ManagedBeanManagerRegistry;

public class ManagedBeanProxyObjectFactory
implements ObjectFactory {
    @Override
    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable<?, ?> environment) throws Exception {
        if (!Reference.class.isInstance(obj)) {
            throw new IllegalArgumentException("Object bound at " + name.toString() + " was not of expected type " + Reference.class.getName());
        }
        Reference reference = (Reference)obj;
        ManagedBeanManagerRegistryRefAddr registryRefAddr = this.getRefAddr(reference, "ManagedBeanManagerRegistryRefAddr", ManagedBeanManagerRegistryRefAddr.class);
        ManagedBeanManagerRegistry registry = (ManagedBeanManagerRegistry)registryRefAddr.getContent();
        StringRefAddr managerNameRefAddr = this.getRefAddr(reference, "ManagedBeanManagerNameRefAddr", StringRefAddr.class);
        String managerName = (String)managerNameRefAddr.getContent();
        ManagedBeanClassRefAddr managedBeanClassRefAddr = this.getRefAddr(reference, "ManagedBeanClassRefAddr", ManagedBeanClassRefAddr.class);
        Class managedBeanClass = (Class)managedBeanClassRefAddr.getContent();
        return this.createProxy(registry, managerName, managedBeanClass);
    }

    private <R> R getRefAddr(Reference reference, String addrType, Class<R> expectedType) {
        RefAddr refAddr = reference.get(addrType);
        if (!expectedType.isInstance(refAddr)) {
            throw new RuntimeException("Unexpected RefAddr: " + refAddr + " for addrType: " + addrType + " expected type  was " + expectedType);
        }
        return expectedType.cast(refAddr);
    }

    private <T> T createProxy(ManagedBeanManagerRegistry registry, String managerName, Class<?> managedBeanClass) throws IllegalArgumentException {
        ProxyFactory javassistProxyFactory = new ProxyFactory();
        javassistProxyFactory.setSuperclass(managedBeanClass);
        javassistProxyFactory.setHandler(new ManagedBeanProxyMethodHandler(registry, managerName));
        try {
            return (T)javassistProxyFactory.create(new Class[0], new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not create proxy for managed bean class " + managedBeanClass);
        }
    }

    private ManagedBeanManager<?> getManagedBeanManager(ManagedBeanManagerRegistry registry, String managerName) {
        if (!registry.isRegistered(managerName)) {
            throw new IllegalStateException("Cannot find managed bean manager with id: " + managerName);
        }
        return registry.get(managerName);
    }
}

