/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployers.vfs.plugins.structure;

import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import org.jboss.vfs.VirtualFile;

public class SecurityActions {
    static boolean isLeaf(VirtualFile f) throws IOException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            return FileActions.PRIVILEGED.isLeaf(f);
        }
        return FileActions.NON_PRIVILEGED.isLeaf(f);
    }

    static ClassLoader getContextClassLoader() {
        if (System.getSecurityManager() == null) {
            return Thread.currentThread().getContextClassLoader();
        }
        return AccessController.doPrivileged(GetContextClassLoader.INSTANCE);
    }

    static ClassLoader setContextClassLoader(final ClassLoader classLoader) {
        if (System.getSecurityManager() == null) {
            ClassLoader previous = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(classLoader);
            return previous;
        }
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                ClassLoader previous = Thread.currentThread().getContextClassLoader();
                Thread.currentThread().setContextClassLoader(classLoader);
                return previous;
            }
        });
    }

    static void resetContextClassLoader(final ClassLoader classLoader) {
        if (System.getSecurityManager() == null) {
            Thread.currentThread().setContextClassLoader(classLoader);
        } else {
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    Thread.currentThread().setContextClassLoader(classLoader);
                    return null;
                }
            });
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class GetContextClassLoader
    implements PrivilegedAction<ClassLoader> {
        static GetContextClassLoader INSTANCE = new GetContextClassLoader();

        GetContextClassLoader() {
        }

        @Override
        public ClassLoader run() {
            return Thread.currentThread().getContextClassLoader();
        }
    }

    static interface FileActions {
        public static final FileActions PRIVILEGED = new FileActions(){

            public Boolean isLeaf(final VirtualFile f) throws IOException {
                try {
                    return AccessController.doPrivileged(new PrivilegedExceptionAction<Boolean>(){

                        @Override
                        public Boolean run() throws Exception {
                            return f.isFile();
                        }
                    });
                }
                catch (PrivilegedActionException e) {
                    Exception ex = e.getException();
                    if (ex instanceof IOException) {
                        throw (IOException)ex;
                    }
                    if (ex instanceof RuntimeException) {
                        throw (RuntimeException)ex;
                    }
                    throw new UndeclaredThrowableException(ex);
                }
            }
        };
        public static final FileActions NON_PRIVILEGED = new FileActions(){

            public Boolean isLeaf(VirtualFile f) throws IOException {
                return f.isFile();
            }
        };

        public Boolean isLeaf(VirtualFile var1) throws IOException;
    }
}

