/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.profileservice.resolver;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.logging.Logger;
import org.jboss.profileservice.repository.ProfileMetaDataContext;
import org.jboss.profileservice.repository.ProfileMetaDataRepository;
import org.jboss.profileservice.resolver.ProfileNodeDependency;
import org.jboss.profileservice.resolver.ProfileRequirementResolutionContext;
import org.jboss.profileservice.resolver.ProfileResolutionFilter;
import org.jboss.profileservice.resolver.ProfileResolutionNode;
import org.jboss.profileservice.spi.ProfileKey;
import org.jboss.profileservice.spi.dependency.DependencyMode;
import org.jboss.profileservice.spi.dependency.ProfileCapability;
import org.jboss.profileservice.spi.dependency.ProfileRequirement;

public class AbstractRequirementResolver
implements ProfileResolutionFilter {
    private static final Logger log = Logger.getLogger(AbstractRequirementResolver.class);
    private final ProfileMetaDataRepository profileRepository;
    private Set<ProfileResolutionNode> included = new HashSet<ProfileResolutionNode>();
    private Set<ProfileKey> includedKeys = new HashSet<ProfileKey>();
    private List<ProfileResolutionNode> callbacks = new ArrayList<ProfileResolutionNode>();
    private List<ProfileRequirement> unresolved = new ArrayList<ProfileRequirement>();
    private Map<ProfileKey, ProfileResolutionNode> nodes = new HashMap<ProfileKey, ProfileResolutionNode>();
    private List<ProfileMetaDataContext> includedContexts = new ArrayList<ProfileMetaDataContext>();

    public AbstractRequirementResolver(ProfileMetaDataRepository profileRepository) {
        if (profileRepository == null) {
            throw new IllegalArgumentException("null profile metadata registry");
        }
        this.profileRepository = profileRepository;
    }

    public void resolve(ProfileMetaDataContext context) {
        if (context == null) {
            throw new IllegalArgumentException("null dependency context");
        }
        this.resolveRoot(context);
    }

    @Override
    public boolean accepts(ProfileMetaDataContext context) {
        return !this.includedKeys.contains(context.getKey());
    }

    void resolveRoot(ProfileMetaDataContext context) {
        ProfileKey currentKey = context.getKey();
        ProfileResolutionNode currentNode = this.getNode(context);
        this.included.add(currentNode);
        this.includedKeys.add(currentKey);
        ArrayList<ProfileMetaDataContext> toProcess = new ArrayList<ProfileMetaDataContext>();
        Collection<ProfileRequirement> requirements = context.getRequirements();
        if (requirements != null && !requirements.isEmpty()) {
            for (ProfileRequirement requirement : requirements) {
                ProfileRequirementResolutionContext resolution = new ProfileRequirementResolutionContext(context, requirement);
                ProfileKey dependencyKey = this.profileRepository.resolve(resolution, ProfileResolutionFilter.NOOP_FILTER);
                if (dependencyKey == null) {
                    if (requirement.isOptional()) continue;
                    this.unresolved.add(requirement);
                    continue;
                }
                if (currentKey.equals((Object)dependencyKey)) continue;
                ProfileMetaDataContext dependencyContext = this.profileRepository.resolve(dependencyKey.getName());
                ProfileResolutionNode depenencyNode = this.getNode(dependencyContext);
                this.addDependencyContext(dependencyContext);
                toProcess.add(dependencyContext);
                boolean requireInstalled = dependencyContext.getActivationConfiguration() == null;
                ProfileNodeDependency dependency = new ProfileNodeDependency(resolution, dependencyKey, requirement, false, requireInstalled);
                currentNode.addIDependOn(dependency);
                depenencyNode.addDependsOnMe(dependency);
            }
        }
        if (!this.unresolved.isEmpty()) {
            return;
        }
        for (ProfileMetaDataContext process : toProcess) {
            this.resolve(process, false);
        }
    }

    void resolve(ProfileMetaDataContext context, boolean fromActivationCallback) {
        Collection<ProfileRequirement> requirements;
        boolean trace = log.isTraceEnabled();
        ProfileKey currentKey = context.getKey();
        ProfileResolutionNode currentNode = this.getNode(context);
        if (this.included(currentNode)) {
            return;
        }
        if (trace) {
            log.trace((Object)("* processing " + currentNode));
        }
        if (!fromActivationCallback) {
            currentNode.hardenDependsOnMe();
            this.included.add(currentNode);
            this.includedKeys.add(currentKey);
            if (this.callbacks.contains(currentNode)) {
                this.callbacks.remove(currentNode);
            }
        } else {
            this.callbacks.add(currentNode);
        }
        if ((requirements = context.getRequirements()) != null && !requirements.isEmpty()) {
            for (ProfileRequirement requirement : requirements) {
                ProfileRequirementResolutionContext resolution = new ProfileRequirementResolutionContext(context, requirement);
                ProfileKey dependencyKey = this.internalResolve(context, requirement);
                if (dependencyKey == null) {
                    dependencyKey = this.profileRepository.resolve(resolution, this);
                }
                if (dependencyKey == null) {
                    if (requirement.isOptional()) continue;
                    this.unresolved.add(requirement);
                    continue;
                }
                if (currentKey.equals((Object)dependencyKey)) continue;
                DependencyMode mode = AbstractRequirementResolver.getDependencyMode(requirement);
                ProfileMetaDataContext dependencyContext = this.profileRepository.resolve(dependencyKey.getName());
                ProfileResolutionNode depenencyNode = this.getNode(dependencyContext);
                this.addDependencyContext(dependencyContext);
                if (mode == DependencyMode.RESOLVE) {
                    this.resolve(dependencyContext, false);
                } else if (!fromActivationCallback && mode == DependencyMode.ACTIVATION_CALLBACK) {
                    this.resolve(dependencyContext, true);
                }
                boolean dependencyIncluded = this.included(depenencyNode);
                boolean optional = requirement.isOptional() && !dependencyIncluded;
                boolean requireInstalled = dependencyContext.getActivationConfiguration() == null;
                ProfileNodeDependency dependency = new ProfileNodeDependency(resolution, dependencyKey, requirement, optional, requireInstalled);
                currentNode.addIDependOn(dependency);
                depenencyNode.addDependsOnMe(dependency);
                if (fromActivationCallback && !dependencyIncluded) {
                    dependency.weakenOptionalDependsOnTo();
                }
                if (!trace) continue;
                log.trace((Object)(" ** adding dependency: " + dependency));
            }
        }
    }

    protected ProfileKey internalResolve(ProfileMetaDataContext ctx, ProfileRequirement requirement) {
        boolean trace = log.isTraceEnabled();
        for (ProfileMetaDataContext profile : this.includedContexts) {
            Collection<ProfileCapability> capabilities = profile.getCapabilities();
            if (capabilities == null || capabilities.isEmpty()) continue;
            for (ProfileCapability capability : capabilities) {
                if (!capability.resolves(requirement)) continue;
                if (trace) {
                    log.trace((Object)(profile.getKey() + ":" + capability + " resolved " + requirement));
                }
                return profile.getKey();
            }
        }
        return null;
    }

    protected void addDependencyContext(ProfileMetaDataContext context) {
        if (this.includedContexts.contains(context)) {
            return;
        }
        Collection<ProfileCapability> capabilities = context.getCapabilities();
        if (capabilities != null && !capabilities.isEmpty()) {
            for (ProfileCapability capability : capabilities) {
                for (ProfileMetaDataContext included : this.includedContexts) {
                    Collection<ProfileCapability> includedCapabilities = included.getCapabilities();
                    if (includedCapabilities == null || includedCapabilities.isEmpty()) continue;
                    for (ProfileCapability other : includedCapabilities) {
                        if (capability.isConsistent(other)) continue;
                        throw new IllegalStateException(context.getProfileName() + " has an incosistent capability " + capability + " with module " + included.getProfileName() + " / " + other);
                    }
                }
            }
        }
        this.includedContexts.add(context);
    }

    public List<ProfileMetaDataContext> sort() {
        if (!this.unresolved.isEmpty()) {
            throw new IllegalStateException("unresolved " + this.unresolved);
        }
        Iterator<ProfileResolutionNode> i = this.callbacks.iterator();
        while (i.hasNext()) {
            ProfileResolutionNode callback = i.next();
            if (!this.included(callback) && callback.checkResolved(this.includedKeys)) {
                callback.hardenDependsOnMe();
                this.included.add(callback);
                this.includedKeys.add(callback.getKey());
            }
            i.remove();
        }
        return new Sorter().sort();
    }

    ProfileResolutionNode getNode(ProfileMetaDataContext ctx) {
        ProfileKey key = ctx.getKey();
        if (this.nodes.containsKey(key)) {
            return this.nodes.get(key);
        }
        ProfileResolutionNode node = new ProfileResolutionNode(ctx);
        this.nodes.put(key, node);
        return node;
    }

    ProfileResolutionNode getProcessedNode(ProfileKey key) {
        return this.nodes.get(key);
    }

    boolean included(ProfileResolutionNode node) {
        return this.includedKeys.contains(node.getKey());
    }

    static DependencyMode getDependencyMode(ProfileRequirement requirement) {
        DependencyMode mode = requirement.getDependencyMode();
        if (mode == null) {
            mode = DependencyMode.getDefault();
        }
        return mode;
    }

    protected String debug() {
        StringBuilder builder = new StringBuilder("failed to resolve dependencies: \n");
        for (ProfileResolutionNode node : this.included) {
            builder.append(node.getKey().getName()).append("\n");
            for (ProfileNodeDependency dependency : node.getiDependOn()) {
                if (dependency.isResolved()) continue;
                builder.append(dependency).append("\n");
            }
        }
        return builder.toString();
    }

    class Sorter {
        Sorter() {
        }

        List<ProfileMetaDataContext> sort() {
            boolean trace = log.isTraceEnabled();
            ArrayList<ProfileMetaDataContext> sorted = new ArrayList<ProfileMetaDataContext>();
            List<ProfileResolutionNode> roots = this.getRoots();
            if (trace) {
                log.trace((Object)("roots: " + roots));
            }
            while (!roots.isEmpty()) {
                ProfileResolutionNode node = roots.remove(0);
                sorted.add(node);
                if (!node.hasDependsOnMe()) continue;
                for (ProfileNodeDependency dependsOnMe : node.getDependsOnMe()) {
                    if (dependsOnMe.isOptionalDependsOnTo()) continue;
                    ProfileResolutionNode otherNode = AbstractRequirementResolver.this.getProcessedNode(dependsOnMe.getFrom());
                    if (otherNode == null || !AbstractRequirementResolver.this.included(otherNode)) {
                        throw new IllegalStateException("trying to activate non included node " + otherNode);
                    }
                    otherNode.markAsResolved(node.getKey());
                    if (!otherNode.isResolved()) continue;
                    roots.add(otherNode);
                    AbstractRequirementResolver.this.included.remove(otherNode);
                    if (!trace) continue;
                    log.trace((Object)("resolved " + otherNode));
                }
            }
            if (AbstractRequirementResolver.this.included.size() > 0) {
                throw new IllegalStateException(AbstractRequirementResolver.this.debug());
            }
            return sorted;
        }

        List<ProfileResolutionNode> getRoots() {
            ArrayList<ProfileResolutionNode> roots = new ArrayList<ProfileResolutionNode>();
            Iterator i = AbstractRequirementResolver.this.included.iterator();
            while (i.hasNext()) {
                ProfileResolutionNode node = (ProfileResolutionNode)i.next();
                if (!node.isResolved()) continue;
                roots.add(node);
                i.remove();
            }
            return roots;
        }
    }
}

