/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.profileservice.repository;

import org.jboss.profileservice.config.ProfileServiceConfig;
import org.jboss.profileservice.repository.AbstractMetaDataContext;
import org.jboss.profileservice.repository.AbstractProfileRepository;
import org.jboss.profileservice.repository.CompositeResolutionFilter;
import org.jboss.profileservice.repository.ProfileMetaDataContext;
import org.jboss.profileservice.repository.ProfileMetaDataRepository;
import org.jboss.profileservice.resolver.ProfileRequirementResolutionContext;
import org.jboss.profileservice.resolver.ProfileResolutionFilter;
import org.jboss.profileservice.spi.ProfileKey;
import org.jboss.profileservice.spi.metadata.ProfileMetaData;

public class ProfileRepositories
implements ProfileMetaDataRepository {
    private final ProfileServiceConfig configuration;
    private final ProfileMetaDataRepository domainRepository;
    private final ProfileMetaDataRepository profileRepository;

    public ProfileRepositories(ProfileServiceConfig configuration) {
        this.configuration = configuration;
        this.domainRepository = new AbstractProfileRepository(this);
        this.profileRepository = new AbstractProfileRepository(this);
    }

    public ProfileServiceConfig getConfiguration() {
        return this.configuration;
    }

    public ProfileMetaDataRepository getDomainRepository() {
        return this.domainRepository;
    }

    public ProfileMetaDataRepository getProfileRepository() {
        return this.profileRepository;
    }

    @Override
    public boolean isRegistered(String profileName) {
        if (this.domainRepository.isRegistered(profileName)) {
            return true;
        }
        return this.profileRepository.isRegistered(profileName);
    }

    @Override
    public ProfileMetaDataContext registerMetaData(ProfileMetaData metaData) {
        String profileName = metaData.getName();
        if (this.isRegistered(profileName)) {
            throw new IllegalArgumentException("profile already registered " + profileName);
        }
        return this.domainRepository.registerMetaData(metaData);
    }

    @Override
    public void unRegisterMetaData(String profileName) {
        this.domainRepository.unRegisterMetaData(profileName);
    }

    @Override
    public ProfileMetaDataContext resolve(String profileName) {
        ProfileMetaDataContext context = this.domainRepository.resolve(profileName);
        if (context == null) {
            context = this.profileRepository.resolve(profileName);
        }
        return context;
    }

    @Override
    public ProfileKey resolve(ProfileRequirementResolutionContext context, ProfileResolutionFilter filter) {
        ProfileKey resolvedDomain = this.domainRepository.resolve(context, filter);
        ProfileKey resolved = this.profileRepository.resolve(context, new CompositeResolutionFilter(filter, this.domainRepository));
        if (resolvedDomain == null) {
            return resolved;
        }
        if (resolved == null) {
            return resolvedDomain;
        }
        return null;
    }

    @Override
    public boolean accepts(ProfileMetaDataContext context) {
        String profileName = context.getProfileName();
        return !this.isRegistered(profileName);
    }

    protected ProfileMetaDataContext createMetaDataContext(String profileName, ProfileMetaData metaData) {
        ProfileKey key = this.createProfileKey(profileName);
        return new AbstractMetaDataContext(key, metaData);
    }

    protected ProfileKey createProfileKey(String profileName) {
        return new ProfileKey(profileName);
    }

    protected String getDomainName() {
        return this.getConfiguration().getManagementDomain().getDomainName();
    }

    protected String getServerName() {
        return this.getConfiguration().getServerConfiguration().getServerName();
    }
}

