/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.profileservice.repository;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.jboss.profileservice.metadata.ProfileConfigurationExt;
import org.jboss.profileservice.profile.metadata.helpers.AbstractProfileKeyCapability;
import org.jboss.profileservice.repository.ProfileMetaDataContext;
import org.jboss.profileservice.spi.ProfileKey;
import org.jboss.profileservice.spi.activation.ProfileActivationConfiguration;
import org.jboss.profileservice.spi.dependency.ProfileCapability;
import org.jboss.profileservice.spi.dependency.ProfileRequirement;
import org.jboss.profileservice.spi.metadata.ProfileFeatureMetaData;
import org.jboss.profileservice.spi.metadata.ProfileMetaData;
import org.jboss.profileservice.spi.metadata.ProfileMetaDataVisitor;
import org.jboss.profileservice.spi.metadata.ProfileMetaDataVisitorNode;

public class AbstractMetaDataContext
implements ProfileMetaDataContext,
ProfileMetaDataVisitor {
    private final ProfileKey key;
    private Collection<ProfileKey> aliases;
    private final ProfileMetaData profileMetaData;
    private Collection<ProfileCapability> capabilites;
    private Collection<ProfileRequirement> requirements;
    private Collection<ProfileFeatureMetaData> features;

    public AbstractMetaDataContext(ProfileKey key, ProfileMetaData metaData) {
        if (key == null) {
            throw new IllegalArgumentException("null profile key");
        }
        if (metaData == null) {
            throw new IllegalArgumentException("null meta data");
        }
        this.key = key;
        this.profileMetaData = metaData;
        this.visit((ProfileMetaDataVisitorNode)this.profileMetaData);
    }

    @Override
    public String getProfileName() {
        return this.key.getName();
    }

    @Override
    public ProfileKey getKey() {
        return this.key;
    }

    @Override
    public ProfileMetaData getProfileMetaData() {
        return this.profileMetaData;
    }

    @Override
    public ProfileActivationConfiguration getActivationConfiguration() {
        if (this.getProfileMetaData() instanceof ProfileConfigurationExt) {
            return ((ProfileConfigurationExt)ProfileConfigurationExt.class.cast(this.getProfileMetaData())).getActivationConfiguration();
        }
        return null;
    }

    @Override
    public Collection<ProfileKey> getAliases() {
        if (this.aliases == null) {
            return Collections.emptySet();
        }
        return this.aliases;
    }

    public void addAlias(String name) {
        if (this.aliases == null) {
            this.aliases = new ArrayList<ProfileKey>();
        }
        this.aliases.add(new ProfileKey(this.getKey().getDomain(), this.getKey().getServer(), name));
        this.addCapability(new AbstractProfileKeyCapability(name));
    }

    public void addCapability(ProfileCapability capability) {
        if (this.capabilites == null) {
            this.capabilites = new ArrayList<ProfileCapability>();
        }
        this.capabilites.add(capability);
    }

    public void addRequirement(ProfileRequirement requirement) {
        if (this.requirements == null) {
            this.requirements = new ArrayList<ProfileRequirement>();
        }
        this.requirements.add(requirement);
    }

    @Override
    public Collection<ProfileCapability> getCapabilities() {
        if (this.capabilites == null) {
            return Collections.emptySet();
        }
        return this.capabilites;
    }

    @Override
    public Collection<ProfileRequirement> getRequirements() {
        if (this.requirements == null) {
            return Collections.emptySet();
        }
        return this.requirements;
    }

    public void addFeature(ProfileFeatureMetaData feature) {
        if (this.features == null) {
            this.features = new ArrayList<ProfileFeatureMetaData>();
        }
        this.features.add(feature);
    }

    @Override
    public Collection<ProfileFeatureMetaData> getFeatures() {
        if (this.features == null) {
            return Collections.emptySet();
        }
        return this.features;
    }

    public void visit(ProfileMetaDataVisitorNode node) {
        node.visit((ProfileMetaDataVisitor)this);
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.getClass().getSimpleName()).append('@');
        buffer.append(Integer.toHexString(System.identityHashCode(this)));
        buffer.append('{');
        this.toString(buffer);
        buffer.append('}');
        return buffer.toString();
    }

    protected void toString(StringBuilder builder) {
        builder.append("key=").append(this.getKey());
    }
}

