/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.profileservice.dependency;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jboss.beans.metadata.api.model.AutowireType;
import org.jboss.beans.metadata.spi.builder.BeanMetaDataBuilder;
import org.jboss.beans.metadata.spi.builder.ParameterMetaDataBuilder;
import org.jboss.dependency.spi.Controller;
import org.jboss.dependency.spi.ControllerContext;
import org.jboss.dependency.spi.ControllerMode;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.dependency.spi.DependencyInfo;
import org.jboss.dependency.spi.DependencyItem;
import org.jboss.dependency.spi.LifecycleCallbackItem;
import org.jboss.kernel.Kernel;
import org.jboss.kernel.spi.dependency.KernelController;
import org.jboss.profileservice.config.ProfileServiceConfig;
import org.jboss.profileservice.dependency.ProfileActivationWrapper;
import org.jboss.profileservice.dependency.ProfileControllerContext;
import org.jboss.profileservice.dependency.ProfileControllerContextActions;
import org.jboss.profileservice.dependency.ProfileRequirementDependencyItem;
import org.jboss.profileservice.dependency.plugin.ProfileLifeCycleCallbackActions;
import org.jboss.profileservice.repository.ProfileMetaDataContext;
import org.jboss.profileservice.repository.ProfileMetaDataRepository;
import org.jboss.profileservice.repository.ProfileRepositories;
import org.jboss.profileservice.resolver.ProfileResolutionNode;
import org.jboss.profileservice.spi.NoSuchProfileException;
import org.jboss.profileservice.spi.Profile;
import org.jboss.profileservice.spi.ProfileFactory;
import org.jboss.profileservice.spi.ProfileKey;
import org.jboss.profileservice.spi.activation.ProfileActivator;
import org.jboss.profileservice.spi.dependency.ProfileRequirement;
import org.jboss.profileservice.spi.metadata.ProfileMetaData;

public class ProfileActivationService {
    private final Kernel kernel;
    private final ProfileRepositories profileRepository;
    private List<ProfileActivationWrapper> activations = new CopyOnWriteArrayList<ProfileActivationWrapper>();
    private Map<String, ProfileActivationWrapper> activationsByName = new ConcurrentHashMap<String, ProfileActivationWrapper>();

    public ProfileActivationService(Kernel kernel, ProfileRepositories metaDataRepository) {
        this.kernel = kernel;
        this.profileRepository = metaDataRepository;
        ProfileControllerContextActions.initializeController((Controller)kernel.getController());
    }

    public ProfileMetaDataRepository getProfileServiceRepository() {
        return this.profileRepository;
    }

    public Collection<ProfileKey> getRegisteredKeys() {
        HashSet<ProfileKey> registered = new HashSet<ProfileKey>();
        for (ProfileActivationWrapper activation : this.activations) {
            registered.add(activation.getKey());
        }
        return registered;
    }

    public Collection<ProfileKey> getInstalledKeys() {
        HashSet<ProfileKey> installed = new HashSet<ProfileKey>();
        for (ProfileActivationWrapper activation : this.activations) {
            if (!activation.isStarted()) continue;
            installed.add(activation.getKey());
        }
        return installed;
    }

    ProfileActivator getProfileActivator(String name) {
        return this.getConfiguration().getProfileActivator(name);
    }

    public ProfileKey register(ProfileMetaData metaData, Profile profile) throws Throwable {
        ProfileMetaDataContext context = this.profileRepository.registerMetaData(metaData);
        this.installProfile(context, profile);
        return context.getKey();
    }

    public void activate(ProfileKey key) throws NoSuchProfileException, Exception {
        this.activateProfile(key.getName());
    }

    public void deactivate(ProfileKey key) throws NoSuchProfileException {
        this.deactivateProfile(key.getName());
    }

    public void uninstall(ProfileKey key) {
        this.uninstallProfile(key.getName());
        this.profileRepository.unRegisterMetaData(key.getName());
    }

    public void validate(ProfileKey key) throws NoSuchProfileException, Exception {
        String profileName = key.getName();
        this.getProfileActivation(profileName).validate();
    }

    public void installProfile(ProfileMetaDataContext metaData, Profile profile) throws Throwable {
        ProfileControllerContext context = this.createControllerContext(metaData, profile);
        this.getController().install((ControllerContext)context);
        ProfileActivationWrapper wrapper = new ProfileActivationWrapper(context);
        this.activations.add(wrapper);
        this.activationsByName.put(metaData.getProfileName(), wrapper);
    }

    protected void activateProfile(String profileName) throws NoSuchProfileException, Exception {
        this.getProfileActivation(profileName).start();
    }

    protected void deactivateProfile(String profileName) throws NoSuchProfileException {
        this.getProfileActivation(profileName).stop();
    }

    protected void uninstallProfile(String profileName) {
        ProfileActivationWrapper wrapper = this.activationsByName.remove(profileName);
        if (wrapper != null) {
            if (wrapper.isStarted()) {
                wrapper.stop();
            }
            this.activations.remove(wrapper);
            ProfileControllerContext context = wrapper.getContext();
            this.getController().uninstall(context.getName());
        }
    }

    protected boolean isInstalled(String profileName) {
        return this.activationsByName.containsKey(profileName);
    }

    protected ProfileActivationWrapper getProfileActivation(String profileName) throws NoSuchProfileException {
        ProfileActivationWrapper wrapper = this.activationsByName.get(profileName);
        if (wrapper == null) {
            throw new NoSuchProfileException("no such profile " + profileName);
        }
        return wrapper;
    }

    Kernel getKernel() {
        return this.kernel;
    }

    KernelController getController() {
        return this.getKernel().getController();
    }

    ProfileControllerContext createControllerContext(ProfileMetaDataContext context, Profile profile) {
        ProfileKey key = context.getKey();
        BeanMetaDataBuilder builder = BeanMetaDataBuilder.createBuilder((String)Integer.toHexString(key.hashCode()), null);
        builder.addAlias((Object)key);
        Collection<ProfileKey> aliases = context.getAliases();
        if (aliases != null && !aliases.isEmpty()) {
            for (ProfileKey alias : context.getAliases()) {
                builder.addAlias((Object)alias);
            }
        }
        if (profile != null) {
            builder.setBean(profile.getClass().getName());
        } else {
            ProfileFactory<ProfileMetaData, Profile> profileFactory = this.getConfiguration().getProfileFactory();
            builder.setFactory(profileFactory);
            builder.setFactoryMethod("createProfile");
            builder.addConstructorParameter(ProfileKey.class.getName(), (Object)context.getKey());
            builder.addConstructorParameter(ProfileMetaData.class.getName(), (Object)context.getProfileMetaData());
            ParameterMetaDataBuilder parameters = builder.addUninstallWithParameters("destroyProfile", "TypedProfileFactory");
            parameters.addParameterMetaData(ProfileMetaData.class.getName(), (Object)context.getProfileMetaData());
            parameters.addParameterMetaData(Profile.class.getName(), builder.createThis());
        }
        builder.setAutowireType(AutowireType.NONE);
        ProfileControllerContext kCtx = new ProfileControllerContext(builder.getBeanMetaData(), this, profile);
        kCtx.setMode(ControllerMode.MANUAL);
        kCtx.setDependencyContext(context);
        if (context instanceof ProfileResolutionNode) {
            ((ProfileResolutionNode)ProfileResolutionNode.class.cast(context)).describe(kCtx);
        } else {
            Collection<ProfileRequirement> requirements = context.getRequirements();
            if (requirements != null && !requirements.isEmpty()) {
                DependencyInfo dependencyInfo = kCtx.getDependencyInfo();
                for (ProfileRequirement requirement : requirements) {
                    ControllerState dependentState = ControllerState.INSTALLED;
                    dependencyInfo.addIDependOn((DependencyItem)new ProfileRequirementDependencyItem(kCtx, requirement, null, dependentState));
                }
            }
        }
        ProfileLifeCycleCallbackActions callbackItem = this.getConfiguration().getLifeCycleActions();
        if (callbackItem != null) {
            kCtx.getDependencyInfo().addLifecycleCallback((LifecycleCallbackItem)callbackItem);
        }
        return kCtx;
    }

    ProfileServiceConfig getConfiguration() {
        return this.profileRepository.getConfiguration();
    }
}

