/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.managed.bean.metadata.jbmeta.annotation.processor;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashSet;
import javax.interceptor.AroundInvoke;
import org.jboss.interceptor.reader.cache.DefaultMetadataCachingReader;
import org.jboss.interceptor.spi.metadata.InterceptorMetadata;
import org.jboss.managed.bean.metadata.jbmeta.ManagedBeanMetaDataImpl;
import org.jboss.metadata.annotation.creator.AbstractFinderUser;
import org.jboss.metadata.annotation.creator.Processor;
import org.jboss.metadata.annotation.finder.AnnotationFinder;

public class AroundInvokeProcessor
extends AbstractFinderUser
implements Processor<ManagedBeanMetaDataImpl, Method> {
    private static final Collection<Class<? extends Annotation>> PROCESSABLE_ANNOTATION_TYPES = new HashSet<Class<? extends Annotation>>(1);

    public AroundInvokeProcessor(AnnotationFinder<AnnotatedElement> finder) {
        super(finder);
    }

    public Collection<Class<? extends Annotation>> getAnnotationTypes() {
        return PROCESSABLE_ANNOTATION_TYPES;
    }

    public void process(ManagedBeanMetaDataImpl managedBean, Method method) {
        AroundInvoke aroundInvoke = method.getAnnotation(AroundInvoke.class);
        if (aroundInvoke == null) {
            return;
        }
        if (!method.getDeclaringClass().getName().equals(managedBean.getManagedBeanClass())) {
            return;
        }
        InterceptorMetadata interceptorMetaData = new DefaultMetadataCachingReader().getTargetClassInterceptorMetadata(method.getDeclaringClass());
        managedBean.addAroundInvoke(interceptorMetaData);
    }

    static {
        PROCESSABLE_ANNOTATION_TYPES.add(AroundInvoke.class);
    }
}

