/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import org.apache.catalina.Container;
import org.apache.catalina.ContainerEvent;
import org.apache.catalina.ContainerListener;
import org.apache.catalina.Context;
import org.apache.catalina.Engine;
import org.apache.catalina.Host;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Service;
import org.apache.catalina.Wrapper;
import org.apache.tomcat.util.http.mapper.Mapper;

public class ServiceMapperListener
implements LifecycleListener,
ContainerListener {
    protected Mapper mapper = null;

    public ServiceMapperListener(Mapper mapper) {
        this.mapper = mapper;
    }

    @Override
    public void containerEvent(ContainerEvent event) {
        Container container = event.getContainer();
        String type = event.getType();
        if (type.equals("addChild")) {
            if (container instanceof Host) {
                Context context = (Context)event.getData();
                ((Lifecycle)((Object)context)).addLifecycleListener(this);
                if (context.isStarted()) {
                    this.addContext(context);
                }
            } else if (container instanceof Engine) {
                container.addContainerListener(this);
                Host host = (Host)event.getData();
                this.mapper.addHost(host.getName(), host.findAliases(), host);
            }
        } else if (type.equals("removeChild")) {
            if (container instanceof Host) {
                Context context = (Context)event.getData();
                ((Lifecycle)((Object)context)).removeLifecycleListener(this);
                this.mapper.removeContext(container.getName(), context.getName());
            } else if (container instanceof Engine) {
                container.removeContainerListener(this);
                Host host = (Host)event.getData();
                this.mapper.removeHost(host.getName());
            }
        } else if (type == "addAlias") {
            this.mapper.addHostAlias(((Host)event.getSource()).getName(), event.getData().toString());
        } else if (type == "removeAlias") {
            this.mapper.removeHostAlias(event.getData().toString());
        }
    }

    @Override
    public void lifecycleEvent(LifecycleEvent event) {
        Lifecycle source = event.getLifecycle();
        if ("start".equals(event.getType())) {
            if (source instanceof Service) {
                Service service = (Service)((Object)source);
                Engine engine = (Engine)service.getContainer();
                engine.addContainerListener(this);
                ((Lifecycle)((Object)engine)).addLifecycleListener(this);
                if (engine.getDefaultHost() != null) {
                    this.mapper.setDefaultHostName(engine.getDefaultHost());
                }
                for (Container host : engine.findChildren()) {
                    host.addContainerListener(this);
                    this.mapper.addHost(host.getName(), ((Host)host).findAliases(), host);
                    for (Container context : host.findChildren()) {
                        ((Lifecycle)((Object)context)).addLifecycleListener(this);
                    }
                }
            }
        } else if ("stop".equals(event.getType())) {
            if (source instanceof Context) {
                Context context = (Context)((Object)source);
                this.mapper.removeContext(context.getParent().getName(), context.getName());
            } else if (source instanceof Service) {
                Service service = (Service)((Object)source);
                Engine engine = (Engine)service.getContainer();
                engine.removeContainerListener(this);
                ((Lifecycle)((Object)engine)).removeLifecycleListener(this);
                for (Container host : engine.findChildren()) {
                    host.removeContainerListener(this);
                    this.mapper.removeHost(host.getName());
                    for (Container context : host.findChildren()) {
                        ((Lifecycle)((Object)context)).removeLifecycleListener(this);
                        this.mapper.removeContext(host.getName(), context.getName());
                    }
                }
            }
        } else if ("complete-config".equals(event.getType())) {
            Context context = (Context)((Object)source);
            this.addContext(context);
        }
    }

    protected void addContext(Context context) {
        this.mapper.addContext(context.getParent().getName(), context.getName(), context, context.findWelcomeFiles(), context.getResources());
        for (Container child : context.findChildren()) {
            Wrapper wrapper = (Wrapper)child;
            if (!wrapper.getEnabled()) continue;
            for (String mapping : wrapper.findMappings()) {
                boolean jspWildCard = "jsp".equals(wrapper.getName()) && mapping.endsWith("/*");
                this.mapper.addWrapper(context.getParent().getName(), context.getName(), mapping, wrapper, jspWildCard);
            }
        }
    }
}

