/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.switchboard.mc;

import java.util.HashMap;
import java.util.Map;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.logging.Logger;
import org.jboss.switchboard.mc.resource.provider.ResourceProviderRegistry;
import org.jboss.switchboard.mc.spi.MCBasedResourceProvider;
import org.jboss.switchboard.spi.EnvironmentEntryType;
import org.jboss.switchboard.spi.JndiEnvironment;
import org.jboss.switchboard.spi.Resource;

public class JndiEnvironmentProcessor {
    private static Logger logger = Logger.getLogger(JndiEnvironmentProcessor.class);
    private ResourceProviderRegistry registry;

    public JndiEnvironmentProcessor(ResourceProviderRegistry registry) {
        this.registry = registry;
    }

    public Map<String, Resource> process(DeploymentUnit unit, JndiEnvironment environment) {
        HashMap<String, Resource> resources = new HashMap<String, Resource>();
        for (EnvironmentEntryType entry : environment.getEntries()) {
            MCBasedResourceProvider<EnvironmentEntryType> provider = this.registry.getResourceProvider(entry.getClass());
            if (provider == null) {
                logger.debug((Object)(entry.getName() + " will not be available in ENC, of component in deployment unit: " + unit + " ,because no ResourceProvider was available for type: " + entry.getClass()));
                continue;
            }
            Resource resource = provider.provide((Object)unit, entry);
            if (resource == null) continue;
            resources.put(entry.getName(), resource);
        }
        return resources;
    }
}

