/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.tomcat.security;

public class AllRolesMode {
    private String name;
    public static final AllRolesMode STRICT_MODE = new AllRolesMode("strict");
    public static final AllRolesMode AUTH_ONLY_MODE = new AllRolesMode("authOnly");
    public static final AllRolesMode STRICT_AUTH_ONLY_MODE = new AllRolesMode("strictAuthOnly");

    static AllRolesMode toMode(String name) {
        AllRolesMode mode;
        if (name.equalsIgnoreCase(AllRolesMode.STRICT_MODE.name)) {
            mode = STRICT_MODE;
        } else if (name.equalsIgnoreCase(AllRolesMode.AUTH_ONLY_MODE.name)) {
            mode = AUTH_ONLY_MODE;
        } else if (name.equalsIgnoreCase(AllRolesMode.STRICT_AUTH_ONLY_MODE.name)) {
            mode = STRICT_AUTH_ONLY_MODE;
        } else {
            throw new IllegalStateException("Unknown mode, must be one of: strict, authOnly, strictAuthOnly");
        }
        return mode;
    }

    private AllRolesMode(String name) {
        this.name = name;
    }

    public boolean equals(Object o) {
        boolean equals = false;
        if (o instanceof AllRolesMode) {
            AllRolesMode mode = (AllRolesMode)o;
            equals = this.name.equals(mode.name);
        }
        return equals;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return "AllRolesMode(" + this.name + ")";
    }
}

