/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.invocation.http.server;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.jboss.ha.framework.interfaces.HAPartition;
import org.jboss.ha.framework.interfaces.LoadBalancePolicy;
import org.jboss.ha.framework.server.HAPartitionLocator;
import org.jboss.ha.framework.server.HATarget;
import org.jboss.invocation.Invoker;
import org.jboss.invocation.InvokerInterceptor;
import org.jboss.invocation.http.interfaces.ClientMethodInterceptorHA;
import org.jboss.invocation.http.interfaces.HttpInvokerProxyHA;
import org.jboss.invocation.http.server.HAInvokerWrapper;
import org.jboss.invocation.http.server.HttpProxyFactory;
import org.jboss.invocation.http.server.HttpProxyFactoryHAMBean;

public class HttpProxyFactoryHA
extends HttpProxyFactory
implements HttpProxyFactoryHAMBean {
    private ObjectName realJmxInvokerName;
    private ObjectName wrappedJmxInvokerName;
    private String partitionName = "DefaultPartition";
    private Class policyClass;
    private HAInvokerWrapper invokerWrapper;
    private HATarget invokerTarget;

    public Class getLoadBalancePolicy() {
        return this.policyClass;
    }

    public void setLoadBalancePolicy(Class policyClass) {
        this.policyClass = policyClass;
    }

    public String getPartitionName() {
        return this.partitionName;
    }

    public void setPartitionName(String name) {
        this.partitionName = name;
    }

    public void setInvokerName(ObjectName jmxInvokerName) {
        this.realJmxInvokerName = jmxInvokerName;
        ObjectName factoryName = this.getServiceName();
        Hashtable<String, String> props = factoryName.getKeyPropertyList();
        props.put("wrapperType", "httpHA");
        try {
            this.wrappedJmxInvokerName = new ObjectName(factoryName.getDomain(), props);
            super.setInvokerName(this.wrappedJmxInvokerName);
        }
        catch (MalformedObjectNameException e) {
            throw new IllegalStateException("Was not able to create wrapped ObjectName");
        }
    }

    public ObjectName getRealJmxInvokerName() {
        return this.realJmxInvokerName;
    }

    protected ArrayList defineInterceptors() {
        ArrayList<Class> interceptorClasses = new ArrayList<Class>();
        interceptorClasses.add(ClientMethodInterceptorHA.class);
        interceptorClasses.add(InvokerInterceptor.class);
        return interceptorClasses;
    }

    protected Invoker createInvoker() throws Exception {
        HAPartition partition = HAPartitionLocator.getHAPartitionLocator().getHAPartition(this.partitionName, null);
        this.checkInvokerURL();
        String invokerStub = super.getInvokerURL();
        this.invokerTarget = new HATarget(partition, this.wrappedJmxInvokerName.toString(), (Serializable)((Object)invokerStub), 1);
        this.log.debug((Object)("Created invoker: " + this.invokerTarget));
        MBeanServer mbeanServer = super.getServer();
        this.invokerWrapper = new HAInvokerWrapper(mbeanServer, this.realJmxInvokerName, this.invokerTarget);
        mbeanServer.registerMBean((Object)this.invokerWrapper, this.wrappedJmxInvokerName);
        LoadBalancePolicy policy = (LoadBalancePolicy)this.policyClass.newInstance();
        String clusterFamilyName = this.partitionName + "/" + this.wrappedJmxInvokerName.toString();
        HttpInvokerProxyHA delegateInvoker = new HttpInvokerProxyHA(this.invokerTarget.getReplicantList(), this.invokerTarget.getCurrentViewId(), policy, clusterFamilyName);
        return delegateInvoker;
    }

    protected void stopService() throws Exception {
        try {
            MBeanServer mbeanServer = super.getServer();
            mbeanServer.unregisterMBean(this.wrappedJmxInvokerName);
        }
        catch (Exception e) {
            this.log.debug((Object)("Failed to unregister HAInvokerWrapper: " + this.wrappedJmxInvokerName), (Throwable)e);
        }
        super.stopService();
    }

    public void destroy() {
        super.destroy();
        try {
            this.invokerTarget.destroy();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

