/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ha.singleton;

import java.net.URI;
import org.jboss.ha.singleton.HASingletonProfileActivator;
import org.jboss.ha.singleton.HASingletonProfileManagerMBean;
import org.jboss.managed.api.annotation.ManagementComponent;
import org.jboss.managed.api.annotation.ManagementObject;
import org.jboss.managed.api.annotation.ManagementObjectID;
import org.jboss.managed.api.annotation.ManagementProperties;
import org.jboss.managed.api.annotation.ManagementProperty;
import org.jboss.managed.api.annotation.ViewUse;
import org.jboss.profileservice.profile.metadata.helpers.ProfileMetaDataFactory;
import org.jboss.profileservice.profile.metadata.plugin.ScanPeriod;
import org.jboss.profileservice.spi.NoSuchProfileException;
import org.jboss.profileservice.spi.ProfileKey;
import org.jboss.profileservice.spi.ProfileService;
import org.jboss.profileservice.spi.metadata.ProfileMetaData;

@ManagementObject(componentType=@ManagementComponent(type="MCBean", subtype="HASingletonProfileManager"), properties=ManagementProperties.EXPLICIT)
public class HASingletonProfileManager
extends HASingletonProfileActivator
implements HASingletonProfileManagerMBean {
    private URI deployURI;

    @ManagementProperty(use={ViewUse.CONFIGURATION}, description="List of URIs from which the Profile content is obtained")
    public URI getDeployURI() {
        return this.deployURI;
    }

    public void setDeployURI(URI deployURI) {
        this.deployURI = deployURI;
    }

    @ManagementProperty(use={ViewUse.STATISTIC}, description="ProfileKey for the Profile we activate")
    @ManagementObjectID(type="HASingletonProfileManager")
    public ProfileKey getProfileKey() {
        return super.getProfileKey();
    }

    public void start() throws Exception {
        if (this.getProfileService() == null) {
            throw new IllegalStateException("Must configure profileService");
        }
        String[] rootSubProfiles = new String[]{};
        ProfileMetaData metadata = this.createProfileMetaData(true, this.deployURI, rootSubProfiles);
        this.setProfileKey(this.getProfileService().registerProfile(metadata));
    }

    public void stop() throws Exception {
        ProfileService profSvc = this.getProfileService();
        ProfileKey profKey = this.getProfileKey();
        if (profSvc != null && profKey != null) {
            try {
                if (profSvc.getActiveProfileKeys().contains(profKey)) {
                    this.releaseProfile();
                }
                profSvc.unregisterProfile(profKey);
            }
            catch (NoSuchProfileException e) {
                this.log.warn((Object)("Could not unregister unknown profile " + profKey));
            }
        }
    }

    private ProfileMetaData createProfileMetaData(boolean hotDeployment, URI deployURI, String[] subProfiles) {
        Object metaData = null;
        metaData = hotDeployment ? ProfileMetaDataFactory.createHotDeploymentScanningProfile((String)this.getProfileName(), (URI)deployURI, (ScanPeriod)new ScanPeriod()) : ProfileMetaDataFactory.createImmutableScanningProfile((String)this.getProfileName(), (URI)deployURI);
        return metaData;
    }
}

