/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployers.structure.spi.helpers;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.jboss.dependency.spi.ControllerContext;
import org.jboss.deployers.structure.spi.DeploymentRegistry;
import org.jboss.deployers.structure.spi.DeploymentUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractDeploymentRegistry
implements DeploymentRegistry {
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private final Map<ControllerContext, DeploymentUnit> contextMapping = new ConcurrentHashMap<ControllerContext, DeploymentUnit>();
    private final Map<DeploymentUnit, Set<ControllerContext>> deploymentMapping = new HashMap<DeploymentUnit, Set<ControllerContext>>();

    private void check(ControllerContext context, DeploymentUnit unit) {
        if (context == null || unit == null) {
            throw new IllegalArgumentException("Null context or unit: context=" + context + ", unit=" + unit);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeploymentUnit putContext(ControllerContext context, DeploymentUnit unit) {
        this.check(context, unit);
        this.lock.writeLock().lock();
        try {
            Set<ControllerContext> contexts = this.deploymentMapping.get(unit);
            if (contexts == null) {
                contexts = new HashSet<ControllerContext>();
                this.deploymentMapping.put(unit, contexts);
            }
            contexts.add(context);
        }
        finally {
            this.lock.writeLock().unlock();
        }
        return this.contextMapping.put(context, unit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeploymentUnit removeContext(ControllerContext context, DeploymentUnit unit) {
        this.check(context, unit);
        this.lock.writeLock().lock();
        try {
            Set<ControllerContext> contexts = this.deploymentMapping.get(unit);
            if (contexts != null) {
                contexts.remove(context);
                if (contexts.isEmpty()) {
                    this.deploymentMapping.remove(unit);
                }
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
        return this.contextMapping.remove(context);
    }

    @Override
    public DeploymentUnit getDeployment(ControllerContext context) {
        if (context == null) {
            throw new IllegalArgumentException("Null context");
        }
        return this.contextMapping.get(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<ControllerContext> getContexts(DeploymentUnit unit) {
        if (unit == null) {
            throw new IllegalArgumentException("Null deployment unit");
        }
        this.lock.readLock().lock();
        try {
            Set<ControllerContext> contexts = this.deploymentMapping.get(unit);
            HashSet<ControllerContext> hashSet = contexts != null ? new HashSet<ControllerContext>(contexts) : Collections.emptySet();
            return hashSet;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }
}

