/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.ssl;

import java.security.InvalidAlgorithmParameterException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import javax.net.ssl.ManagerFactoryParameters;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.TrustManagerFactorySpi;
import org.jboss.logging.Logger;
import org.jboss.security.ssl.JBossSSLConfiguration;

abstract class TrustManagerFactoryImpl
extends TrustManagerFactorySpi {
    protected String defaultAlgorithm;
    protected TrustManagerFactory delegate;
    protected Logger log = Logger.getLogger(TrustManagerFactoryImpl.class);
    protected JBossSSLConfiguration sslConfiguration = JBossSSLConfiguration.getInstance();

    public TrustManagerFactoryImpl() {
        this.defaultAlgorithm = TrustManagerFactory.getDefaultAlgorithm();
    }

    protected TrustManager[] engineGetTrustManagers() {
        return this.delegate.getTrustManagers();
    }

    protected void engineInit(KeyStore ks) throws KeyStoreException {
        this.sslConfiguration.initializeTrustManagerFactory(this.delegate, ks);
    }

    protected void engineInit(ManagerFactoryParameters spec) throws InvalidAlgorithmParameterException {
        this.sslConfiguration.initializeTrustManagerFactory(this.delegate, spec);
    }

    public static class IbmPKIX
    extends TrustManagerFactoryImpl {
        public IbmPKIX() {
            try {
                this.delegate = TrustManagerFactory.getInstance(this.defaultAlgorithm, "IBMJSSE2");
            }
            catch (Exception e) {
                this.log.error((Object)"Could not initialize TrustManagerFactory", (Throwable)e);
                throw new IllegalStateException(e);
            }
        }
    }

    public static class SunPKIX
    extends TrustManagerFactoryImpl {
        public SunPKIX() {
            try {
                this.delegate = TrustManagerFactory.getInstance(this.defaultAlgorithm, "SunJSSE");
            }
            catch (Exception e) {
                this.log.error((Object)"Could not initialize TrustManagerFactory", (Throwable)e);
                throw new IllegalStateException(e);
            }
        }
    }
}

