/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.scanning.deployers;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.deployers.vfs.spi.structure.VFSDeploymentUnit;
import org.jboss.scanning.deployers.ClasspathSelector;
import org.jboss.scanning.plugins.DeploymentUnitScanner;
import org.jboss.vfs.VirtualFile;

public class VFSDeploymentUnitScanner
extends DeploymentUnitScanner {
    private static final ClasspathSelector DEFAULT = new DefaultClasspathSelector();

    private static ClasspathSelector check(ClasspathSelector selector) {
        if (selector == null) {
            selector = DEFAULT;
        }
        return selector;
    }

    public VFSDeploymentUnitScanner(VFSDeploymentUnit unit) throws Exception {
        this(unit, DEFAULT);
    }

    public VFSDeploymentUnitScanner(VFSDeploymentUnit unit, ClasspathSelector selector) throws Exception {
        super((DeploymentUnit)unit, VFSDeploymentUnitScanner.check(selector).select(unit));
    }

    public boolean doScan() {
        return this.getRoots().length > 0;
    }

    private static class DefaultClasspathSelector
    implements ClasspathSelector {
        private DefaultClasspathSelector() {
        }

        public URL[] select(VFSDeploymentUnit unit) throws Exception {
            ArrayList<URL> urls = new ArrayList<URL>();
            List cps = unit.getClassPath();
            if (cps != null && cps.size() > 0) {
                for (VirtualFile cp : cps) {
                    urls.add(cp.toURL());
                }
            }
            return urls.toArray(new URL[urls.size()]);
        }
    }
}

