/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.common;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class Normalizer {
    private static final Pattern PATTERN = Pattern.compile("[&<>'\"\r\n]");

    public static String normalize(String strValue) {
        return Normalizer.normalize(strValue, false);
    }

    public static String normalize(String strValue, boolean canonical) {
        Matcher m = PATTERN.matcher(strValue);
        if (m.find()) {
            int pos = m.start();
            int len = strValue.length();
            char[] input = new char[len];
            strValue.getChars(0, len, input, 0);
            StringBuilder sb = new StringBuilder(len * 3);
            int copyStart = 0;
            block8: for (int i = pos; i < len; ++i) {
                char ch = input[i];
                switch (ch) {
                    case '<': {
                        if (copyStart < i) {
                            sb.append(input, copyStart, i - copyStart);
                        }
                        copyStart = i + 1;
                        sb.append("&lt;");
                        continue block8;
                    }
                    case '>': {
                        if (copyStart < i) {
                            sb.append(input, copyStart, i - copyStart);
                        }
                        copyStart = i + 1;
                        sb.append("&gt;");
                        continue block8;
                    }
                    case '\"': {
                        if (copyStart < i) {
                            sb.append(input, copyStart, i - copyStart);
                        }
                        copyStart = i + 1;
                        sb.append("&quot;");
                        continue block8;
                    }
                    case '\'': {
                        if (copyStart < i) {
                            sb.append(input, copyStart, i - copyStart);
                        }
                        copyStart = i + 1;
                        sb.append("&apos;");
                        continue block8;
                    }
                    case '&': {
                        if (copyStart < i) {
                            sb.append(input, copyStart, i - copyStart);
                        }
                        copyStart = i + 1;
                        sb.append("&amp;");
                        continue block8;
                    }
                    case '\n': 
                    case '\r': {
                        if (!canonical) continue block8;
                        if (copyStart < i) {
                            sb.append(input, copyStart, i - copyStart);
                        }
                        copyStart = i + 1;
                        sb.append("&#");
                        sb.append(Integer.toString(ch));
                        sb.append(';');
                    }
                }
            }
            if (copyStart < len) {
                sb.append(input, copyStart, len - copyStart);
            }
            return sb.toString();
        }
        return strValue;
    }
}

