/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.system.server.profileservice.repository.clustered.metadata;

import java.io.Serializable;
import java.util.Collection;
import java.util.Set;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlNsForm;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.jboss.profileservice.spi.ProfileKey;
import org.jboss.system.server.profileservice.repository.clustered.metadata.AbstractSortedMetadataContainer;
import org.jboss.system.server.profileservice.repository.clustered.metadata.RepositoryRootMetadata;
import org.jboss.xb.annotations.JBossXmlSchema;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XmlRootElement(name="repository-content", namespace="")
@JBossXmlSchema(ignoreUnresolvedFieldOrClass=false, namespace="", elementFormDefault=XmlNsForm.UNSET, normalizeSpace=true)
@XmlType(name="repositoryContentType", propOrder={"repositories", "name", "server", "domain"})
@XmlAccessorType(value=XmlAccessType.NONE)
public class RepositoryContentMetadata
extends AbstractSortedMetadataContainer<String, RepositoryRootMetadata>
implements Serializable {
    private static final long serialVersionUID = -557008659849613674L;
    private String domain;
    private String server;
    private String name;

    public RepositoryContentMetadata() {
    }

    public RepositoryContentMetadata(ProfileKey key) {
        this();
        if (key == null) {
            throw new IllegalArgumentException("Null key");
        }
        this.setDomain(key.getDomain());
        this.setServer(key.getServer());
        this.setName(key.getName());
    }

    public RepositoryContentMetadata(RepositoryContentMetadata toCopy) {
        this();
        if (toCopy == null) {
            throw new IllegalArgumentException("Null toCopy");
        }
        this.setDomain(toCopy.getDomain());
        this.setServer(toCopy.getServer());
        this.setName(toCopy.getName());
        Collection exposed = this.getExposedCollection();
        for (RepositoryRootMetadata rmd : toCopy.getRepositories()) {
            exposed.add(new RepositoryRootMetadata(rmd));
        }
    }

    @XmlElement(name="repository-root", type=RepositoryRootMetadata.class, required=true)
    public Collection<RepositoryRootMetadata> getRepositories() {
        return this.getExposedCollection();
    }

    public void setRepositories(Collection<RepositoryRootMetadata> repositories) {
        Collection internal = this.getExposedCollection();
        internal.clear();
        if (repositories != null) {
            internal.addAll(repositories);
        }
    }

    public RepositoryRootMetadata getRepositoryRootMetadata(String repositoryRoot) {
        return (RepositoryRootMetadata)this.getContainedMetadata(repositoryRoot);
    }

    public Set<String> getRootNames() {
        return this.getContainedMetadataIds();
    }

    @XmlAttribute(name="name", required=true)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Null name");
        }
        this.name = name;
    }

    @XmlAttribute(name="server", required=true)
    public String getServer() {
        return this.server;
    }

    public void setServer(String server) {
        if (server == null) {
            throw new IllegalArgumentException("Null server");
        }
        this.server = server;
    }

    @XmlAttribute(name="domain", required=true)
    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        if (domain == null) {
            throw new IllegalArgumentException("Null domain");
        }
        this.domain = domain;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof RepositoryContentMetadata) {
            RepositoryContentMetadata other = (RepositoryContentMetadata)obj;
            return ((Object)this.getExposedCollection()).equals(other.getExposedCollection()) && RepositoryContentMetadata.safeEquals(this.name, other.name) && RepositoryContentMetadata.safeEquals(this.server, other.server) && RepositoryContentMetadata.safeEquals(this.domain, other.domain);
        }
        return false;
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.server == null ? 0 : this.server.hashCode());
        result = 31 * result + (this.domain == null ? 0 : this.domain.hashCode());
        result = 31 * result + ((Object)this.getExposedCollection()).hashCode();
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getName()).append("[domain=").append(this.domain).append(",server=").append(this.server).append(",name=").append(this.name).append(",roots={");
        boolean first = true;
        for (String root : this.getRootNames()) {
            if (!first) {
                sb.append(',');
            } else {
                first = false;
            }
            sb.append(root);
        }
        sb.append("}]");
        return sb.toString();
    }

    private static boolean safeEquals(Object a, Object b) {
        return a == b || a != null && a.equals(b);
    }
}

