/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.system.server.profileservice.repository.clustered.local.file;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.jboss.logging.Logger;
import org.jboss.system.server.profileservice.repository.clustered.local.file.FileBasedSynchronizationActionContext;
import org.jboss.system.server.profileservice.repository.clustered.sync.AbstractSynchronizationAction;
import org.jboss.system.server.profileservice.repository.clustered.sync.ByteChunk;
import org.jboss.system.server.profileservice.repository.clustered.sync.ContentModification;
import org.jboss.system.server.profileservice.repository.clustered.sync.SynchronizationReadAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileReadAction
extends AbstractSynchronizationAction<FileBasedSynchronizationActionContext>
implements SynchronizationReadAction<FileBasedSynchronizationActionContext> {
    private static final Logger log = Logger.getLogger(FileReadAction.class);
    public static final int MAX_CHUNK_BUFFER_SIZE = 524288;
    private final File file;
    private InputStream stream;

    public FileReadAction(File file, FileBasedSynchronizationActionContext context, ContentModification modification) {
        super(context, modification);
        if (file == null) {
            throw new IllegalArgumentException("Null file");
        }
        this.file = file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ByteChunk getNextBytes() throws IOException {
        InputStream is = this.getInputStream();
        byte[] b = null;
        int read = -1;
        InputStream inputStream = is;
        synchronized (inputStream) {
            b = new byte[524288];
            read = is.read(b);
        }
        return new ByteChunk(b, read);
    }

    @Override
    protected void doCancel() {
        this.safeCloseStream();
    }

    @Override
    protected void doCommit() {
        this.safeCloseStream();
    }

    @Override
    protected void doComplete() throws Exception {
        this.safeCloseStream();
        if (log.isTraceEnabled()) {
            ContentModification mod = this.getRepositoryContentModification();
            log.trace((Object)("doComplete(): " + (Object)((Object)mod.getType()) + " for " + mod.getItem().getRelativePath()));
        }
    }

    @Override
    protected boolean doPrepare() {
        this.safeCloseStream();
        return true;
    }

    @Override
    protected void doRollbackFromCancelled() {
        this.safeCloseStream();
    }

    @Override
    protected void doRollbackFromComplete() {
        this.safeCloseStream();
    }

    @Override
    protected void doRollbackFromOpen() {
        this.safeCloseStream();
    }

    @Override
    protected void doRollbackFromPrepared() {
        this.safeCloseStream();
    }

    @Override
    protected void doRollbackFromRollbackOnly() {
        this.safeCloseStream();
    }

    private synchronized InputStream getInputStream() throws IOException {
        AbstractSynchronizationAction.State s = this.getState();
        if (s != AbstractSynchronizationAction.State.OPEN && s != AbstractSynchronizationAction.State.CANCELLED) {
            throw new IllegalStateException("Cannot read when state is " + (Object)((Object)s));
        }
        if (this.stream == null) {
            FileInputStream fis = new FileInputStream(this.file);
            this.stream = new BufferedInputStream(fis);
        }
        return this.stream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void safeCloseStream() {
        if (this.stream != null) {
            InputStream inputStream = this.stream;
            synchronized (inputStream) {
                try {
                    this.stream.close();
                }
                catch (IOException e) {
                    ContentModification mod = this.getRepositoryContentModification();
                    log.debug((Object)("Caught exception closing stream for " + mod.getRootName() + " " + mod.getItem().getRelativePath()), (Throwable)e);
                }
                finally {
                    this.stream = null;
                }
            }
        }
    }
}

