/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.classloader.spi;

import java.net.URL;
import java.util.jar.Attributes;
import java.util.jar.Manifest;

public class PackageInformation {
    public String packageName;
    public String specTitle;
    public String specVersion;
    public String specVendor;
    public String implTitle;
    public String implVersion;
    public String implVendor;
    public URL sealBase;

    public PackageInformation(String packageName) {
        this(packageName, null, null);
    }

    public PackageInformation(String packageName, Manifest manifest) {
        this(packageName, manifest, null);
    }

    public PackageInformation(String packageName, Manifest manifest, URL seal) {
        if (packageName == null) {
            throw new IllegalArgumentException("Null package name");
        }
        if (manifest != null) {
            String path = packageName.replace('.', '/').concat("/");
            String sealed = null;
            Attributes attributes = manifest.getAttributes(path);
            if (attributes != null) {
                this.specTitle = attributes.getValue(Attributes.Name.SPECIFICATION_TITLE);
                this.specVersion = attributes.getValue(Attributes.Name.SPECIFICATION_VERSION);
                this.specVendor = attributes.getValue(Attributes.Name.SPECIFICATION_VENDOR);
                this.implTitle = attributes.getValue(Attributes.Name.IMPLEMENTATION_TITLE);
                this.implVersion = attributes.getValue(Attributes.Name.IMPLEMENTATION_VERSION);
                this.implVendor = attributes.getValue(Attributes.Name.IMPLEMENTATION_VENDOR);
                sealed = attributes.getValue(Attributes.Name.SEALED);
            }
            if ((attributes = manifest.getMainAttributes()) != null) {
                if (this.specTitle == null) {
                    this.specTitle = attributes.getValue(Attributes.Name.SPECIFICATION_TITLE);
                    this.specVersion = attributes.getValue(Attributes.Name.SPECIFICATION_VERSION);
                    this.specVendor = attributes.getValue(Attributes.Name.SPECIFICATION_VENDOR);
                }
                if (this.implTitle == null) {
                    this.implTitle = attributes.getValue(Attributes.Name.IMPLEMENTATION_TITLE);
                    this.implVersion = attributes.getValue(Attributes.Name.IMPLEMENTATION_VERSION);
                    this.implVendor = attributes.getValue(Attributes.Name.IMPLEMENTATION_VENDOR);
                }
                if (sealed == null) {
                    sealed = attributes.getValue(Attributes.Name.SEALED);
                }
            }
            if (seal != null && "true".equalsIgnoreCase(sealed)) {
                this.sealBase = seal;
            }
        }
    }
}

