/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.server.sei;

import com.sun.istack.NotNull;
import com.sun.xml.ws.api.WSBinding;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.pipe.NextAction;
import com.sun.xml.ws.api.server.Invoker;
import com.sun.xml.ws.model.AbstractSEIModelImpl;
import com.sun.xml.ws.model.JavaMethodImpl;
import com.sun.xml.ws.server.InvokerTube;
import com.sun.xml.ws.server.WSEndpointImpl;
import com.sun.xml.ws.server.sei.EndpointMethodHandler;
import com.sun.xml.ws.util.QNameMap;
import com.sun.xml.ws.wsdl.DispatchException;
import javax.xml.namespace.QName;

public class SEIInvokerTube
extends InvokerTube {
    private final WSBinding binding;
    private final AbstractSEIModelImpl model;
    private final QNameMap<EndpointMethodHandler> wsdlOpMap;

    public SEIInvokerTube(AbstractSEIModelImpl model, Invoker invoker, WSBinding binding) {
        super(invoker);
        this.binding = binding;
        this.model = model;
        this.wsdlOpMap = new QNameMap();
        for (JavaMethodImpl jm : model.getJavaMethods()) {
            this.wsdlOpMap.put(jm.getOperation().getName(), new EndpointMethodHandler(this, jm, binding));
        }
    }

    @NotNull
    public NextAction processRequest(@NotNull Packet req) {
        try {
            QName wsdlOp = ((WSEndpointImpl)this.getEndpoint()).getOperationDispatcher().getWSDLOperationQName(req);
            Packet res = this.wsdlOpMap.get(wsdlOp).invoke(req);
            assert (res != null);
            return this.doReturnWith(res);
        }
        catch (DispatchException e) {
            return this.doReturnWith(req.createServerResponse(e.fault, this.model.getPort(), null, this.binding));
        }
    }

    @NotNull
    public NextAction processResponse(@NotNull Packet response) {
        throw new IllegalStateException("InovkerPipe's processResponse shouldn't be called.");
    }

    @NotNull
    public NextAction processException(@NotNull Throwable t) {
        throw new IllegalStateException("InovkerPipe's processException shouldn't be called.");
    }
}

