/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.renderkit.compiler;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.el.MethodNotFoundException;
import org.ajax4jsf.Messages;
import org.ajax4jsf.renderkit.compiler.Invoker;
import org.ajax4jsf.renderkit.compiler.MethodCallElement;
import org.ajax4jsf.renderkit.compiler.TemplateContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class StaticInvoker
extends Invoker {
    String className;
    Class<?> cls;
    Map<String, Method> methods = new HashMap<String, Method>();

    StaticInvoker(String methodName) {
        super(methodName);
        int i = methodName.lastIndexOf(46);
        this.className = methodName.substring(0, i);
        this.methodName = methodName.substring(i + 1);
        try {
            this.cls = Thread.currentThread().getContextClassLoader().loadClass(this.className);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    @Override
    public Class<?> getInvokedClass(TemplateContext context) {
        return this.cls;
    }

    @Override
    public Object getInvokedObject(TemplateContext context) {
        return null;
    }

    @Override
    void handleInvocationTargetException(TemplateContext context, InvocationTargetException e) {
        MethodCallElement._log.error((Object)Messages.getMessage((String)"METHOD_CALL_ERROR_1a", (Object)this.methodName, (Object)context.getComponent().getId()), (Throwable)e);
        throw new FacesException(Messages.getMessage((String)"METHOD_CALL_ERROR_2a", (Object[])new Object[]{this.methodName, context.getComponent().getId(), e.getCause().getMessage()}), (Throwable)e);
    }

    @Override
    void handleIllegalAccessException(TemplateContext context, IllegalAccessException e) {
        MethodCallElement._log.error((Object)Messages.getMessage((String)"METHOD_CALL_ERROR_3a", (Object)this.methodName, (Object)context.getComponent().getId()), (Throwable)e);
        throw new FacesException(Messages.getMessage((String)"METHOD_CALL_ERROR_4a", (Object[])new Object[]{this.methodName, context.getComponent().getId(), e.getCause().getMessage()}), (Throwable)e);
    }

    @Override
    void handleMethodNotFoundException(TemplateContext context) throws MethodNotFoundException {
        MethodCallElement._log.error((Object)Messages.getMessage((String)"METHOD_CALL_ERROR_5a", (Object)this.methodName, (Object)context.getComponent().getId()));
        throw new MethodNotFoundException(Messages.getMessage((String)"METHOD_CALL_ERROR_6a", (Object)this.methodName));
    }
}

