/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.cache.infinispan;

import java.util.concurrent.TimeUnit;
import org.infinispan.Cache;
import org.infinispan.config.Configuration;
import org.infinispan.manager.EmbeddedCacheManager;
import org.jboss.ejb3.annotation.CacheConfig;
import org.jboss.ejb3.cache.infinispan.CacheSource;
import org.jboss.ejb3.stateful.StatefulContainer;
import org.jboss.ha.ispn.CacheContainerRegistry;
import org.jboss.util.StringPropertyReplacer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultCacheSource
implements CacheSource {
    public static final String PREFIX = "infinispan.";
    public static final String MODE = "mode";
    public static final String OWNERS = "owners";
    private final CacheContainerRegistry registry;

    public DefaultCacheSource(CacheContainerRegistry registry) {
        this.registry = registry;
    }

    @Override
    public <K, V> Cache<K, V> getCache(StatefulContainer ejbContainer) {
        CacheConfig cacheConfig = (CacheConfig)ejbContainer.getAnnotation(CacheConfig.class);
        String containerName = StringPropertyReplacer.replaceProperties((String)cacheConfig.name());
        String templateCacheName = null;
        if (containerName == null || containerName.isEmpty()) {
            containerName = "jboss.cache:service=EJB3SFSBClusteredCache";
        } else {
            String[] parts = containerName.split("/");
            if (parts.length == 2) {
                containerName = parts[0];
                templateCacheName = parts[1];
            }
        }
        String cacheName = ejbContainer.getDeploymentPropertyListString();
        EmbeddedCacheManager container = this.registry.getCacheContainer(containerName);
        Configuration configuration = container.defineConfiguration(cacheName, templateCacheName, new Configuration());
        configuration.setEvictionMaxEntries(cacheConfig.maxSize());
        if (configuration.getCacheMode().isDistributed()) {
            configuration.setL1CacheEnabled(true);
            configuration.setL1Lifespan(TimeUnit.SECONDS.toMillis(cacheConfig.idleTimeoutSeconds()));
        }
        return container.getCache(cacheName);
    }
}

