/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.kernel.plugins.qualifier;

import java.lang.annotation.Annotation;
import org.jboss.annotation.factory.AnnotationCreator;
import org.jboss.beans.metadata.api.model.QualifierContent;
import org.jboss.kernel.spi.qualifier.QualifierParser;

public class AnnotationQualiferParser
implements QualifierParser {
    public static AnnotationQualiferParser INSTANCE = new AnnotationQualiferParser();

    private AnnotationQualiferParser() {
    }

    public QualifierContent getHandledContent() {
        return QualifierContent.ANNOTATION;
    }

    public Object parseSupplied(ClassLoader cl, Object rawQualifier) {
        return this.parse(cl, rawQualifier);
    }

    public Object parseWanted(ClassLoader cl, Object rawQualifier) {
        return this.parse(cl, rawQualifier);
    }

    private Object parse(ClassLoader cl, Object rawQualifier) {
        if (rawQualifier instanceof Annotation) {
            return rawQualifier;
        }
        if (!(rawQualifier instanceof String)) {
            throw new IllegalArgumentException(rawQualifier + " is neither an annotation nor a string");
        }
        String annString = (String)rawQualifier;
        try {
            if (cl == null) {
                cl = Thread.currentThread().getContextClassLoader();
            }
            return AnnotationCreator.createAnnotation((String)annString, (ClassLoader)cl);
        }
        catch (Throwable e) {
            throw new RuntimeException("Error creating annotation for " + rawQualifier, e);
        }
    }
}

