/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.kernel.plugins.annotations;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jboss.beans.metadata.plugins.AbstractInstallMetaData;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.beans.metadata.spi.InstallMetaData;
import org.jboss.beans.metadata.spi.MetaDataVisitorNode;
import org.jboss.beans.metadata.spi.ParameterMetaData;
import org.jboss.joinpoint.plugins.Config;
import org.jboss.kernel.plugins.annotations.AbstractMethodParameterAnnotationPlugin;
import org.jboss.kernel.plugins.annotations.Annotation2ValueMetaDataAdapter;
import org.jboss.reflect.spi.MethodInfo;
import org.jboss.reflect.spi.ParameterInfo;
import org.jboss.reflect.spi.TypeInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class InstallationParameterAnnotationPlugin<C extends Annotation>
extends AbstractMethodParameterAnnotationPlugin<C, AbstractInstallMetaData> {
    protected InstallationParameterAnnotationPlugin(Class<C> annotation, Map<Class<? extends Annotation>, Annotation2ValueMetaDataAdapter<? extends Annotation>> adapters) {
        super(annotation, adapters);
    }

    @Override
    protected boolean checkAnnotatedInfo(ElementType type) {
        return ElementType.METHOD == type;
    }

    @Override
    protected boolean isMetaDataAlreadyPresent(MethodInfo info, C annotation, BeanMetaData beanMetaData) {
        List<InstallMetaData> installs = this.getInstalls(beanMetaData);
        if (installs != null && !installs.isEmpty()) {
            for (InstallMetaData install : installs) {
                if (install.getBean() != null || !install.getMethodName().equals(info.getName())) continue;
                List<ParameterMetaData> parameters = install.getParameters();
                ParameterInfo[] parameterInfos = info.getParameters();
                if (parameters == null && parameterInfos != null && parameterInfos.length == 0) {
                    return true;
                }
                if (parameters != null && parameters.size() == 0 && parameterInfos == null) {
                    return true;
                }
                if (parameters == null || parameterInfos == null || parameters.size() != parameterInfos.length) continue;
                int n = parameters.size();
                String[] typeNames = new String[n];
                TypeInfo[] typeInfos = new TypeInfo[n];
                for (int i = 0; i < n; ++i) {
                    typeNames[i] = parameters.get(i).getType();
                    typeInfos[i] = parameterInfos[i].getParameterType();
                }
                return Config.equals((String[])typeNames, (TypeInfo[])typeInfos);
            }
        }
        return false;
    }

    protected abstract List<InstallMetaData> getInstalls(BeanMetaData var1);

    @Override
    protected ParameterInfo[] getParameters(MethodInfo info) {
        return info.getParameters();
    }

    @Override
    protected List<? extends MetaDataVisitorNode> handleParameterlessInfo(MethodInfo info, C annotation, BeanMetaData beanMetaData) {
        AbstractInstallMetaData parametrizedMetaData = (AbstractInstallMetaData)this.createParametrizedMetaData(info, annotation);
        this.setParameterizedMetaData(parametrizedMetaData, beanMetaData);
        return Collections.singletonList(parametrizedMetaData);
    }
}

