/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.naming.namemanager;

import java.io.Serializable;
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import org.jacorb.naming.namemanager.NSTree;
import org.jacorb.orb.Delegate;
import org.jacorb.orb.ParsedIOR;
import org.jacorb.orb.iiop.IIOPAddress;
import org.jacorb.orb.iiop.IIOPProfile;
import org.omg.CORBA.portable.ObjectImpl;
import org.omg.CosNaming.Binding;
import org.omg.CosNaming.BindingIteratorHolder;
import org.omg.CosNaming.BindingListHolder;
import org.omg.CosNaming.BindingType;
import org.omg.CosNaming.NameComponent;
import org.omg.CosNaming.NamingContextExt;
import org.omg.CosNaming.NamingContextExtHelper;
import org.omg.CosNaming.NamingContextPackage.CannotProceed;
import org.omg.CosNaming.NamingContextPackage.InvalidName;
import org.omg.CosNaming.NamingContextPackage.NotFound;

public class ContextNode {
    protected Binding[] contents;
    public boolean matched;
    public boolean used = false;
    public NamingContextExt context;
    private DefaultMutableTreeNode myDefaultNode;
    private DefaultTreeModel model;
    private Binding binding;
    private Vector bindingData;
    private String myName;

    public ContextNode(NamingContextExt namingContextExt, DefaultTreeModel defaultTreeModel) {
        this.model = defaultTreeModel;
        this.context = namingContextExt;
    }

    public ContextNode(NamingContextExt namingContextExt, Binding binding, DefaultTreeModel defaultTreeModel) {
        this.model = defaultTreeModel;
        this.context = namingContextExt;
        this.binding = binding;
    }

    public void display() {
        this.update();
        if (this.bindingData != null) {
            NSTree.nsTable.setData(this.bindingData, this);
        }
    }

    public boolean equals(ContextNode contextNode) {
        return this.toString().equals(contextNode.toString());
    }

    public NameComponent[] getName() {
        return this.binding.binding_name;
    }

    public void setNode(DefaultMutableTreeNode defaultMutableTreeNode) {
        this.myDefaultNode = defaultMutableTreeNode;
    }

    public String toString() {
        if (this.binding == null) {
            return "RootContext";
        }
        if (this.myName == null) {
            NameComponent[] nameComponentArray = this.binding.binding_name;
            String string = nameComponentArray[nameComponentArray.length - 1].kind;
            this.myName = nameComponentArray[nameComponentArray.length - 1].id + (string != null && string.length() > 0 ? "." + string : "");
        }
        return this.myName;
    }

    public void unbind(NameComponent[] nameComponentArray) throws NotFound, CannotProceed, InvalidName {
        this.context.unbind(nameComponentArray);
    }

    public synchronized void update() {
        try {
            Vector vector;
            ParsedIOR parsedIOR;
            NameComponent[] nameComponentArray;
            Serializable serializable;
            int n;
            int n2;
            ContextNode contextNode;
            int n3;
            BindingListHolder bindingListHolder = new BindingListHolder();
            BindingIteratorHolder bindingIteratorHolder = new BindingIteratorHolder();
            this.context.list(40, bindingListHolder, bindingIteratorHolder);
            Binding[] bindingArray = bindingListHolder.value;
            int n4 = this.myDefaultNode.getChildCount();
            int n5 = 0;
            int n6 = 0;
            for (int i = 0; i < bindingArray.length; ++i) {
                if (bindingArray[i].binding_type == BindingType.ncontext) {
                    ++n5;
                    continue;
                }
                ++n6;
            }
            ContextNode[] contextNodeArray = new ContextNode[n5];
            Binding[] bindingArray2 = new Binding[n6];
            for (n3 = 0; n3 < bindingArray.length; ++n3) {
                if (bindingArray[n3].binding_type == BindingType.ncontext) {
                    contextNodeArray[--n5] = new ContextNode(NamingContextExtHelper.narrow(this.context.resolve(bindingArray[n3].binding_name)), bindingArray[n3], this.model);
                    continue;
                }
                bindingArray2[--n6] = bindingArray[n3];
            }
            for (n3 = 0; n3 < n4; ++n3) {
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.myDefaultNode.getChildAt(n3);
                contextNode = (ContextNode)defaultMutableTreeNode.getUserObject();
                for (int i = 0; i < contextNodeArray.length; ++i) {
                    if (!contextNode.equals(contextNodeArray[i])) continue;
                    contextNode.matched = true;
                    contextNodeArray[i].matched = true;
                }
            }
            Vector<DefaultMutableTreeNode> vector2 = new Vector<DefaultMutableTreeNode>();
            for (n2 = 0; n2 < n4; ++n2) {
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.myDefaultNode.getChildAt(n2);
                contextNode = (ContextNode)defaultMutableTreeNode.getUserObject();
                if (!contextNode.matched) {
                    vector2.addElement(defaultMutableTreeNode);
                    continue;
                }
                contextNode.matched = false;
            }
            n2 = vector2.size();
            for (n = 0; n < n2; ++n) {
                this.model.removeNodeFromParent((DefaultMutableTreeNode)vector2.elementAt(n));
            }
            this.bindingData = new Vector();
            for (n = 0; n < contextNodeArray.length; ++n) {
                if (!contextNodeArray[n].matched) {
                    contextNodeArray[n].used = true;
                    serializable = new DefaultMutableTreeNode();
                    contextNodeArray[n].setNode((DefaultMutableTreeNode)serializable);
                    ((DefaultMutableTreeNode)serializable).setUserObject(contextNodeArray[n]);
                    ((DefaultMutableTreeNode)serializable).setAllowsChildren(true);
                    this.model.insertNodeInto((MutableTreeNode)((Object)serializable), this.myDefaultNode, 0);
                }
                serializable = contextNodeArray[n].binding.binding_name[contextNodeArray[n].binding.binding_name.length - 1];
                nameComponentArray = new NameComponent[]{serializable};
                parsedIOR = null;
                try {
                    parsedIOR = ((Delegate)((ObjectImpl)this.context.resolve(nameComponentArray))._get_delegate()).getParsedIOR();
                }
                catch (NotFound notFound) {
                    continue;
                }
                vector = this.createRow((NameComponent)serializable, parsedIOR);
                this.bindingData.addElement(vector);
            }
            for (n = 0; n < bindingArray2.length; ++n) {
                serializable = bindingArray2[n].binding_name[bindingArray2[n].binding_name.length - 1];
                nameComponentArray = new NameComponent[]{serializable};
                parsedIOR = null;
                try {
                    parsedIOR = ((Delegate)((ObjectImpl)this.context.resolve(nameComponentArray))._get_delegate()).getParsedIOR();
                }
                catch (NotFound notFound) {
                    continue;
                }
                vector = this.createRow((NameComponent)serializable, parsedIOR);
                this.bindingData.addElement(vector);
            }
            n4 = this.myDefaultNode.getChildCount();
            for (n = 0; n < n4; ++n) {
                serializable = (DefaultMutableTreeNode)this.myDefaultNode.getChildAt(n);
                contextNode = (ContextNode)((DefaultMutableTreeNode)serializable).getUserObject();
                contextNode.update();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private Vector createRow(NameComponent nameComponent, ParsedIOR parsedIOR) {
        Vector<String> vector = new Vector<String>();
        vector.addElement(nameComponent.id);
        vector.addElement(nameComponent.kind);
        vector.addElement(parsedIOR.getTypeId());
        IIOPProfile iIOPProfile = (IIOPProfile)parsedIOR.getEffectiveProfile();
        IIOPAddress iIOPAddress = (IIOPAddress)iIOPProfile.getAddress();
        vector.addElement(iIOPAddress.getIP());
        vector.addElement(Integer.toString(iIOPAddress.getPort()));
        return vector;
    }
}

