/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.util;

import java.io.IOException;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jgroups.util.SocketFactory;
import org.jgroups.util.Util;

public class DefaultSocketFactory
implements SocketFactory {
    protected final Map<Object, String> sockets = new ConcurrentHashMap<Object, String>();

    @Override
    public Socket createSocket(String service_name) throws IOException {
        return this.add(new Socket(), service_name);
    }

    @Override
    public Socket createSocket(String service_name, String host, int port) throws IOException {
        return this.add(new Socket(host, port), service_name);
    }

    @Override
    public Socket createSocket(String service_name, InetAddress address, int port) throws IOException {
        return this.add(new Socket(address, port), service_name);
    }

    @Override
    public Socket createSocket(String service_name, String host, int port, InetAddress localAddr, int localPort) throws IOException {
        return this.add(new Socket(host, port, localAddr, localPort), service_name);
    }

    @Override
    public Socket createSocket(String service_name, InetAddress address, int port, InetAddress localAddr, int localPort) throws IOException {
        return this.add(new Socket(address, port, localAddr, localPort), service_name);
    }

    @Override
    public ServerSocket createServerSocket(String service_name) throws IOException {
        return this.add(new ServerSocket(), service_name);
    }

    @Override
    public ServerSocket createServerSocket(String service_name, int port) throws IOException {
        return this.add(new ServerSocket(port), service_name);
    }

    @Override
    public ServerSocket createServerSocket(String service_name, int port, int backlog) throws IOException {
        return this.add(new ServerSocket(port, backlog), service_name);
    }

    @Override
    public ServerSocket createServerSocket(String service_name, int port, int backlog, InetAddress bindAddr) throws IOException {
        return this.add(new ServerSocket(port, backlog, bindAddr), service_name);
    }

    @Override
    public DatagramSocket createDatagramSocket(String service_name) throws SocketException {
        return this.add(new DatagramSocket(), service_name);
    }

    @Override
    public DatagramSocket createDatagramSocket(String service_name, SocketAddress bindaddr) throws SocketException {
        return this.add(new DatagramSocket(bindaddr), service_name);
    }

    @Override
    public DatagramSocket createDatagramSocket(String service_name, int port) throws SocketException {
        return this.add(new DatagramSocket(port), service_name);
    }

    @Override
    public DatagramSocket createDatagramSocket(String service_name, int port, InetAddress laddr) throws SocketException {
        return this.add(new DatagramSocket(port, laddr), service_name);
    }

    @Override
    public MulticastSocket createMulticastSocket(String service_name) throws IOException {
        return this.add(new MulticastSocket(), service_name);
    }

    @Override
    public MulticastSocket createMulticastSocket(String service_name, int port) throws IOException {
        return this.add(new MulticastSocket(port), service_name);
    }

    @Override
    public MulticastSocket createMulticastSocket(String service_name, SocketAddress bindaddr) throws IOException {
        return this.add(new MulticastSocket(bindaddr), service_name);
    }

    @Override
    public void close(Socket sock) throws IOException {
        this.remove(sock);
        Util.close(sock);
    }

    @Override
    public void close(ServerSocket sock) throws IOException {
        this.remove(sock);
        Util.close(sock);
    }

    @Override
    public void close(DatagramSocket sock) {
        this.remove(sock);
        Util.close(sock);
    }

    @Override
    public Map<Object, String> getSockets() {
        return this.sockets;
    }

    protected <T> T add(T sock, String service_name) {
        if (sock != null) {
            String tmp = service_name == null ? "n/a" : service_name;
            this.sockets.put(sock, tmp);
        }
        return sock;
    }

    protected <T> void remove(T sock) {
        if (sock != null) {
            this.sockets.remove(sock);
        }
    }
}

