/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests.perf.transports;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.Properties;
import org.jgroups.stack.IpAddress;
import org.jgroups.tests.perf.Configuration;
import org.jgroups.tests.perf.IPerf;
import org.jgroups.tests.perf.Receiver;
import org.jgroups.tests.perf.Transport;

public class UdpTransport
implements Transport {
    Receiver receiver = null;
    Properties config = null;
    Configuration cfg = null;
    InetAddress mcast_addr = null;
    int mcast_port = 7500;
    InetAddress bind_addr = null;
    MulticastSocket mcast_sock = null;
    DatagramSocket ucast_sock = null;
    IpAddress local_addr = null;
    ReceiverThread mcast_receiver = null;
    ReceiverThread ucast_receiver = null;
    int max_receiver_buffer_size = 500000;
    int max_send_buffer_size = 500000;
    int max_chunk_size = 65000;

    @Override
    public Object getLocalAddress() {
        return this.local_addr;
    }

    @Override
    public String help() {
        return "-mcast_addr <addr> -mcast_port <port> -max_chunk_size <bytes>";
    }

    @Override
    public void create(Properties properties) throws Exception {
        this.config = properties;
        String mcast_addr_str = System.getProperty("udp.mcast_addr", this.config.getProperty("mcast_addr"));
        if (mcast_addr_str == null) {
            mcast_addr_str = "233.3.4.5";
        }
        this.mcast_addr = InetAddress.getByName(mcast_addr_str);
        String bind_addr_str = System.getProperty("udp.bind_addr", this.config.getProperty("bind_addr"));
        this.bind_addr = bind_addr_str != null ? InetAddress.getByName(bind_addr_str) : InetAddress.getLocalHost();
        this.ucast_sock = new DatagramSocket(0, this.bind_addr);
        this.ucast_sock.setReceiveBufferSize(this.max_receiver_buffer_size);
        this.ucast_sock.setSendBufferSize(this.max_send_buffer_size);
        this.mcast_sock = new MulticastSocket(this.mcast_port);
        this.mcast_sock.setReceiveBufferSize(this.max_receiver_buffer_size);
        this.mcast_sock.setSendBufferSize(this.max_send_buffer_size);
        if (this.bind_addr != null) {
            this.mcast_sock.setInterface(this.bind_addr);
        }
        this.mcast_sock.joinGroup(this.mcast_addr);
        this.local_addr = new IpAddress(this.ucast_sock.getLocalAddress(), this.ucast_sock.getLocalPort());
        System.out.println("-- local_addr is " + this.local_addr);
    }

    @Override
    public void create(Configuration config) throws Exception {
        this.cfg = config;
        this.bind_addr = this.cfg.getBindAddress();
        String[] args = config.getTransportArgs();
        if (args != null) {
            for (int i = 0; i < args.length; ++i) {
                if (args[i].equals("-mcast_addr")) {
                    this.mcast_addr = InetAddress.getByName(args[++i]);
                    continue;
                }
                if (args[i].equals("-mcast_port")) {
                    this.mcast_port = Integer.parseInt(args[++i]);
                    continue;
                }
                if (args[i].equals("-max_chunk_size")) {
                    int tmp;
                    if ((tmp = Integer.parseInt(args[++i])) > this.max_chunk_size || tmp < 1000) {
                        throw new IllegalArgumentException("-max_chunk_size must be <= 65K and >= 1000");
                    }
                    this.max_chunk_size = tmp;
                    continue;
                }
                this.help();
                return;
            }
        }
        if (this.mcast_addr == null) {
            this.mcast_addr = InetAddress.getByName("232.5.5.5");
        }
        if (this.bind_addr == null) {
            this.bind_addr = InetAddress.getLocalHost();
        }
        this.ucast_sock = new DatagramSocket(0, this.bind_addr);
        this.ucast_sock.setReceiveBufferSize(this.max_receiver_buffer_size);
        this.ucast_sock.setSendBufferSize(this.max_send_buffer_size);
        this.mcast_sock = new MulticastSocket(this.mcast_port);
        this.mcast_sock.setReceiveBufferSize(this.max_receiver_buffer_size);
        this.mcast_sock.setSendBufferSize(this.max_send_buffer_size);
        this.mcast_sock.setInterface(this.bind_addr);
        this.mcast_sock.joinGroup(this.mcast_addr);
        this.local_addr = new IpAddress(this.ucast_sock.getLocalAddress(), this.ucast_sock.getLocalPort());
        System.out.println("-- local_addr is " + this.local_addr);
    }

    @Override
    public void start() throws Exception {
        this.mcast_receiver = new ReceiverThread(this.mcast_sock);
        this.ucast_receiver = new ReceiverThread(this.ucast_sock);
        this.mcast_receiver.start();
        this.ucast_receiver.start();
    }

    @Override
    public void stop() {
        if (this.mcast_receiver != null) {
            this.mcast_receiver.stop();
        }
        if (this.ucast_receiver != null) {
            this.ucast_receiver.stop();
        }
    }

    @Override
    public void destroy() {
        if (this.mcast_sock != null) {
            this.mcast_sock.close();
        }
        if (this.ucast_sock != null) {
            this.ucast_sock.close();
        }
    }

    @Override
    public void setReceiver(Receiver r) {
        this.receiver = r;
    }

    @Override
    public Map dumpStats() {
        return null;
    }

    @Override
    public void send(Object destination, byte[] payload, boolean oob) throws Exception {
        int original_length = payload.length;
        if (payload.length > this.max_chunk_size) {
            int offset = 0;
            int length = this.max_chunk_size;
            ByteBuffer data = ByteBuffer.wrap(payload, 0, 5);
            IPerf.Type type = IPerf.Type.getType(data.get());
            if (type != IPerf.Type.DATA) {
                throw new IllegalArgumentException("only DATA requests can exceed the chunk size");
            }
            original_length = data.getInt();
            while (offset < original_length) {
                ByteBuffer chunk = ByteBuffer.allocate(length + 1 + 4);
                chunk.put(IPerf.Type.DATA.getByte());
                chunk.putInt(length);
                this._send(destination, chunk.array(), 0, length + 1 + 4);
                int remaining = original_length - (offset += length);
                if ((length = Math.min(remaining, this.max_chunk_size)) != 0) continue;
                break;
            }
        } else {
            this._send(destination, payload, 0, original_length);
        }
    }

    private void _send(Object destination, byte[] payload, int offset, int length) throws Exception {
        InetSocketAddress dest = destination == null ? new InetSocketAddress(this.mcast_addr, this.mcast_port) : new InetSocketAddress(((IpAddress)destination).getIpAddress(), ((IpAddress)destination).getPort());
        DatagramPacket p = new DatagramPacket(payload, offset, length, dest);
        if (destination == null) {
            this.mcast_sock.send(p);
        } else {
            this.ucast_sock.send(p);
        }
    }

    class ReceiverThread
    implements Runnable {
        DatagramSocket recv_sock;
        Thread t = null;

        ReceiverThread(DatagramSocket sock) {
            this.recv_sock = sock;
        }

        void start() throws Exception {
            this.t = new Thread((Runnable)this, "ReceiverThread for " + this.recv_sock.getLocalAddress() + ':' + this.recv_sock.getLocalPort());
            this.t.start();
        }

        void stop() {
            this.t = null;
            if (this.recv_sock != null) {
                this.recv_sock.close();
            }
        }

        @Override
        public void run() {
            byte[] buf = new byte[65535];
            while (this.t != null) {
                DatagramPacket p = new DatagramPacket(buf, buf.length);
                try {
                    this.recv_sock.receive(p);
                    if (UdpTransport.this.receiver == null) continue;
                    IpAddress addr = new IpAddress(p.getAddress(), p.getPort());
                    UdpTransport.this.receiver.receive(addr, p.getData());
                }
                catch (IOException e) {
                    if (this.recv_sock != null) continue;
                    this.t = null;
                }
            }
            this.t = null;
        }
    }
}

