/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.net.UnknownHostException;
import org.jgroups.Address;
import org.jgroups.util.SeqnoTable;
import org.jgroups.util.Util;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"functional"})
public class SeqnoTableTest {
    private static Address MBR = null;

    @BeforeClass
    private static void init() throws UnknownHostException {
        MBR = Util.createRandomAddress();
    }

    public static void testInit() {
        SeqnoTable tab = new SeqnoTable(0L);
        tab.add(MBR, 0L);
        Assert.assertEquals((long)0L, (long)tab.getHighestReceived(MBR));
        Assert.assertEquals((long)1L, (long)tab.getNextToReceive(MBR));
        tab.clear();
        tab = new SeqnoTable(50L);
        tab.add(MBR, 50L);
        Assert.assertEquals((long)50L, (long)tab.getHighestReceived(MBR));
        Assert.assertEquals((long)51L, (long)tab.getNextToReceive(MBR));
    }

    public static void testAdd() {
        SeqnoTable tab = new SeqnoTable(0L);
        tab.add(MBR, 0L);
        tab.add(MBR, 1L);
        tab.add(MBR, 2L);
        Assert.assertEquals((long)2L, (long)tab.getHighestReceived(MBR));
        Assert.assertEquals((long)3L, (long)tab.getNextToReceive(MBR));
    }

    public static void testAddWithGaps() {
        SeqnoTable tab = new SeqnoTable(0L);
        boolean rc = tab.add(MBR, 0L);
        assert (rc);
        rc = tab.add(MBR, 1L);
        assert (rc);
        rc = tab.add(MBR, 2L);
        assert (rc);
        rc = tab.add(MBR, 4L);
        assert (rc);
        rc = tab.add(MBR, 5L);
        assert (rc);
        System.out.println("tab: " + tab);
        Assert.assertEquals((long)5L, (long)tab.getHighestReceived(MBR));
        Assert.assertEquals((long)3L, (long)tab.getNextToReceive(MBR));
        rc = tab.add(MBR, 3L);
        assert (rc);
        System.out.println("tab: " + tab);
        Assert.assertEquals((long)5L, (long)tab.getHighestReceived(MBR));
        Assert.assertEquals((long)6L, (long)tab.getNextToReceive(MBR));
    }

    public static void testAddWithGaps2() {
        SeqnoTable tab = new SeqnoTable(0L);
        boolean rc = tab.add(MBR, 5L);
        System.out.println("tab: " + tab);
        assert (rc);
        Assert.assertEquals((long)5L, (long)tab.getHighestReceived(MBR));
        Assert.assertEquals((long)0L, (long)tab.getNextToReceive(MBR));
        rc = tab.add(MBR, 4L);
        System.out.println("tab: " + tab);
        assert (rc);
        Assert.assertEquals((long)5L, (long)tab.getHighestReceived(MBR));
        Assert.assertEquals((long)0L, (long)tab.getNextToReceive(MBR));
        rc = tab.add(MBR, 3L);
        System.out.println("tab: " + tab);
        assert (rc);
        Assert.assertEquals((long)5L, (long)tab.getHighestReceived(MBR));
        Assert.assertEquals((long)0L, (long)tab.getNextToReceive(MBR));
        rc = tab.add(MBR, 2L);
        System.out.println("tab: " + tab);
        assert (rc);
        Assert.assertEquals((long)5L, (long)tab.getHighestReceived(MBR));
        Assert.assertEquals((long)0L, (long)tab.getNextToReceive(MBR));
        rc = tab.add(MBR, 1L);
        System.out.println("tab: " + tab);
        assert (rc);
        Assert.assertEquals((long)5L, (long)tab.getHighestReceived(MBR));
        Assert.assertEquals((long)0L, (long)tab.getNextToReceive(MBR));
        rc = tab.add(MBR, 0L);
        System.out.println("tab: " + tab);
        assert (rc);
        Assert.assertEquals((long)5L, (long)tab.getHighestReceived(MBR));
        Assert.assertEquals((long)6L, (long)tab.getNextToReceive(MBR));
    }

    public static void testInsertionOfDuplicates() {
        SeqnoTable tab = new SeqnoTable(0L);
        boolean rc = tab.add(MBR, 0L);
        assert (rc);
        rc = tab.add(MBR, 0L);
        assert (!rc);
        rc = tab.add(MBR, 1L);
        assert (rc);
        rc = tab.add(MBR, 2L);
        assert (rc);
        rc = tab.add(MBR, 4L);
        assert (rc);
        rc = tab.add(MBR, 5L);
        assert (rc);
        System.out.println("tab: " + tab);
        rc = tab.add(MBR, 2L);
        assert (!rc);
        rc = tab.add(MBR, 3L);
        assert (rc);
        rc = tab.add(MBR, 3L);
        assert (!rc);
    }
}

