/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import org.jgroups.Address;
import org.jgroups.Membership;
import org.jgroups.util.UUID;
import org.jgroups.util.Util;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, sequential=true)
public class MembershipTest {
    Membership m1;
    Membership m2;
    List<Address> v1;
    List<Address> v2;
    Address a1;
    Address a2;
    Address a3;
    Address a4;
    Address a5;

    @BeforeMethod
    public void setUp() {
        this.a1 = Util.createRandomAddress();
        this.a3 = this.a2 = Util.createRandomAddress();
        this.a4 = Util.createRandomAddress();
        this.a5 = Util.createRandomAddress();
        this.m1 = new Membership();
    }

    public void testConstructor() {
        this.v1 = Arrays.asList(this.a1, this.a2, this.a3);
        this.m2 = new Membership(this.v1);
        assert (this.m2.size() == 2);
        assert (this.m2.contains(this.a1));
        assert (this.m2.contains(this.a2));
        assert (this.m2.contains(this.a3));
    }

    public void testClone() {
        this.v1 = Arrays.asList(this.a1, this.a2, this.a3);
        this.m2 = new Membership(this.v1);
        this.m1 = (Membership)this.m2.clone();
        assert (this.m1.size() == this.m2.size());
        assert (this.m1.contains(this.a1));
        assert (this.m1.contains(this.a2));
        assert (this.m2.contains(this.a1));
        assert (this.m2.contains(this.a2));
    }

    public void testCopy() {
        this.v1 = Arrays.asList(this.a1, this.a2, this.a3);
        this.m2 = new Membership(this.v1);
        this.m1 = this.m2.copy();
        assert (this.m1.size() == this.m2.size());
        assert (this.m1.contains(this.a1));
        assert (this.m1.contains(this.a2));
        assert (this.m2.contains(this.a1));
        assert (this.m2.contains(this.a2));
    }

    public void testAdd() {
        this.m1.add(this.a1, this.a2, this.a3);
        assert (this.m1.size() == 2);
        assert (this.m1.contains(this.a1));
        assert (this.m1.contains(this.a2));
        assert (this.m1.contains(this.a3));
    }

    public void testAddVector() {
        this.v1 = Arrays.asList(this.a1, this.a2, this.a3);
        this.m1.add(this.v1);
        assert (this.m1.size() == 2);
        assert (this.m1.contains(this.a1));
        assert (this.m1.contains(this.a2));
    }

    public void testAddVectorDupl() {
        this.v1 = Arrays.asList(this.a1, this.a2, this.a3, this.a4, this.a5);
        this.m1.add(this.a5, this.a1);
        this.m1.add(this.v1);
        assert (this.m1.size() == 4);
        assert (this.m1.contains(this.a1));
        assert (this.m1.contains(this.a2));
        assert (this.m1.contains(this.a4));
        assert (this.m1.contains(this.a5));
    }

    public void testRemove() {
        this.m1.add(this.a1, this.a2, this.a3, this.a4, this.a5);
        this.m1.remove(this.a2);
        assert (this.m1.size() == 3);
    }

    public void testGetMembers() {
        this.testAdd();
        Vector<Address> v = this.m1.getMembers();
        assert (v.size() == 2);
    }

    public void testSet() {
        this.v1 = Arrays.asList(this.a1, this.a2);
        this.m1.add(this.a1, this.a2, this.a4, this.a5);
        this.m1.set(this.v1);
        assert (this.m1.size() == 2);
        assert (this.m1.contains(this.a1));
        assert (this.m1.contains(this.a2));
    }

    public void testSet2() {
        this.m1 = new Membership();
        this.m2 = new Membership();
        this.m1.add(this.a1, this.a2, this.a4);
        this.m2.add(this.a5);
        this.m2.set(this.m1);
        assert (this.m2.size() == 3);
        assert (this.m2.contains(this.a1));
        assert (this.m2.contains(this.a2));
        assert (this.m2.contains(this.a4));
        assert (!this.m2.contains(this.a5));
    }

    public void testMerge() {
        this.v1 = Arrays.asList(this.a5);
        this.v2 = Arrays.asList(this.a2, this.a3);
        this.m1.add(this.a1, this.a2, this.a3, this.a4);
        this.m1.merge(this.v1, this.v2);
        assert (this.m1.size() == 3);
        assert (this.m1.contains(this.a1));
        assert (this.m1.contains(this.a4));
        assert (this.m1.contains(this.a5));
    }

    public void testSort() {
        this.m1.add(this.a3, this.a4, this.a2, this.a1, this.a5, this.a2);
        System.out.println("membership:\n" + MembershipTest.printUUIDs(this.m1));
        Assert.assertEquals((int)4, (int)this.m1.size());
        Assert.assertEquals((Object)this.a3, (Object)this.m1.elementAt(0));
        Assert.assertEquals((Object)this.a4, (Object)this.m1.elementAt(1));
        Assert.assertEquals((Object)this.a1, (Object)this.m1.elementAt(2));
        Assert.assertEquals((Object)this.a5, (Object)this.m1.elementAt(3));
        this.m1.sort();
        System.out.println("sorted: " + this.m1);
        Assert.assertEquals((int)4, (int)this.m1.size());
        Address addr0 = this.m1.elementAt(0);
        Address addr1 = this.m1.elementAt(1);
        Address addr2 = this.m1.elementAt(2);
        Address addr3 = this.m1.elementAt(3);
        System.out.println("sorted membership:\n" + MembershipTest.printUUIDs(this.m1));
        assert (addr0.compareTo(addr1) < 0);
        assert (addr1.compareTo(addr2) < 0);
        assert (addr2.compareTo(addr3) < 0);
    }

    private static String printUUIDs(Membership mbrs) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (int i = 0; i < mbrs.size(); ++i) {
            UUID mbr = (UUID)mbrs.elementAt(i);
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            sb.append(mbr.toStringLong());
        }
        return sb.toString();
    }
}

