/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.util.concurrent.TimeUnit;
import org.jgroups.Channel;
import org.jgroups.ChannelClosedException;
import org.jgroups.ChannelListenerAdapter;
import org.jgroups.ChannelNotConnectedException;
import org.jgroups.GetStateEvent;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.SetStateEvent;
import org.jgroups.tests.ChannelTestBase;
import org.jgroups.util.Util;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"stack-dependent", "known-failures"})
public class STATE_TRANSFER_Test
extends ChannelTestBase {
    public static final String GROUP_NAME = "STATE_TRANSFER_Test";
    private Coordinator coord;

    @BeforeMethod
    protected void setUp() throws Exception {
        this.coord = new Coordinator();
        this.coord.recvLoop();
        this.coord.sendLoop();
    }

    @AfterMethod
    protected void tearDown() throws Exception {
        this.coord.stop();
        this.coord = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBasicStateSync() throws Exception {
        int counter;
        Channel channel = null;
        int timeout = 60;
        try {
            channel = this.createChannel(this.coord.getChannel());
            channel.setOpt(3, Boolean.FALSE);
            channel.connect(GROUP_NAME);
            Thread.sleep(1000L);
            boolean join = false;
            join = channel.getState(null, 100000L);
            STATE_TRANSFER_Test.assertTrue(join);
            int cnt = -1;
            for (counter = 0; counter < timeout; ++counter) {
                try {
                    Object tmp = channel.receive(0L);
                    if (tmp instanceof SetStateEvent) {
                        cnt = (Integer)Util.objectFromByteBuffer(((SetStateEvent)tmp).getArg());
                    } else if (tmp instanceof Message && cnt != -1) {
                        int msg = (Integer)((Message)tmp).getObject();
                        STATE_TRANSFER_Test.assertEquals(cnt, msg - 1);
                        break;
                    }
                }
                catch (ChannelNotConnectedException not) {
                    break;
                }
                catch (ChannelClosedException closed) {
                    break;
                }
                catch (Exception e) {
                    System.err.println(e);
                }
                TimeUnit.SECONDS.sleep(1L);
            }
            channel.close();
            STATE_TRANSFER_Test.assertTrue("Timeout reached", counter < timeout);
        }
        catch (Throwable throwable) {
            channel.close();
            STATE_TRANSFER_Test.assertTrue("Timeout reached", counter < timeout);
            throw throwable;
        }
    }

    class Coordinator
    extends ChannelListenerAdapter {
        private JChannel channel = null;
        private int cnt = 0;
        private volatile boolean closed = false;

        String getProps() {
            return this.channel.getProperties();
        }

        public JChannel getChannel() {
            return this.channel;
        }

        protected Coordinator() throws Exception {
            this.channel = STATE_TRANSFER_Test.this.createChannel(true);
            this.channel.setOpt(3, Boolean.FALSE);
            this.channel.addChannelListener(this);
            this.channel.connect(STATE_TRANSFER_Test.GROUP_NAME);
        }

        public void recvLoop() throws Exception {
            Thread task = new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    while (!Coordinator.this.closed) {
                        try {
                            Object tmp = Coordinator.this.channel.receive(0L);
                            if (!(tmp instanceof GetStateEvent)) continue;
                            Coordinator coordinator = Coordinator.this;
                            synchronized (coordinator) {
                                Coordinator.this.channel.returnState(Util.objectToByteBuffer(new Integer(Coordinator.this.cnt)));
                            }
                        }
                        catch (ChannelNotConnectedException not) {
                            break;
                        }
                        catch (ChannelClosedException closed) {
                            break;
                        }
                        catch (Exception e) {
                            System.err.println(e);
                        }
                    }
                }
            });
            task.start();
        }

        public void sendLoop() throws Exception {
            Thread task = new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    while (!Coordinator.this.closed) {
                        try {
                            Coordinator coordinator = Coordinator.this;
                            synchronized (coordinator) {
                                Coordinator.this.channel.send(null, null, new Integer(++Coordinator.this.cnt));
                            }
                            Thread.sleep(1000L);
                        }
                        catch (ChannelNotConnectedException not) {
                            break;
                        }
                        catch (ChannelClosedException closed) {
                            break;
                        }
                        catch (Exception e) {
                            System.err.println(e);
                        }
                    }
                }
            });
            task.start();
        }

        public void stop() {
            this.closed = true;
            this.channel.close();
        }
    }
}

