/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Map;
import org.jgroups.Event;
import org.jgroups.annotations.Experimental;
import org.jgroups.annotations.Property;
import org.jgroups.conf.PropertyConverters;
import org.jgroups.protocols.FD;
import org.jgroups.stack.IpAddress;
import org.jgroups.util.Util;

@Experimental
public class FD_ICMP
extends FD {
    private NetworkInterface intf = null;
    @Property(name="bind_addr", description="The NIC on which the ServerSocket should listen on. The following special values are also recognized: GLOBAL, SITE_LOCAL, LINK_LOCAL and NON_LOOPBACK", systemProperty={"jgroups.bind_addr", "bind.address"}, defaultValueIPv4="NON_LOOPBACK_ADDRESS", defaultValueIPv6="NON_LOOPBACK_ADDRESS")
    private InetAddress bind_addr = null;
    @Property(name="bind_interface", converter=PropertyConverters.BindInterface.class, description="The interface (NIC) which should be used by this transport", dependsUpon="bind_addr")
    protected String bind_interface_str = null;
    private Method is_reacheable;
    @Property
    private int ttl = 32;

    @Override
    public void init() throws Exception {
        super.init();
        if (this.bind_addr != null) {
            this.intf = NetworkInterface.getByInetAddress(this.bind_addr);
        }
        try {
            Class is_reacheable_class = Util.loadClass("java.net.InetAddress", this.getClass());
            this.is_reacheable = is_reacheable_class.getMethod("isReachable", NetworkInterface.class, Integer.TYPE, Integer.TYPE);
        }
        catch (ClassNotFoundException e) {
            NoClassDefFoundError error = new NoClassDefFoundError("failed checking for InetAddress.isReachable() method - requires JDK 5 or higher");
            error.initCause(e);
            throw error;
        }
        catch (NoSuchMethodException e) {
            NoSuchMethodError error = new NoSuchMethodError("didn't find InetAddress.isReachable() method - requires JDK 5 or higher");
            error.initCause(e);
            throw error;
        }
    }

    @Override
    public Object up(Event evt) {
        switch (evt.getType()) {
            case 56: {
                if (this.bind_addr != null) break;
                Map config = (Map)evt.getArg();
                this.bind_addr = (InetAddress)config.get("bind_addr");
            }
        }
        return super.up(evt);
    }

    @Override
    protected FD.Monitor createMonitor() {
        return new PingMonitor();
    }

    protected class PingMonitor
    extends FD.Monitor {
        long start;
        long stop;

        protected PingMonitor() {
        }

        @Override
        public void run() {
            block13: {
                InetAddress host;
                if (FD_ICMP.this.ping_dest == null) {
                    if (FD_ICMP.this.log.isWarnEnabled()) {
                        FD_ICMP.this.log.warn("ping_dest is null: members=" + FD_ICMP.this.members + ", pingable_mbrs=" + FD_ICMP.this.pingable_mbrs + ", local_addr=" + FD_ICMP.this.local_addr);
                    }
                    return;
                }
                InetAddress inetAddress = host = FD_ICMP.this.ping_dest instanceof IpAddress ? ((IpAddress)FD_ICMP.this.ping_dest).getIpAddress() : null;
                if (host == null) {
                    throw new IllegalArgumentException("ping_dest is not of type IpAddress - FD_ICMP only works with these");
                }
                try {
                    if (FD_ICMP.this.log.isTraceEnabled()) {
                        FD_ICMP.this.log.trace("pinging " + host + " (ping_dest=" + FD_ICMP.this.ping_dest + ") using interface " + FD_ICMP.this.intf);
                    }
                    this.start = System.currentTimeMillis();
                    Boolean rc = (Boolean)FD_ICMP.this.is_reacheable.invoke((Object)host, FD_ICMP.this.intf, new Integer(FD_ICMP.this.ttl), new Integer((int)FD_ICMP.this.timeout));
                    this.stop = System.currentTimeMillis();
                    ++FD_ICMP.this.num_heartbeats;
                    if (rc.booleanValue()) {
                        FD_ICMP.this.num_tries = 0;
                        if (FD_ICMP.this.log.isTraceEnabled()) {
                            FD_ICMP.this.log.trace("successfully received response from " + host + " (after " + (this.stop - this.start) + "ms)");
                        }
                    } else {
                        ++FD_ICMP.this.num_tries;
                        if (FD_ICMP.this.log.isDebugEnabled()) {
                            FD_ICMP.this.log.debug("could not ping " + FD_ICMP.this.ping_dest + " (tries=" + FD_ICMP.this.num_tries + ") after " + (this.stop - this.start) + "ms)");
                        }
                    }
                    if (FD_ICMP.this.num_tries >= FD_ICMP.this.max_tries) {
                        if (FD_ICMP.this.log.isDebugEnabled()) {
                            FD_ICMP.this.log.debug("[" + FD_ICMP.this.local_addr + "]: could not ping " + FD_ICMP.this.ping_dest + " for " + (FD_ICMP.this.num_tries + 1) + " times (" + (long)(FD_ICMP.this.num_tries + 1) * FD_ICMP.this.timeout + " milliseconds), suspecting it");
                        }
                        FD_ICMP.this.bcast_task.addSuspectedMember(FD_ICMP.this.ping_dest);
                        FD_ICMP.this.num_tries = 0;
                        if (FD_ICMP.this.stats) {
                            ++FD_ICMP.this.num_suspect_events;
                            FD_ICMP.this.suspect_history.add(FD_ICMP.this.ping_dest);
                        }
                    }
                }
                catch (Exception ex) {
                    if (!FD_ICMP.this.log.isErrorEnabled()) break block13;
                    FD_ICMP.this.log.error("failed pinging " + FD_ICMP.this.ping_dest, ex);
                }
            }
        }
    }
}

