/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.blocks;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.TreeSet;
import java.util.Vector;
import org.jgroups.Address;
import org.jgroups.Channel;
import org.jgroups.ChannelClosedException;
import org.jgroups.ChannelNotConnectedException;
import org.jgroups.Event;
import org.jgroups.ExtendedMembershipListener;
import org.jgroups.ExtendedMessageListener;
import org.jgroups.JChannel;
import org.jgroups.MembershipListener;
import org.jgroups.Message;
import org.jgroups.MessageListener;
import org.jgroups.SuspectedException;
import org.jgroups.TimeoutException;
import org.jgroups.Transport;
import org.jgroups.UpHandler;
import org.jgroups.View;
import org.jgroups.blocks.GroupRequest;
import org.jgroups.blocks.PullPushAdapter;
import org.jgroups.blocks.RequestCorrelator;
import org.jgroups.blocks.RequestHandler;
import org.jgroups.blocks.RequestOptions;
import org.jgroups.blocks.RspFilter;
import org.jgroups.blocks.UnicastRequest;
import org.jgroups.blocks.mux.Muxer;
import org.jgroups.logging.Log;
import org.jgroups.logging.LogFactory;
import org.jgroups.protocols.TP;
import org.jgroups.stack.Protocol;
import org.jgroups.stack.StateTransferInfo;
import org.jgroups.util.NotifyingFuture;
import org.jgroups.util.NullFuture;
import org.jgroups.util.Rsp;
import org.jgroups.util.RspList;
import org.jgroups.util.Util;

public class MessageDispatcher
implements RequestHandler {
    protected Channel channel = null;
    protected RequestCorrelator corr = null;
    protected MessageListener msg_listener = null;
    protected MembershipListener membership_listener = null;
    protected RequestHandler req_handler = null;
    protected ProtocolAdapter prot_adapter = null;
    protected TransportAdapter transport_adapter = null;
    protected final Collection<Address> members = new TreeSet<Address>();
    protected Address local_addr = null;
    protected PullPushAdapter adapter = null;
    protected PullPushHandler handler = null;
    protected Serializable id = null;
    protected final Log log = LogFactory.getLog(this.getClass());
    protected boolean hardware_multicast_supported = false;

    public MessageDispatcher() {
    }

    public MessageDispatcher(Channel channel, MessageListener l, MembershipListener l2) {
        this.channel = channel;
        this.prot_adapter = new ProtocolAdapter();
        if (channel != null) {
            this.local_addr = channel.getAddress();
        }
        this.setMessageListener(l);
        this.setMembershipListener(l2);
        if (channel != null) {
            this.installUpHandler(this.prot_adapter, true);
        }
        this.start();
    }

    @Deprecated
    public MessageDispatcher(Channel channel, MessageListener l, MembershipListener l2, boolean deadlock_detection) {
        this.channel = channel;
        this.prot_adapter = new ProtocolAdapter();
        if (channel != null) {
            this.local_addr = channel.getAddress();
        }
        this.setMessageListener(l);
        this.setMembershipListener(l2);
        if (channel != null) {
            this.installUpHandler(this.prot_adapter, true);
        }
        this.start();
    }

    @Deprecated
    public MessageDispatcher(Channel channel, MessageListener l, MembershipListener l2, boolean deadlock_detection, boolean concurrent_processing) {
        this.channel = channel;
        this.prot_adapter = new ProtocolAdapter();
        if (channel != null) {
            this.local_addr = channel.getAddress();
        }
        this.setMessageListener(l);
        this.setMembershipListener(l2);
        if (channel != null) {
            this.installUpHandler(this.prot_adapter, true);
        }
        this.start();
    }

    public MessageDispatcher(Channel channel, MessageListener l, MembershipListener l2, RequestHandler req_handler) {
        this(channel, l, l2);
        this.setRequestHandler(req_handler);
    }

    @Deprecated
    public MessageDispatcher(Channel channel, MessageListener l, MembershipListener l2, RequestHandler req_handler, boolean deadlock_detection) {
        this(channel, l, l2, deadlock_detection, false);
        this.setRequestHandler(req_handler);
    }

    @Deprecated
    public MessageDispatcher(Channel channel, MessageListener l, MembershipListener l2, RequestHandler req_handler, boolean deadlock_detection, boolean concurrent_processing) {
        this(channel, l, l2, deadlock_detection, concurrent_processing);
        this.setRequestHandler(req_handler);
    }

    @Deprecated
    public MessageDispatcher(PullPushAdapter adapter, Serializable id, MessageListener l, MembershipListener l2) {
        this.adapter = adapter;
        this.id = id;
        this.setMembers(((Channel)adapter.getTransport()).getView().getMembers());
        this.setMessageListener(l);
        this.setMembershipListener(l2);
        this.handler = new PullPushHandler();
        this.transport_adapter = new TransportAdapter();
        adapter.addMembershipListener(this.handler);
        if (id == null) {
            adapter.setListener(this.handler);
        } else {
            adapter.registerListener(id, this.handler);
        }
        Transport tp = adapter.getTransport();
        if (tp instanceof Channel) {
            this.local_addr = ((Channel)tp).getAddress();
        }
        this.start();
    }

    @Deprecated
    public MessageDispatcher(PullPushAdapter adapter, Serializable id, MessageListener l, MembershipListener l2, RequestHandler req_handler) {
        this.adapter = adapter;
        this.id = id;
        this.setMembers(((Channel)adapter.getTransport()).getView().getMembers());
        this.setRequestHandler(req_handler);
        this.setMessageListener(l);
        this.setMembershipListener(l2);
        this.handler = new PullPushHandler();
        this.transport_adapter = new TransportAdapter();
        adapter.addMembershipListener(this.handler);
        if (id == null) {
            adapter.setListener(this.handler);
        } else {
            adapter.registerListener(id, this.handler);
        }
        Transport tp = adapter.getTransport();
        if (tp instanceof Channel) {
            this.local_addr = ((Channel)tp).getAddress();
        }
        this.start();
    }

    @Deprecated
    public MessageDispatcher(PullPushAdapter adapter, Serializable id, MessageListener l, MembershipListener l2, RequestHandler req_handler, boolean concurrent_processing) {
        this.adapter = adapter;
        this.id = id;
        this.setMembers(((Channel)adapter.getTransport()).getView().getMembers());
        this.setRequestHandler(req_handler);
        this.setMessageListener(l);
        this.setMembershipListener(l2);
        this.handler = new PullPushHandler();
        this.transport_adapter = new TransportAdapter();
        adapter.addMembershipListener(this.handler);
        if (id == null) {
            adapter.setListener(this.handler);
        } else {
            adapter.registerListener(id, this.handler);
        }
        Transport tp = adapter.getTransport();
        if (tp instanceof Channel) {
            this.local_addr = ((Channel)tp).getAddress();
        }
        this.start();
    }

    public UpHandler getProtocolAdapter() {
        return this.prot_adapter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Collection getMembers() {
        Collection<Address> collection = this.members;
        synchronized (collection) {
            return new ArrayList<Address>(this.members);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setMembers(Vector new_mbrs) {
        if (new_mbrs != null) {
            Collection<Address> collection = this.members;
            synchronized (collection) {
                this.members.clear();
                this.members.addAll(new_mbrs);
            }
        }
    }

    @Deprecated
    public boolean getDeadlockDetection() {
        return false;
    }

    @Deprecated
    public void setDeadlockDetection(boolean flag) {
    }

    @Deprecated
    public boolean getConcurrentProcessing() {
        return false;
    }

    @Deprecated
    public void setConcurrentProcessing(boolean flag) {
    }

    public void start() {
        if (this.corr == null) {
            this.corr = this.transport_adapter != null ? this.createRequestCorrelator(this.transport_adapter, this, this.local_addr) : this.createRequestCorrelator(this.prot_adapter, this, this.local_addr);
        }
        this.correlatorStarted();
        this.corr.start();
        if (this.channel != null) {
            TP transport;
            Vector<Address> tmp_mbrs = this.channel.getView() != null ? this.channel.getView().getMembers() : null;
            this.setMembers(tmp_mbrs);
            if (this.channel instanceof JChannel) {
                transport = this.channel.getProtocolStack().getTransport();
                this.corr.registerProbeHandler(transport);
            }
            transport = this.channel.getProtocolStack().getTransport();
            this.hardware_multicast_supported = transport.supportsMulticasting();
        }
    }

    protected RequestCorrelator createRequestCorrelator(Object transport, RequestHandler handler, Address local_addr) {
        return new RequestCorrelator(transport, handler, local_addr);
    }

    protected void correlatorStarted() {
    }

    public void stop() {
        if (this.corr != null) {
            this.corr.stop();
        }
        if (this.channel instanceof JChannel) {
            TP transport = this.channel.getProtocolStack().getTransport();
            this.corr.unregisterProbeHandler(transport);
        }
        if (this.adapter != null && this.handler != null) {
            this.adapter.removeMembershipListener(this.handler);
        }
    }

    public final void setMessageListener(MessageListener l) {
        this.msg_listener = l;
    }

    public MessageListener getMessageListener() {
        return this.msg_listener;
    }

    public final void setMembershipListener(MembershipListener l) {
        this.membership_listener = l;
    }

    public final void setRequestHandler(RequestHandler rh) {
        this.req_handler = rh;
    }

    public Channel getChannel() {
        return this.channel;
    }

    public void setChannel(Channel ch) {
        if (ch == null) {
            return;
        }
        this.channel = ch;
        this.local_addr = this.channel.getAddress();
        if (this.prot_adapter == null) {
            this.prot_adapter = new ProtocolAdapter();
        }
        this.installUpHandler(this.prot_adapter, false);
    }

    protected void installUpHandler(UpHandler handler, boolean canReplace) {
        UpHandler existing = this.channel.getUpHandler();
        if (existing == null) {
            this.channel.setUpHandler(handler);
        } else if (existing instanceof Muxer) {
            Muxer mux = (Muxer)((Object)existing);
            if (mux.getDefaultHandler() == null) {
                mux.setDefaultHandler(handler);
            } else if (canReplace) {
                this.log.warn("Channel Muxer already has a default up handler installed (" + mux.getDefaultHandler() + ") but now it is being overridden");
                mux.setDefaultHandler(handler);
            }
        } else if (canReplace) {
            this.log.warn("Channel already has an up handler installed (" + existing + ") but now it is being overridden");
            this.channel.setUpHandler(handler);
        }
    }

    @Deprecated
    public void send(Message msg) throws ChannelNotConnectedException, ChannelClosedException {
        block6: {
            if (this.channel != null) {
                this.channel.send(msg);
                return;
            }
            if (this.adapter != null) {
                try {
                    if (this.id != null) {
                        this.adapter.send(this.id, msg);
                        break block6;
                    }
                    this.adapter.send(msg);
                }
                catch (Throwable ex) {
                    this.log.error("exception=" + Util.print(ex));
                }
            } else {
                this.log.error("channel == null");
            }
        }
    }

    @Deprecated
    public RspList castMessage(Vector dests, Message msg, int mode, long timeout) {
        return this.castMessage(dests, msg, new RequestOptions(mode, timeout, false, null));
    }

    @Deprecated
    public RspList castMessage(Vector dests, Message msg, int mode, long timeout, boolean use_anycasting) {
        return this.castMessage(dests, msg, new RequestOptions(mode, timeout, use_anycasting, null));
    }

    @Deprecated
    public RspList castMessage(Vector dests, Message msg, int mode, long timeout, boolean use_anycasting, RspFilter filter) {
        RequestOptions opts = new RequestOptions(mode, timeout, use_anycasting, filter);
        return this.castMessage(dests, msg, opts);
    }

    public RspList castMessage(Collection<Address> dests, Message msg, RequestOptions options) {
        GroupRequest req = this.cast(dests, msg, options, true);
        return req != null ? req.getResults() : RspList.EMPTY_RSP_LIST;
    }

    @Deprecated
    public NotifyingFuture<RspList> castMessageWithFuture(Vector dests, Message msg, int mode, long timeout, boolean use_anycasting, RspFilter filter) {
        return this.castMessageWithFuture(dests, msg, new RequestOptions(mode, timeout, use_anycasting, filter));
    }

    public NotifyingFuture<RspList> castMessageWithFuture(Collection<Address> dests, Message msg, RequestOptions options) {
        GroupRequest req = this.cast(dests, msg, options, false);
        return req != null ? req : new NullFuture<RspList>(RspList.EMPTY_RSP_LIST);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected GroupRequest cast(Collection<Address> dests, Message msg, RequestOptions options, boolean block_for_results) {
        ArrayList<Address> real_dests;
        if (dests != null) {
            real_dests = new ArrayList<Address>(dests);
            real_dests.retainAll(this.members);
        } else {
            Collection<Address> collection = this.members;
            synchronized (collection) {
                real_dests = new ArrayList<Address>(this.members);
            }
        }
        Channel tmp = this.channel;
        if (tmp == null && this.adapter != null && this.adapter.getTransport() instanceof Channel) {
            tmp = (Channel)this.adapter.getTransport();
        }
        if (tmp != null && tmp.getOpt(3).equals(Boolean.FALSE)) {
            if (this.local_addr == null) {
                this.local_addr = tmp.getAddress();
            }
            if (this.local_addr != null) {
                real_dests.remove(this.local_addr);
            }
        }
        if (options != null && options.hasExclusionList()) {
            Collection<Address> exclusion_list = options.getExclusionList();
            real_dests.removeAll(exclusion_list);
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("real_dests=" + real_dests);
        }
        if (real_dests.isEmpty()) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("destination list is empty, won't send message");
            }
            return null;
        }
        GroupRequest req = new GroupRequest(msg, this.corr, real_dests, options);
        if (options != null) {
            req.setResponseFilter(options.getRspFilter());
            req.setAnycasting(options.getAnycasting());
        }
        req.setBlockForResults(block_for_results);
        try {
            req.execute();
            return req;
        }
        catch (Exception ex) {
            throw new RuntimeException("failed executing request " + req, ex);
        }
    }

    public void done(long req_id) {
        this.corr.done(req_id);
    }

    @Deprecated
    public Object sendMessage(Message msg, int mode, long timeout) throws TimeoutException, SuspectedException {
        return this.sendMessage(msg, new RequestOptions(mode, timeout, false, null));
    }

    public Object sendMessage(Message msg, RequestOptions opts) throws TimeoutException, SuspectedException {
        Address dest = msg.getDest();
        if (dest == null) {
            if (this.log.isErrorEnabled()) {
                this.log.error("the message's destination is null, cannot send message");
            }
            return null;
        }
        UnicastRequest req = new UnicastRequest(msg, this.corr, dest, opts);
        try {
            req.execute();
        }
        catch (Exception t) {
            throw new RuntimeException("failed executing request " + req, t);
        }
        if (opts.getMode() == 6) {
            return null;
        }
        Rsp rsp = req.getResult();
        if (rsp.wasSuspected()) {
            throw new SuspectedException(dest);
        }
        if (!rsp.wasReceived()) {
            throw new TimeoutException("timeout sending message to " + dest);
        }
        return rsp.getValue();
    }

    @Deprecated
    public <T> NotifyingFuture<T> sendMessageWithFuture(Message msg, int mode, long timeout) throws TimeoutException, SuspectedException {
        return this.sendMessageWithFuture(msg, new RequestOptions(mode, timeout, false, null));
    }

    public <T> NotifyingFuture<T> sendMessageWithFuture(Message msg, RequestOptions options) throws TimeoutException, SuspectedException {
        Address dest = msg.getDest();
        if (dest == null) {
            if (this.log.isErrorEnabled()) {
                this.log.error("the message's destination is null, cannot send message");
            }
            return null;
        }
        UnicastRequest req = new UnicastRequest(msg, this.corr, dest, options);
        req.setBlockForResults(false);
        try {
            req.execute();
            if (options.getMode() == 6) {
                return new NullFuture<Object>(null);
            }
            return req;
        }
        catch (Exception t) {
            throw new RuntimeException("failed executing request " + req, t);
        }
    }

    @Override
    public Object handle(Message msg) {
        if (this.req_handler != null) {
            return this.req_handler.handle(msg);
        }
        return null;
    }

    @Deprecated
    class PullPushHandler
    implements ExtendedMessageListener,
    MembershipListener {
        PullPushHandler() {
        }

        @Override
        public void receive(Message msg) {
            boolean consumed = false;
            if (MessageDispatcher.this.corr != null) {
                consumed = MessageDispatcher.this.corr.receiveMessage(msg);
            }
            if (!consumed && MessageDispatcher.this.msg_listener != null) {
                MessageDispatcher.this.msg_listener.receive(msg);
            }
        }

        @Override
        public byte[] getState() {
            return MessageDispatcher.this.msg_listener != null ? MessageDispatcher.this.msg_listener.getState() : null;
        }

        @Override
        public byte[] getState(String state_id) {
            if (MessageDispatcher.this.msg_listener == null) {
                return null;
            }
            if (MessageDispatcher.this.msg_listener instanceof ExtendedMessageListener && state_id != null) {
                return ((ExtendedMessageListener)MessageDispatcher.this.msg_listener).getState(state_id);
            }
            return MessageDispatcher.this.msg_listener.getState();
        }

        @Override
        public void setState(byte[] state) {
            if (MessageDispatcher.this.msg_listener != null) {
                MessageDispatcher.this.msg_listener.setState(state);
            }
        }

        @Override
        public void setState(String state_id, byte[] state) {
            if (MessageDispatcher.this.msg_listener != null) {
                if (MessageDispatcher.this.msg_listener instanceof ExtendedMessageListener && state_id != null) {
                    ((ExtendedMessageListener)MessageDispatcher.this.msg_listener).setState(state_id, state);
                } else {
                    MessageDispatcher.this.msg_listener.setState(state);
                }
            }
        }

        @Override
        public void getState(OutputStream ostream) {
            if (MessageDispatcher.this.msg_listener instanceof ExtendedMessageListener) {
                ((ExtendedMessageListener)MessageDispatcher.this.msg_listener).getState(ostream);
            }
        }

        @Override
        public void getState(String state_id, OutputStream ostream) {
            if (MessageDispatcher.this.msg_listener instanceof ExtendedMessageListener && state_id != null) {
                ((ExtendedMessageListener)MessageDispatcher.this.msg_listener).getState(state_id, ostream);
            }
        }

        @Override
        public void setState(InputStream istream) {
            if (MessageDispatcher.this.msg_listener instanceof ExtendedMessageListener) {
                ((ExtendedMessageListener)MessageDispatcher.this.msg_listener).setState(istream);
            }
        }

        @Override
        public void setState(String state_id, InputStream istream) {
            if (MessageDispatcher.this.msg_listener instanceof ExtendedMessageListener && state_id != null) {
                ((ExtendedMessageListener)MessageDispatcher.this.msg_listener).setState(state_id, istream);
            }
        }

        @Override
        public void viewAccepted(View v) {
            if (MessageDispatcher.this.corr != null) {
                MessageDispatcher.this.corr.receiveView(v);
            }
            Vector<Address> new_mbrs = v.getMembers();
            MessageDispatcher.this.setMembers(new_mbrs);
            if (MessageDispatcher.this.membership_listener != null) {
                MessageDispatcher.this.membership_listener.viewAccepted(v);
            }
        }

        @Override
        public void suspect(Address suspected_mbr) {
            if (MessageDispatcher.this.corr != null) {
                MessageDispatcher.this.corr.receiveSuspect(suspected_mbr);
            }
            if (MessageDispatcher.this.membership_listener != null) {
                MessageDispatcher.this.membership_listener.suspect(suspected_mbr);
            }
        }

        @Override
        public void block() {
            if (MessageDispatcher.this.membership_listener != null) {
                MessageDispatcher.this.membership_listener.block();
            }
        }
    }

    @Deprecated
    class TransportAdapter
    implements Transport {
        TransportAdapter() {
        }

        @Override
        public void send(Message msg) throws Exception {
            block8: {
                if (MessageDispatcher.this.channel != null) {
                    MessageDispatcher.this.channel.send(msg);
                } else {
                    if (MessageDispatcher.this.adapter != null) {
                        try {
                            if (MessageDispatcher.this.id != null) {
                                MessageDispatcher.this.adapter.send(MessageDispatcher.this.id, msg);
                                break block8;
                            }
                            MessageDispatcher.this.adapter.send(msg);
                        }
                        catch (Throwable ex) {
                            if (MessageDispatcher.this.log.isErrorEnabled()) {
                                MessageDispatcher.this.log.error("exception=" + Util.print(ex));
                            }
                            break block8;
                        }
                    }
                    if (MessageDispatcher.this.log.isErrorEnabled()) {
                        MessageDispatcher.this.log.error("channel == null");
                    }
                }
            }
        }

        @Override
        public Object receive(long timeout) throws Exception {
            return null;
        }
    }

    class ProtocolAdapter
    extends Protocol
    implements UpHandler {
        ProtocolAdapter() {
        }

        @Override
        public String getName() {
            return "MessageDispatcher";
        }

        private Object handleUpEvent(Event evt) {
            switch (evt.getType()) {
                case 1: {
                    if (MessageDispatcher.this.msg_listener == null) break;
                    MessageDispatcher.this.msg_listener.receive((Message)evt.getArg());
                    break;
                }
                case 17: {
                    StateTransferInfo info = (StateTransferInfo)evt.getArg();
                    String state_id = info.state_id;
                    byte[] tmp_state = null;
                    if (MessageDispatcher.this.msg_listener != null) {
                        try {
                            tmp_state = MessageDispatcher.this.msg_listener instanceof ExtendedMessageListener && state_id != null ? ((ExtendedMessageListener)MessageDispatcher.this.msg_listener).getState(state_id) : MessageDispatcher.this.msg_listener.getState();
                        }
                        catch (Throwable t) {
                            this.log.error("failed getting state from message listener (" + MessageDispatcher.this.msg_listener + ')', t);
                        }
                    }
                    return new StateTransferInfo(null, state_id, 0L, tmp_state);
                }
                case 20: {
                    if (MessageDispatcher.this.msg_listener == null) break;
                    try {
                        StateTransferInfo info = (StateTransferInfo)evt.getArg();
                        String id = info.state_id;
                        if (MessageDispatcher.this.msg_listener instanceof ExtendedMessageListener && id != null) {
                            ((ExtendedMessageListener)MessageDispatcher.this.msg_listener).setState(id, info.state);
                            break;
                        }
                        MessageDispatcher.this.msg_listener.setState(info.state);
                    }
                    catch (ClassCastException cast_ex) {
                        if (!this.log.isErrorEnabled()) break;
                        this.log.error("received SetStateEvent, but argument " + evt.getArg() + " is not serializable. Discarding message.");
                    }
                    break;
                }
                case 72: {
                    StateTransferInfo sti = (StateTransferInfo)evt.getArg();
                    OutputStream os = sti.outputStream;
                    if (MessageDispatcher.this.msg_listener instanceof ExtendedMessageListener) {
                        if (os != null && MessageDispatcher.this.msg_listener instanceof ExtendedMessageListener) {
                            if (sti.state_id == null) {
                                ((ExtendedMessageListener)MessageDispatcher.this.msg_listener).getState(os);
                            } else {
                                ((ExtendedMessageListener)MessageDispatcher.this.msg_listener).getState(sti.state_id, os);
                            }
                        }
                        return new StateTransferInfo(null, os, sti.state_id);
                    }
                    if (!(MessageDispatcher.this.msg_listener instanceof MessageListener) || !this.log.isWarnEnabled()) break;
                    this.log.warn("Channel has STREAMING_STATE_TRANSFER, however, application does not implement ExtendedMessageListener. State is not transfered");
                    Util.close(os);
                    break;
                }
                case 71: {
                    StateTransferInfo sti = (StateTransferInfo)evt.getArg();
                    InputStream is = sti.inputStream;
                    if (MessageDispatcher.this.msg_listener instanceof ExtendedMessageListener) {
                        if (is == null || !(MessageDispatcher.this.msg_listener instanceof ExtendedMessageListener)) break;
                        if (sti.state_id == null) {
                            ((ExtendedMessageListener)MessageDispatcher.this.msg_listener).setState(is);
                            break;
                        }
                        ((ExtendedMessageListener)MessageDispatcher.this.msg_listener).setState(sti.state_id, is);
                        break;
                    }
                    if (!(MessageDispatcher.this.msg_listener instanceof MessageListener) || !this.log.isWarnEnabled()) break;
                    this.log.warn("Channel has STREAMING_STATE_TRANSFER, however, application does not implement ExtendedMessageListener. State is not transfered");
                    Util.close(is);
                    break;
                }
                case 6: {
                    View v = (View)evt.getArg();
                    Vector<Address> new_mbrs = v.getMembers();
                    MessageDispatcher.this.setMembers(new_mbrs);
                    if (MessageDispatcher.this.membership_listener == null) break;
                    MessageDispatcher.this.membership_listener.viewAccepted(v);
                    break;
                }
                case 8: {
                    if (this.log.isTraceEnabled()) {
                        this.log.trace("setting local_addr (" + MessageDispatcher.this.local_addr + ") to " + evt.getArg());
                    }
                    MessageDispatcher.this.local_addr = (Address)evt.getArg();
                    break;
                }
                case 9: {
                    if (MessageDispatcher.this.membership_listener == null) break;
                    MessageDispatcher.this.membership_listener.suspect((Address)evt.getArg());
                    break;
                }
                case 10: {
                    if (MessageDispatcher.this.membership_listener != null) {
                        MessageDispatcher.this.membership_listener.block();
                    }
                    MessageDispatcher.this.channel.blockOk();
                    break;
                }
                case 75: {
                    if (!(MessageDispatcher.this.membership_listener instanceof ExtendedMembershipListener)) break;
                    ((ExtendedMembershipListener)MessageDispatcher.this.membership_listener).unblock();
                }
            }
            return null;
        }

        @Override
        public Object up(Event evt) {
            if (MessageDispatcher.this.corr != null) {
                if (!MessageDispatcher.this.corr.receive(evt)) {
                    return this.handleUpEvent(evt);
                }
            } else if (this.log.isErrorEnabled()) {
                this.log.error("correlator is null, event will be ignored (evt=" + evt + ")");
            }
            return null;
        }

        @Override
        public Object down(Event evt) {
            if (MessageDispatcher.this.channel != null) {
                return MessageDispatcher.this.channel.downcall(evt);
            }
            if (this.log.isWarnEnabled()) {
                this.log.warn("channel is null, discarding event " + evt);
            }
            return null;
        }
    }
}

