/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.blocks;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.Map;
import org.jgroups.JChannel;
import org.jgroups.blocks.DistributedLockManager;
import org.jgroups.blocks.LockManager;
import org.jgroups.blocks.LockMultiLockedException;
import org.jgroups.blocks.LockNotGrantedException;
import org.jgroups.blocks.LockNotReleasedException;
import org.jgroups.blocks.VotingAdapter;
import org.jgroups.tests.ChannelTestBase;
import org.jgroups.util.Util;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"stack-dependent"}, sequential=true)
public class DistributedLockManagerTest
extends ChannelTestBase {
    private JChannel channel1;
    private JChannel channel2;
    protected VotingAdapter adapter1;
    protected VotingAdapter adapter2;
    protected LockManager lockManager1;
    protected LockManager lockManager2;

    @BeforeClass
    void setUp() throws Exception {
        this.channel1 = this.createChannel(true);
        this.adapter1 = new VotingAdapter(this.channel1);
        this.channel1.connect("DistributedLockManagerTest");
        this.lockManager1 = new DistributedLockManager(this.adapter1, (Object)"1");
        Util.sleep(1000L);
        this.channel2 = this.createChannel(this.channel1);
        this.adapter2 = new VotingAdapter(this.channel2);
        this.lockManager2 = new DistributedLockManager(this.adapter2, (Object)"2");
        this.channel2.connect("DistributedLockManagerTest");
        Util.sleep(1000L);
    }

    @AfterClass
    void tearDown() throws Exception {
        this.channel2.close();
        this.channel1.close();
    }

    public void test() throws Exception {
        this.lockManager1.lock("obj1", "owner1", 10000);
        try {
            this.lockManager1.lock("obj1", "owner2", 10000);
            throw new IllegalStateException("obj1 should not be locked");
        }
        catch (LockNotGrantedException ex) {
            System.out.println("got a lock not granted exception - expected");
            this.lockManager2.lock("obj2", "owner2", 1000);
            this.lockManager1.unlock("obj1", "owner1");
            try {
                this.lockManager1.unlock("obj2", "owner1");
                throw new IllegalStateException("obj2 should not be released");
            }
            catch (LockNotReleasedException ex2) {
                System.out.println("got a lock not released exception, as expected");
                this.lockManager1.unlock("obj2", "owner2");
                return;
            }
        }
    }

    public void testMultiLock() throws Exception {
        this.lockManager1.lock("obj1", "owner1", 10000);
        Class<?> acquireLockDecreeClass = Class.forName("org.jgroups.blocks.DistributedLockManager$AcquireLockDecree");
        Constructor<?> acquireLockDecreeConstructor = acquireLockDecreeClass.getDeclaredConstructor(Object.class, Object.class, Object.class);
        acquireLockDecreeConstructor.setAccessible(true);
        Object acquireLockDecree = acquireLockDecreeConstructor.newInstance("obj1", "owner2", "2");
        Field heldLocksField = this.lockManager2.getClass().getDeclaredField("heldLocks");
        heldLocksField.setAccessible(true);
        Map heldLocks = (Map)heldLocksField.get(this.lockManager2);
        heldLocks.put("obj1", acquireLockDecree);
        try {
            this.lockManager1.unlock("obj1", "owner1", true);
            throw new IllegalStateException("obj1 should throw a lockMultiLockedException upon release");
        }
        catch (LockMultiLockedException e) {
            try {
                this.lockManager1.lock("obj1", "owner1", 10000);
                throw new IllegalStateException("obj1 should throw a LockNotGrantedException because it is still locked by lockManager2");
            }
            catch (LockNotGrantedException e2) {
                try {
                    this.lockManager2.unlock("obj1", "owner2", true);
                    throw new IllegalStateException("obj1 should throw a lockMultiLockedException upon release");
                }
                catch (LockMultiLockedException e3) {
                    try {
                        this.lockManager1.lock("obj1", "owner1", 10000);
                    }
                    catch (LockNotGrantedException e4) {
                        throw new IllegalStateException("obj1 should be unlocked");
                    }
                    this.lockManager1.unlock("obj1", "owner1", true);
                    return;
                }
            }
        }
    }
}

