/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution.ch;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.infinispan.config.Configuration;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.distribution.ch.TopologyInfo;
import org.infinispan.distribution.ch.UnionConsistentHash;
import org.infinispan.remoting.transport.Address;
import org.infinispan.util.Util;

public class ConsistentHashHelper {
    public static ConsistentHash removeAddress(ConsistentHash ch, Address toRemove, Configuration c, TopologyInfo topologyInfo) {
        if (ch instanceof UnionConsistentHash) {
            return ConsistentHashHelper.removeAddressFromUnionConsistentHash((UnionConsistentHash)ch, toRemove, c, topologyInfo);
        }
        ConsistentHash newCH = (ConsistentHash)Util.getInstance(c.getConsistentHashClass());
        ArrayList<Address> caches = new ArrayList<Address>(ch.getCaches());
        caches.remove(toRemove);
        newCH.setCaches(caches);
        newCH.setTopologyInfo(topologyInfo);
        return newCH;
    }

    public static UnionConsistentHash removeAddressFromUnionConsistentHash(UnionConsistentHash uch, Address toRemove, Configuration c, TopologyInfo topologyInfo) {
        ConsistentHash newFirstCH = ConsistentHashHelper.removeAddress(uch.getOldConsistentHash(), toRemove, c, topologyInfo);
        ConsistentHash newSecondCH = ConsistentHashHelper.removeAddress(uch.getNewConsistentHash(), toRemove, c, topologyInfo);
        return new UnionConsistentHash(newFirstCH, newSecondCH);
    }

    public static ConsistentHash createConsistentHash(Configuration c, List<Address> addresses, TopologyInfo topologyInfo) {
        ConsistentHash ch = (ConsistentHash)Util.getInstance(c.getConsistentHashClass());
        ch.setCaches(addresses);
        ch.setTopologyInfo(topologyInfo);
        return ch;
    }

    public static ConsistentHash createConsistentHash(Configuration c, List<Address> addresses, TopologyInfo topologyInfo, Address ... moreAddresses) {
        LinkedList<Address> list = new LinkedList<Address>(addresses);
        list.addAll(Arrays.asList(moreAddresses));
        return ConsistentHashHelper.createConsistentHash(c, list, topologyInfo);
    }

    public static ConsistentHash createConsistentHash(Configuration c, List<Address> addresses, Collection<Address> moreAddresses, TopologyInfo topologyInfo) {
        LinkedList<Address> list = new LinkedList<Address>(addresses);
        list.addAll(moreAddresses);
        return ConsistentHashHelper.createConsistentHash(c, list, topologyInfo);
    }

    public static ConsistentHash createConsistentHash(Class<? extends ConsistentHash> clazz, List<Address> addresses, TopologyInfo topologyInfo) {
        ConsistentHash ch = Util.getInstance(clazz);
        if (addresses != null && !addresses.isEmpty()) {
            ch.setCaches(addresses);
        }
        ch.setTopologyInfo(topologyInfo);
        return ch;
    }

    public static ConsistentHash createConsistentHash(Class<? extends ConsistentHash> clazz, List<Address> addresses, TopologyInfo topologyInfo, Address ... moreAddresses) {
        LinkedList<Address> list = new LinkedList<Address>(addresses);
        list.addAll(Arrays.asList(moreAddresses));
        return ConsistentHashHelper.createConsistentHash(clazz, list, topologyInfo);
    }

    public static ConsistentHash createConsistentHash(Class<? extends ConsistentHash> clazz, List<Address> addresses, Collection<Address> moreAddresses, TopologyInfo topologyInfo) {
        LinkedList<Address> list = new LinkedList<Address>(addresses);
        list.addAll(moreAddresses);
        return ConsistentHashHelper.createConsistentHash(clazz, list, topologyInfo);
    }
}

