/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.switchboard.jbmeta.javaee.environment;

import java.util.Properties;
import org.jboss.metadata.javaee.spec.DataSourceMetaData;
import org.jboss.metadata.javaee.spec.IsolationLevelType;
import org.jboss.metadata.javaee.spec.PropertiesMetaData;
import org.jboss.metadata.javaee.spec.PropertyMetaData;
import org.jboss.switchboard.javaee.environment.ConnectionIsolationLevel;
import org.jboss.switchboard.javaee.environment.DataSourceType;
import org.jboss.switchboard.javaee.util.EnvironmentEntryUtil;

public class DataSourceReference
implements DataSourceType {
    private DataSourceMetaData delegate;
    private Properties properties = new Properties();

    public DataSourceReference(DataSourceMetaData datasourceMetadata) {
        if (datasourceMetadata == null) {
            throw new IllegalArgumentException("DataSourceMetaData cannot be null while creating " + DataSourceReference.class.getName());
        }
        this.delegate = datasourceMetadata;
        this.initProperties();
    }

    public String getClassName() {
        return this.delegate.getClassName();
    }

    public String getDatabaseName() {
        return this.delegate.getDatabaseName();
    }

    public int getInitialPoolSize() {
        return this.delegate.getInitialPoolSize();
    }

    public ConnectionIsolationLevel getIsolationLevel() {
        IsolationLevelType isolation = this.delegate.getIsolationLevel();
        if (isolation == null) {
            return null;
        }
        switch (isolation) {
            case TRANSACTION_READ_COMMITTED: {
                return ConnectionIsolationLevel.TRANSACTION_READ_COMMITTED;
            }
            case TRANSACTION_READ_UNCOMMITTED: {
                return ConnectionIsolationLevel.TRANSACTION_READ_UNCOMMITTED;
            }
            case TRANSACTION_REPEATABLE_READ: {
                return ConnectionIsolationLevel.TRANSACTION_REPEATABLE_READ;
            }
            case TRANSACTION_SERIALIZABLE: {
                return ConnectionIsolationLevel.TRANSACTION_SERIALIZABLE;
            }
        }
        throw new IllegalArgumentException("Unrecognized isolation level: " + isolation.name() + " for datasource " + this.delegate.getName());
    }

    public int getLoginTimeout() {
        return this.delegate.getLoginTimeout();
    }

    public int getMaxIdleTime() {
        return this.delegate.getMaxIdleTime();
    }

    public int getMaxPoolSize() {
        return this.delegate.getMaxPoolSize();
    }

    public int getMaxStatements() {
        return this.delegate.getMaxStatements();
    }

    public int getMinPoolSize() {
        return this.delegate.getMinPoolSize();
    }

    public String getPassword() {
        return this.delegate.getPassword();
    }

    public int getPort() {
        return this.delegate.getPortNumber();
    }

    public Properties getProperties() {
        return this.properties;
    }

    public String getServerName() {
        return this.delegate.getServerName();
    }

    public String getURL() {
        return this.delegate.getUrl();
    }

    public String getUserName() {
        return this.delegate.getUser();
    }

    public boolean isTransactional() {
        return this.delegate.isTransactional();
    }

    public String getName() {
        return EnvironmentEntryUtil.getENCName((String)this.delegate.getName());
    }

    private void initProperties() {
        PropertiesMetaData props = this.delegate.getProperties();
        if (props == null) {
            return;
        }
        for (PropertyMetaData prop : props) {
            if (prop == null) continue;
            this.properties.put(prop.getKey(), prop.getValue());
        }
    }
}

