/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.singleton.impl.container;

import java.io.Serializable;
import java.util.List;
import org.jboss.ejb3.container.spi.BeanContext;
import org.jboss.ejb3.container.spi.EJBContainer;
import org.jboss.ejb3.container.spi.lifecycle.EJBLifecycleHandler;
import org.jboss.ejb3.instantiator.spi.BeanInstantiationException;
import org.jboss.ejb3.instantiator.spi.BeanInstantiator;
import org.jboss.ejb3.instantiator.spi.InvalidConstructionParamsException;
import org.jboss.ejb3.singleton.impl.container.SingletonBeanContext;
import org.jboss.ejb3.singleton.spi.SingletonEJBInstanceManager;
import org.jboss.logging.Logger;

public class SingletonEJBInstanceManagerImpl
implements SingletonEJBInstanceManager {
    private static Logger logger = Logger.getLogger(SingletonEJBInstanceManagerImpl.class);
    protected Class<?> beanClass;
    protected EJBContainer container;
    protected EJBLifecycleHandler beanInstanceLifecycleHandler;
    protected BeanContext singletonBeanContext;
    protected BeanInstantiator beanInstantiator;
    private List<SingletonEJBInstanceManager> dependsOn;

    public SingletonEJBInstanceManagerImpl(Class<?> beanClass, EJBContainer container, EJBLifecycleHandler lifecycleHandler, BeanInstantiator beanInstantiator, List<SingletonEJBInstanceManager> dependsOn) {
        this.beanClass = beanClass;
        this.container = container;
        this.beanInstanceLifecycleHandler = lifecycleHandler;
        this.beanInstantiator = beanInstantiator;
        this.dependsOn = dependsOn;
    }

    public synchronized Serializable create() {
        if (this.singletonBeanContext != null) {
            throw new IllegalStateException("Singleton " + this.container + " was already created");
        }
        if (this.dependsOn != null && !this.dependsOn.isEmpty()) {
            for (SingletonEJBInstanceManager instanceManager : this.dependsOn) {
                logger.debug((Object)("Instantiating @Depends bean: " + instanceManager.getEJBContainer().getEJBName() + " during creation of singleton bean " + this.container.getEJBName()));
                instanceManager.get();
            }
        }
        Object beanInstance = this.createBeanInstance();
        this.singletonBeanContext = this.createBeanContext(beanInstance);
        if (this.beanInstanceLifecycleHandler != null) {
            try {
                this.beanInstanceLifecycleHandler.postConstruct(this.singletonBeanContext);
            }
            catch (Exception e) {
                throw new RuntimeException("Could not invoke PostConstruct on the newly created bean instance", e);
            }
        }
        return this.singletonBeanContext.getSessionId();
    }

    public synchronized BeanContext get() {
        if (this.singletonBeanContext == null) {
            this.create();
        }
        return this.singletonBeanContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        SingletonEJBInstanceManagerImpl singletonEJBInstanceManagerImpl = this;
        synchronized (singletonEJBInstanceManagerImpl) {
            if (this.singletonBeanContext == null) {
                return;
            }
        }
        try {
            this.beanInstanceLifecycleHandler.preDestroy(this.singletonBeanContext);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not preDestroy the singleton bean instance", e);
        }
        singletonEJBInstanceManagerImpl = this;
        synchronized (singletonEJBInstanceManagerImpl) {
            this.singletonBeanContext = null;
        }
    }

    public EJBContainer getEJBContainer() {
        return this.container;
    }

    public void destroy(Serializable sessionId) throws IllegalArgumentException, IllegalStateException {
        throw new IllegalStateException("destroy(sessionId) cannot be called on a singleton bean's instance manager");
    }

    public boolean isSessionAware() {
        return false;
    }

    protected BeanContext createBeanContext(Object beanInstance) {
        return new SingletonBeanContext(beanInstance, this.container);
    }

    protected Object createBeanInstance() {
        if (this.beanInstantiator != null) {
            try {
                return this.beanInstantiator.create(this.beanClass, null);
            }
            catch (IllegalArgumentException iae) {
                throw iae;
            }
            catch (InvalidConstructionParamsException ice) {
                throw ice;
            }
            catch (BeanInstantiationException bie) {
                throw new RuntimeException("Could not create an instance for bean class: " + this.beanClass, bie);
            }
        }
        try {
            logger.debug((Object)("No bean instantiator configured. Using Class.newInstance() to instantiate bean class: " + this.beanClass));
            return this.beanClass.newInstance();
        }
        catch (InstantiationException ie) {
            throw new RuntimeException("Could not create an instance of the bean classs: " + this.beanClass, ie);
        }
        catch (IllegalAccessException iae) {
            throw new RuntimeException("Could not create an instance of the bean class: " + this.beanClass, iae);
        }
    }
}

