/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.services.binding.impl;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import org.jboss.services.binding.ServiceBinding;
import org.jboss.services.binding.ServiceBindingValueSource;
import org.jboss.services.binding.impl.SecurityActions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Util {
    public static final String SERVER_TEMP_DIR_PROPERTY = "jboss.server.temp.dir";

    public static InputStream getInputStream(URL url) throws IOException {
        URLConnection conn = url.openConnection();
        conn.connect();
        return conn.getInputStream();
    }

    public static InputStream getInputStream(String resource) throws IOException {
        try {
            URL url = new URL(resource);
            return Util.getInputStream(url);
        }
        catch (MalformedURLException mue) {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            return cl.getResourceAsStream(resource);
        }
    }

    public static InputStreamReader getInputStreamReader(URL url) throws IOException {
        return new InputStreamReader(Util.getInputStream(url));
    }

    public static InputStreamReader getInputStreamReader(String resource) throws IOException {
        try {
            URL url = new URL(resource);
            return Util.getInputStreamReader(url);
        }
        catch (MalformedURLException mue) {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            InputStream is = cl.getResourceAsStream(resource);
            if (is == null) {
                throw new IllegalArgumentException("No resource " + resource + " found");
            }
            return new InputStreamReader(is);
        }
    }

    public static String getContentAsString(URL url) throws IOException {
        InputStreamReader isr = Util.getInputStreamReader(url);
        return Util.getContentAsString(isr);
    }

    public static String getContentAsString(String resource) throws IOException {
        InputStreamReader isr = Util.getInputStreamReader(resource);
        return Util.getContentAsString(isr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File writeToTempFile(String content) throws IOException {
        File targetFile = Util.createTempFile();
        OutputStreamWriter osw = null;
        try {
            osw = new OutputStreamWriter(new FileOutputStream(targetFile));
            osw.write(content);
            File file = targetFile;
            return file;
        }
        finally {
            if (osw != null) {
                osw.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getContentAsString(InputStreamReader isr) throws IOException {
        try {
            int read;
            StringWriter writer = new StringWriter();
            char[] buf = new char[1024];
            while ((read = isr.read(buf, 0, buf.length)) != -1) {
                writer.write(buf, 0, read);
            }
            String string = writer.toString();
            return string;
        }
        finally {
            isr.close();
        }
    }

    public static File createTempFile() throws IOException {
        String tmpName = SecurityActions.getSystemProperty(SERVER_TEMP_DIR_PROPERTY, null);
        if (tmpName == null) {
            tmpName = SecurityActions.getSystemProperty("java.io.tmpdir", "");
        }
        File tempDirectory = new File(tmpName);
        File targetFile = File.createTempFile("service-binding", ".tmp", tempDirectory);
        targetFile.deleteOnExit();
        return targetFile;
    }

    public static <T> T getBindingValue(ServiceBindingValueSource source, ServiceBinding binding, Class<T> expectedType) {
        Object obj = source.getServiceBindingValue(binding, new Object[0]);
        if (expectedType.isAssignableFrom(obj.getClass())) {
            return expectedType.cast(obj);
        }
        throw new IllegalStateException("Incompatible value source for " + binding + " -- must return " + expectedType.getSimpleName());
    }

    public static <T> T getBindingValueWithInput(ServiceBindingValueSource source, ServiceBinding binding, Object input, Class<T> expectedType) {
        Object obj = source.getServiceBindingValue(binding, input);
        if (expectedType.isAssignableFrom(obj.getClass())) {
            return expectedType.cast(obj);
        }
        throw new IllegalStateException("Incompatible value source for " + binding + " -- must return " + expectedType.getSimpleName());
    }

    private Util() {
    }
}

