/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.metadata.processor;

import org.jboss.logging.Logger;
import org.jboss.metadata.ejb.jboss.JBossEnterpriseBeanMetaData;
import org.jboss.metadata.ejb.jboss.JBossEnterpriseBeansMetaData;
import org.jboss.metadata.ejb.jboss.JBossMessageDrivenBeanMetaData;
import org.jboss.metadata.ejb.jboss.JBossMetaData;
import org.jboss.metadata.process.ProcessingException;
import org.jboss.metadata.process.processor.JBossMetaDataProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultJMSResourceAdapterMetadataProcessor
implements JBossMetaDataProcessor<JBossMetaData> {
    private static Logger logger = Logger.getLogger(DefaultJMSResourceAdapterMetadataProcessor.class);
    private String defaultResourceAdapterName;

    public DefaultJMSResourceAdapterMetadataProcessor(String defaultJMSResourceAdapterName) {
        this.defaultResourceAdapterName = defaultJMSResourceAdapterName;
    }

    public JBossMetaData process(JBossMetaData metadata) throws ProcessingException {
        if (!metadata.isEJB3x()) {
            return metadata;
        }
        JBossEnterpriseBeansMetaData enterpriseBeans = metadata.getEnterpriseBeans();
        if (enterpriseBeans == null) {
            return metadata;
        }
        for (JBossEnterpriseBeanMetaData enterpriseBean : enterpriseBeans) {
            JBossMessageDrivenBeanMetaData messageDrivenBean;
            String raName;
            if (!enterpriseBean.isMessageDriven() || (raName = (messageDrivenBean = (JBossMessageDrivenBeanMetaData)enterpriseBean).getResourceAdapterName()) != null && !raName.trim().isEmpty()) continue;
            messageDrivenBean.setResourceAdapterName(this.defaultResourceAdapterName);
            if (!logger.isTraceEnabled()) continue;
            logger.trace((Object)("Set the default resource adapter name to " + this.defaultResourceAdapterName + " for message driven bean " + messageDrivenBean.getEjbName()));
        }
        return metadata;
    }
}

