/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting3.remote;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InvalidObjectException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.util.Random;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicReference;
import org.jboss.marshalling.AbstractExternalizer;
import org.jboss.marshalling.ByteInput;
import org.jboss.marshalling.ByteOutput;
import org.jboss.marshalling.ClassExternalizerFactory;
import org.jboss.marshalling.Creator;
import org.jboss.marshalling.Externalizer;
import org.jboss.marshalling.Marshaller;
import org.jboss.marshalling.NioByteInput;
import org.jboss.marshalling.NioByteOutput;
import org.jboss.marshalling.Unmarshaller;
import org.jboss.marshalling.util.IntKeyMap;
import org.jboss.remoting3.remote.InboundObjectSinkReceiveTask;
import org.jboss.remoting3.remote.InboundStream;
import org.jboss.remoting3.remote.Loggers;
import org.jboss.remoting3.remote.MarshallerObjectSink;
import org.jboss.remoting3.remote.OutboundInputStreamTransmitTask;
import org.jboss.remoting3.remote.OutboundObjectSourceTransmitTask;
import org.jboss.remoting3.remote.OutboundStream;
import org.jboss.remoting3.remote.ReceivedRequestHandlerConnector;
import org.jboss.remoting3.remote.RemoteConnectionHandler;
import org.jboss.remoting3.remote.RemoteProtocol;
import org.jboss.remoting3.remote.UnmarshallerObjectSource;
import org.jboss.remoting3.remote.UnsentRequestHandlerConnector;
import org.jboss.remoting3.stream.ObjectSink;
import org.jboss.remoting3.stream.ObjectSource;
import org.jboss.remoting3.stream.ReaderInputStream;
import org.jboss.remoting3.stream.WriterOutputStream;
import org.jboss.xnio.IoUtils;
import org.jboss.xnio.log.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class PrimaryExternalizerFactory
implements ClassExternalizerFactory {
    private static final Logger log = Loggers.main;
    private final RemoteConnectionHandler connectionHandler;
    private final Executor executor;
    final Externalizer inputStream = new InputStreamExternalizer();
    final Externalizer outputStream = new OutputStreamExternalizer();
    final Externalizer reader = new ReaderExternalizer();
    final Externalizer writer = new WriterExternalizer();
    final Externalizer objectSource = new ObjectSourceExternalizer();
    final Externalizer objectSink = new ObjectSinkExternalizer();

    PrimaryExternalizerFactory(RemoteConnectionHandler connectionHandler) {
        this.connectionHandler = connectionHandler;
        this.executor = connectionHandler.getConnectionContext().getConnectionProviderContext().getExecutor();
    }

    public Externalizer getExternalizer(Class<?> type) {
        if (type == UnsentRequestHandlerConnector.class) {
            return RequestHandlerConnectorExternalizer.INSTANCE;
        }
        if (InputStream.class.isAssignableFrom(type)) {
            return this.inputStream;
        }
        if (OutputStream.class.isAssignableFrom(type)) {
            return this.outputStream;
        }
        if (Reader.class.isAssignableFrom(type)) {
            return this.reader;
        }
        if (Writer.class.isAssignableFrom(type)) {
            return this.writer;
        }
        if (ObjectSource.class.isAssignableFrom(type)) {
            return this.objectSource;
        }
        if (ObjectSink.class.isAssignableFrom(type)) {
            return this.objectSink;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeInboundStream(ObjectOutput marshaller, final ObjectSink objectSink) throws IOException {
        int id;
        IntKeyMap<InboundStream> inboundStreams = this.connectionHandler.getInboundStreams();
        Random random = this.connectionHandler.getRandom();
        IntKeyMap<InboundStream> intKeyMap = inboundStreams;
        synchronized (intKeyMap) {
            while (inboundStreams.containsKey(id = random.nextInt() & 0xFFFFFFFE)) {
            }
            inboundStreams.put(id, (Object)new InboundStream(id, this.connectionHandler.getRemoteConnection(), new InboundStream.ByteInputResult(){

                public void accept(NioByteInput nioByteInput, InboundStream inboundStream) {
                    try {
                        PrimaryExternalizerFactory.this.executor.execute(new InboundObjectSinkReceiveTask(nioByteInput, inboundStream, PrimaryExternalizerFactory.this.connectionHandler, objectSink));
                    }
                    catch (RejectedExecutionException e) {
                        log.warn("Unable to start task for forwarded stream: %s", (Object)e);
                        inboundStream.sendAsyncException();
                    }
                }
            }));
        }
        marshaller.writeInt(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NioByteInput readInboundStream(int id) throws InvalidObjectException {
        InboundStream inboundStream;
        IntKeyMap<InboundStream> inboundStreams = this.connectionHandler.getInboundStreams();
        final AtomicReference ref = new AtomicReference();
        Object object = inboundStreams;
        synchronized (object) {
            if (inboundStreams.containsKey(id)) {
                throw PrimaryExternalizerFactory.duplicateId(id);
            }
            inboundStream = new InboundStream(id, this.connectionHandler.getRemoteConnection(), new InboundStream.ByteInputResult(){

                public void accept(NioByteInput nioByteInput, InboundStream inboundStream) {
                    ref.set(nioByteInput);
                }
            });
            inboundStreams.put(id, (Object)inboundStream);
        }
        object = inboundStream;
        synchronized (object) {
            inboundStream.sendAsyncStart();
        }
        return (NioByteInput)ref.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeOutboundStream(ObjectOutput marshaller, ObjectSource objectSource) throws IOException {
        OutboundStream outboundStream;
        int id;
        IntKeyMap<OutboundStream> outboundStreams = this.connectionHandler.getOutboundStreams();
        Random random = this.connectionHandler.getRandom();
        IntKeyMap<OutboundStream> intKeyMap = outboundStreams;
        synchronized (intKeyMap) {
            while (outboundStreams.containsKey(id = random.nextInt() | 1)) {
            }
            outboundStream = new OutboundStream(id, this.connectionHandler.getRemoteConnection());
            outboundStreams.put(id, (Object)outboundStream);
        }
        marshaller.writeInt(id);
        try {
            this.executor.execute(new OutboundObjectSourceTransmitTask(objectSource, outboundStream, this.connectionHandler));
        }
        catch (RejectedExecutionException e) {
            log.warn("Unable to start task for forwarded stream: %s", (Object)e);
            outboundStream.sendException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NioByteOutput readOutboundStream(int id) throws InvalidObjectException {
        OutboundStream outboundStream;
        IntKeyMap<OutboundStream> outboundStreams;
        Object object = outboundStreams = this.connectionHandler.getOutboundStreams();
        synchronized (object) {
            if (outboundStreams.containsKey(id)) {
                throw PrimaryExternalizerFactory.duplicateId(id);
            }
            outboundStream = new OutboundStream(id, this.connectionHandler.getRemoteConnection());
            outboundStreams.put(id, (Object)outboundStream);
        }
        object = outboundStream;
        synchronized (object) {
            outboundStream.asyncStart();
        }
        return new NioByteOutput(new NioByteOutput.BufferWriter(){

            public ByteBuffer getBuffer() {
                return outboundStream.getBuffer();
            }

            public void accept(ByteBuffer buffer, boolean eof) throws IOException {
                outboundStream.send(buffer);
                if (eof) {
                    outboundStream.sendEof();
                }
            }

            public void flush() throws IOException {
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeInboundStream(ObjectOutput marshaller, OutputStream outputStream) throws IOException {
        int id;
        IntKeyMap<InboundStream> inboundStreams = this.connectionHandler.getInboundStreams();
        Random random = this.connectionHandler.getRandom();
        IntKeyMap<InboundStream> intKeyMap = inboundStreams;
        synchronized (intKeyMap) {
            while (inboundStreams.containsKey(id = random.nextInt() & 0xFFFFFFFE)) {
            }
            inboundStreams.put(id, (Object)new InboundStream(id, this.connectionHandler.getRemoteConnection(), outputStream));
        }
        marshaller.writeInt(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeOutboundStream(ObjectOutput marshaller, InputStream inputStream) throws IOException {
        OutboundStream outboundStream;
        int id;
        IntKeyMap<OutboundStream> outboundStreams = this.connectionHandler.getOutboundStreams();
        Random random = this.connectionHandler.getRandom();
        IntKeyMap<OutboundStream> intKeyMap = outboundStreams;
        synchronized (intKeyMap) {
            while (outboundStreams.containsKey(id = random.nextInt() | 1)) {
            }
            outboundStream = new OutboundStream(id, this.connectionHandler.getRemoteConnection());
            outboundStreams.put(id, (Object)outboundStream);
        }
        marshaller.writeInt(id);
        try {
            this.executor.execute(new OutboundInputStreamTransmitTask(inputStream, outboundStream));
        }
        catch (RejectedExecutionException e) {
            log.warn("Unable to start task for forwarded stream: %s", (Object)e);
            outboundStream.sendException();
        }
    }

    private static InvalidObjectException duplicateId(int id) {
        return new InvalidObjectException("Duplicated stream ID " + id);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ObjectSinkExternalizer
    extends AbstractExternalizer {
        ObjectSinkExternalizer() {
        }

        public void writeExternal(Object subject, ObjectOutput output) throws IOException {
            PrimaryExternalizerFactory.this.writeInboundStream(output, (ObjectSink)subject);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ObjectSink createExternal(Class<?> subjectType, ObjectInput input, Creator defaultCreator) throws IOException, ClassNotFoundException {
            boolean ok = false;
            Marshaller marshaller = PrimaryExternalizerFactory.this.connectionHandler.getMarshallerFactory().createMarshaller(PrimaryExternalizerFactory.this.connectionHandler.getMarshallingConfiguration());
            try {
                marshaller.start((ByteOutput)PrimaryExternalizerFactory.this.readOutboundStream(input.readInt()));
                MarshallerObjectSink marshallerObjectSink = new MarshallerObjectSink(marshaller);
                return marshallerObjectSink;
            }
            finally {
                if (!ok) {
                    IoUtils.safeClose((Closeable)marshaller);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ObjectSourceExternalizer
    extends AbstractExternalizer {
        ObjectSourceExternalizer() {
        }

        public void writeExternal(Object subject, ObjectOutput output) throws IOException {
            PrimaryExternalizerFactory.this.writeOutboundStream(output, (ObjectSource)subject);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ObjectSource createExternal(Class<?> subjectType, ObjectInput input, Creator defaultCreator) throws IOException, ClassNotFoundException {
            boolean ok = false;
            Unmarshaller unmarshaller = PrimaryExternalizerFactory.this.connectionHandler.getMarshallerFactory().createUnmarshaller(PrimaryExternalizerFactory.this.connectionHandler.getMarshallingConfiguration());
            try {
                unmarshaller.start((ByteInput)PrimaryExternalizerFactory.this.readInboundStream(input.readInt()));
                UnmarshallerObjectSource unmarshallerObjectSource = new UnmarshallerObjectSource(unmarshaller);
                return unmarshallerObjectSource;
            }
            finally {
                if (!ok) {
                    IoUtils.safeClose((Closeable)unmarshaller);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class WriterExternalizer
    extends AbstractExternalizer {
        WriterExternalizer() {
        }

        public void writeExternal(Object subject, ObjectOutput output) throws IOException {
            PrimaryExternalizerFactory.this.writeInboundStream(output, new WriterOutputStream((Writer)subject, RemoteProtocol.UTF_8));
        }

        public Writer createExternal(Class<?> subjectType, ObjectInput input, Creator defaultCreator) throws IOException, ClassNotFoundException {
            return new OutputStreamWriter((OutputStream)PrimaryExternalizerFactory.this.readOutboundStream(input.readInt()), RemoteProtocol.UTF_8);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ReaderExternalizer
    extends AbstractExternalizer {
        ReaderExternalizer() {
        }

        public void writeExternal(Object subject, ObjectOutput output) throws IOException {
            PrimaryExternalizerFactory.this.writeOutboundStream(output, new ReaderInputStream((Reader)subject, RemoteProtocol.UTF_8));
        }

        public Reader createExternal(Class<?> subjectType, ObjectInput input, Creator defaultCreator) throws IOException, ClassNotFoundException {
            return new InputStreamReader((InputStream)PrimaryExternalizerFactory.this.readInboundStream(input.readInt()), RemoteProtocol.UTF_8);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class OutputStreamExternalizer
    extends AbstractExternalizer {
        OutputStreamExternalizer() {
        }

        public void writeExternal(Object subject, ObjectOutput output) throws IOException {
            PrimaryExternalizerFactory.this.writeInboundStream(output, (OutputStream)subject);
        }

        public OutputStream createExternal(Class<?> subjectType, ObjectInput input, Creator defaultCreator) throws IOException, ClassNotFoundException {
            return PrimaryExternalizerFactory.this.readOutboundStream(input.readInt());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class InputStreamExternalizer
    extends AbstractExternalizer {
        InputStreamExternalizer() {
        }

        public void writeExternal(Object subject, ObjectOutput output) throws IOException {
            PrimaryExternalizerFactory.this.writeOutboundStream(output, (InputStream)subject);
        }

        public InputStream createExternal(Class<?> subjectType, ObjectInput input, Creator defaultCreator) throws IOException, ClassNotFoundException {
            return PrimaryExternalizerFactory.this.readInboundStream(input.readInt());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class RequestHandlerConnectorExternalizer
    extends AbstractExternalizer {
        static final RequestHandlerConnectorExternalizer INSTANCE = new RequestHandlerConnectorExternalizer();
        private static final long serialVersionUID = 8137262079765758375L;

        RequestHandlerConnectorExternalizer() {
        }

        public void writeExternal(Object subject, ObjectOutput output) throws IOException {
            UnsentRequestHandlerConnector connector = (UnsentRequestHandlerConnector)subject;
            output.writeInt(connector.getClientId());
        }

        public Object createExternal(Class<?> subjectType, ObjectInput input, Creator defaultCreator) throws IOException, ClassNotFoundException {
            return new ReceivedRequestHandlerConnector(RemoteConnectionHandler.getCurrent(), input.readInt());
        }
    }
}

